/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.tests;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.tests.AbstractTest;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.version.Markers;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.oomph.version.ui.quickfixes.VersionResolutionGenerator;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionBuilderExecutor
extends TestCase {
    private static final IWorkspace WORKSPACE = ResourcesPlugin.getWorkspace();
    private static final IWorkspaceRoot ROOT = WORKSPACE.getRoot();
    private static final File WORKSPACE_FOLDER = ROOT.getLocation().toFile();
    private static final int TRIM_LENGTH = WORKSPACE_FOLDER.getAbsolutePath().length();
    private static final String DELETE_SUFFIX = "-DELETE";
    private static final VersionResolutionGenerator FIX_GENERATOR = new VersionResolutionGenerator();
    private static final String FIX_PREFIX = "*";
    private static final String CHAR_START = "<charStart>";
    private static final String CHAR_END = "<charEnd>";
    private static final String SEVERITY = "<severity>";
    private static final String MESSAGE = "<message>";
    private static String lineDelimiter;
    private OomphPlugin.BundleFile testFolder;

    public VersionBuilderExecutor(OomphPlugin.BundleFile testFolder) {
        super(testFolder.getName());
        this.testFolder = testFolder;
    }

    public void runBare() throws Throwable {
        AbstractTest.log((Object)"===============================================================================================");
        AbstractTest.log((Object)("Test " + this.getName()));
        AbstractTest.log((Object)"===============================================================================================");
        this.clearWorkspace();
        boolean clean = true;
        for (OomphPlugin.BundleFile phase : this.testFolder.getChildren()) {
            if (!phase.isDirectory()) continue;
            AbstractTest.log((Object)("  Phase '" + phase.getName() + "'"));
            this.runPhase(phase, clean);
            clean = false;
        }
        AbstractTest.log();
    }

    private void runPhase(OomphPlugin.BundleFile phase, boolean clean) throws Throwable {
        int fixAttempt = 0;
        String fileName = "build";
        String lastContents = "";
        AbstractTest.log((Object)"    Update workspace");
        this.updateWorkspace(phase);
        while (true) {
            boolean hasFixes;
            if (phase.getName().startsWith("clean") || phase.getChild("build.clean") != null) {
                clean = true;
            }
            IMarker[] markers = this.buildWorkspace(phase, clean);
            String contents = this.processMarkers(phase, markers, fileName);
            if (markers.length == 0 || contents.equals(lastContents) || !(hasFixes = this.processFixes(phase, markers, contents, fileName))) break;
            clean = false;
            fileName = "fix" + ++fixAttempt;
            lastContents = contents;
        }
    }

    private void clearWorkspace() throws Throwable {
        WORKSPACE.getDescription().setAutoBuilding(false);
        ResourcesUtil.clearWorkspace();
    }

    private void updateWorkspace(final OomphPlugin.BundleFile phase) throws Throwable {
        WORKSPACE.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    VersionBuilderExecutor.this.updateWorkspace(phase, WORKSPACE_FOLDER, 0);
                    File[] fileArray = WORKSPACE_FOLDER.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        String name = file.getName();
                        if (file.isDirectory() && !".metadata".equals(name)) {
                            IProject project = ROOT.getProject(name);
                            if (project.exists()) {
                                if (project.isOpen()) {
                                    project.refreshLocal(2, monitor);
                                } else {
                                    project.open(monitor);
                                }
                            } else {
                                project.create(monitor);
                                project.open(monitor);
                            }
                        }
                        ++n2;
                    }
                    fileArray = ROOT.getProjects();
                    n = fileArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        File project = fileArray[n2];
                        if (phase.getChild(String.valueOf(project.getName()) + VersionBuilderExecutor.DELETE_SUFFIX) != null) {
                            project.delete(true, null);
                        }
                        ++n2;
                    }
                }
                catch (CoreException ex) {
                    throw ex;
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, null);
    }

    private void updateWorkspace(OomphPlugin.BundleFile source, File target, int level) throws Throwable {
        String relativePath = VersionBuilderExecutor.getRelativePath(target);
        if (source.getName().endsWith(DELETE_SUFFIX)) {
            VersionBuilderExecutor.log("- " + relativePath.substring(0, relativePath.length() - DELETE_SUFFIX.length()));
            IOUtil.deleteBestEffort((File)target);
            return;
        }
        if (source.isDirectory()) {
            if (!target.exists()) {
                VersionBuilderExecutor.log("+ " + relativePath);
                target.mkdir();
            }
            for (OomphPlugin.BundleFile sourceChild : source.getChildren()) {
                File targetChild = new File(target, sourceChild.getName());
                this.updateWorkspace(sourceChild, targetChild, level + 1);
            }
        } else if (level > 1) {
            if (!target.exists()) {
                VersionBuilderExecutor.log("+ " + relativePath);
            } else {
                VersionBuilderExecutor.log("* " + relativePath);
            }
            source.export(target);
        }
    }

    private IMarker[] buildWorkspace(OomphPlugin.BundleFile phase, boolean clean) throws Throwable {
        AbstractTest.log((Object)("    Build " + (clean ? "clean" : "incremental")));
        long start = System.currentTimeMillis();
        IMarker[] markers = ResourcesUtil.buildWorkspace((boolean)clean, (String)"org.eclipse.oomph.version.VersionProblem");
        VersionBuilderExecutor.log("Took " + (System.currentTimeMillis() - start) + " millis");
        return markers;
    }

    private String processMarkers(OomphPlugin.BundleFile phase, IMarker[] markers, String fileName) throws Throwable {
        OomphPlugin.BundleFile markersFile = phase.getChild(fileName = String.valueOf(fileName) + ".markers");
        if (markersFile != null) {
            AbstractTest.log((Object)("    Check " + fileName));
            return this.checkMarkers(phase, markers, markersFile);
        }
        AbstractTest.log((Object)("    Generate " + fileName));
        return this.generateMarkers(phase, markers, fileName);
    }

    private String checkMarkers(OomphPlugin.BundleFile phase, IMarker[] markers, OomphPlugin.BundleFile markersFile) throws Throwable {
        String expected = markersFile.getContentsString();
        String actual = this.createMarkers(markers);
        VersionBuilderExecutor.assertEquals((String)("In " + markersFile), (String)expected, (String)actual);
        return actual;
    }

    private String generateMarkers(OomphPlugin.BundleFile phase, IMarker[] markers, String fileName) throws Throwable {
        String contents = this.createMarkers(markers);
        OomphPlugin.BundleFile resultsFile = phase.addChild(fileName, false);
        resultsFile.setContents(contents);
        return contents;
    }

    private String createMarkers(IMarker[] markers) throws Throwable {
        if (markers.length == 0) {
            VersionBuilderExecutor.log("No markers");
            return "";
        }
        Arrays.sort(markers, new Comparator<IMarker>(){

            @Override
            public int compare(IMarker m1, IMarker m2) {
                int result = Markers.compareAttributes((String)"<resource>", (IMarker)m1, (IMarker)m2);
                if (result == 0 && (result = Markers.compareAttributes((String)"lineNumber", (IMarker)m1, (IMarker)m2)) == 0 && (result = Markers.compareAttributes((String)"charStart", (IMarker)m1, (IMarker)m2)) == 0) {
                    result = Markers.compareAttributes((String)"problemType", (IMarker)m1, (IMarker)m2);
                }
                return result;
            }
        });
        FileContentsProvider fileContentsProvider = new FileContentsProvider();
        StringBuilder builder = new StringBuilder();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            IFile file = (IFile)marker.getResource();
            if (lineDelimiter == null) {
                lineDelimiter = VersionUtil.getLineDelimiter((IFile)file);
            }
            VersionBuilderExecutor.log("Marker");
            builder.append("Marker");
            builder.append(lineDelimiter);
            VersionBuilderExecutor.addAttribute(builder, "<resource> ", file.getFullPath().makeRelative(), true);
            Map attributes = marker.getAttributes();
            ArrayList<String> keys = new ArrayList<String>(attributes.keySet());
            keys.remove("lineNumber");
            this.addLocationAttributes(builder, attributes, keys, file, fileContentsProvider, true);
            if (keys.remove("severity")) {
                int severity = (Integer)attributes.get("severity");
                VersionBuilderExecutor.addAttribute(builder, "<severity> ", VersionBuilderExecutor.getSeverityLabel(severity), true);
            }
            if (keys.remove("message")) {
                VersionBuilderExecutor.addAttribute(builder, "<message>  ", attributes.get("message"), true);
            }
            if (keys.remove("problemType")) {
                VersionBuilderExecutor.addAttribute(builder, "problemType", attributes.get("problemType"), true);
            }
            Collections.sort(keys);
            for (String key : keys) {
                Object value = attributes.get(key);
                VersionBuilderExecutor.addAttribute(builder, key, value, true);
            }
            IMarkerResolution[] resolutions = FIX_GENERATOR.getResolutions(marker);
            if (resolutions != null && resolutions.length != 0) {
                VersionBuilderExecutor.assertTrue((String)"Marker has resolutions but hasResolutions() returns false", (boolean)FIX_GENERATOR.hasResolutions(marker));
                IMarkerResolution[] iMarkerResolutionArray = resolutions;
                int n3 = resolutions.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMarkerResolution resolution = iMarkerResolutionArray[n4];
                    VersionBuilderExecutor.addFix(builder, resolution);
                    ++n4;
                }
            }
            ++n2;
        }
        return builder.toString();
    }

    private boolean addLocationAttributes(StringBuilder builder, Map<String, Object> attributes, List<String> keys, IFile file, FileContentsProvider fileContentsProvider, boolean msg) throws CoreException, IOException {
        if (keys.remove("charStart")) {
            Object charStartAttribute = attributes.get("charStart");
            if (charStartAttribute == null) {
                return false;
            }
            int indexStart = (Integer)charStartAttribute;
            int indexEnd = -1;
            if (keys.remove("charEnd")) {
                indexEnd = (Integer)attributes.get("charEnd");
            }
            String contents = fileContentsProvider.getContents(file);
            int size = contents.length();
            int i = 0;
            int lf = 1;
            int cr = 1;
            int column = 0;
            while (i < size) {
                char c = contents.charAt(i);
                if (c == '\n') {
                    ++lf;
                    column = 1;
                } else if (c == '\r') {
                    ++cr;
                    column = 1;
                }
                if (i == indexStart || i == indexEnd) {
                    String value = "(" + Math.max(cr, lf) + "," + column + ")";
                    if (i == indexStart) {
                        VersionBuilderExecutor.addAttribute(builder, CHAR_START, value, msg);
                        if (indexEnd == -1) {
                            break;
                        }
                    } else {
                        VersionBuilderExecutor.addAttribute(builder, "<charEnd>  ", value, msg);
                        break;
                    }
                }
                ++i;
                ++column;
            }
        }
        return true;
    }

    private boolean processFixes(OomphPlugin.BundleFile phase, IMarker[] markers, String contents, String fileName) throws Throwable {
        OomphPlugin.BundleFile resolutionsFile = phase.getChild(fileName = String.valueOf(fileName) + ".resolutions");
        if (resolutionsFile != null) {
            AbstractTest.log((Object)("    Apply " + fileName));
            return this.applyFixes(phase, markers, resolutionsFile);
        }
        AbstractTest.log((Object)("    Generate " + fileName));
        this.generateFixes(phase, contents, fileName);
        return false;
    }

    private boolean applyFixes(OomphPlugin.BundleFile phase, IMarker[] markers, OomphPlugin.BundleFile resolutionsFile) throws Throwable {
        boolean hasFixes = false;
        IPath path = null;
        String location = null;
        String problemType = null;
        String contents = resolutionsFile.getContentsString();
        String[] lines = contents.split("[\n\r]");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith("<resource>")) {
                path = new Path(VersionBuilderExecutor.parseValue(line)).makeAbsolute();
            }
            if (line.startsWith(CHAR_START)) {
                location = VersionBuilderExecutor.parseValue(line);
            }
            if (line.startsWith("problemType")) {
                problemType = VersionBuilderExecutor.parseValue(line);
            }
            if (line.startsWith(FIX_PREFIX)) {
                hasFixes = true;
                String fix = VersionBuilderExecutor.parseValue(line);
                this.applyFix(phase, markers, path, location, problemType, fix);
                path = null;
                location = null;
                problemType = null;
            }
            ++i;
        }
        return hasFixes;
    }

    private void applyFix(OomphPlugin.BundleFile phase, IMarker[] markers, IPath path, String location, String problemType, String fix) throws Throwable {
        FileContentsProvider fileContentsProvider = new FileContentsProvider();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            String markerProblemType;
            IMarker marker = iMarkerArray[n2];
            IFile file = (IFile)marker.getResource();
            if (file.getFullPath().equals((Object)path) && VersionUtil.equals((Object)(markerProblemType = Markers.getProblemType((IMarker)marker)), (Object)problemType)) {
                Map attributes = marker.getAttributes();
                ArrayList<String> keys = new ArrayList<String>();
                keys.add("charStart");
                StringBuilder builder = new StringBuilder();
                boolean added = this.addLocationAttributes(builder, attributes, keys, file, fileContentsProvider, false);
                if (!added || VersionUtil.equals((Object)VersionBuilderExecutor.parseValue(builder.toString()), (Object)location)) {
                    this.applyFix(phase, marker, fix);
                    return;
                }
            }
            ++n2;
        }
    }

    private void applyFix(OomphPlugin.BundleFile phase, IMarker marker, String fix) throws Throwable {
        IMarkerResolution[] resolutions;
        IMarkerResolution[] iMarkerResolutionArray = resolutions = FIX_GENERATOR.getResolutions(marker);
        int n = resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerResolution resolution = iMarkerResolutionArray[n2];
            StringBuilder builder = new StringBuilder();
            VersionBuilderExecutor.addFix(builder, resolution);
            String resolutionFix = VersionBuilderExecutor.parseValue(builder.toString());
            if (VersionUtil.equals((Object)resolutionFix, (Object)fix)) {
                resolution.run(marker);
                return;
            }
            ++n2;
        }
        throw new IllegalStateException("No resolution found for '" + fix + "'");
    }

    private void generateFixes(OomphPlugin.BundleFile phase, String contents, String fileName) throws Throwable {
        OomphPlugin.BundleFile resolutionsFile = phase.addChild(fileName, false);
        resolutionsFile.setContents(contents);
    }

    private static void addAttribute(StringBuilder builder, String key, Object value, boolean msg) {
        String str = "  " + key + " = " + value;
        if (msg) {
            VersionBuilderExecutor.log(str);
        }
        builder.append(str);
        builder.append(lineDelimiter);
    }

    private static void addFix(StringBuilder builder, IMarkerResolution resolution) {
        String str = "  FIX = " + resolution.getLabel();
        if (resolution instanceof IMarkerResolution2) {
            IMarkerResolution2 resolution2 = (IMarkerResolution2)resolution;
            str = String.valueOf(str) + " (" + resolution2.getDescription() + ")";
        }
        VersionBuilderExecutor.log(str);
        builder.append(str);
        builder.append(lineDelimiter);
    }

    private static Object getSeverityLabel(int severity) {
        switch (severity) {
            case 0: {
                return "INFO";
            }
            case 1: {
                return "WARNING";
            }
            case 2: {
                return "ERROR";
            }
        }
        throw new IllegalStateException("Illegal severity code " + severity);
    }

    private static String getRelativePath(File file) {
        return file.getAbsolutePath().substring(TRIM_LENGTH).replace('\\', '/');
    }

    private static String parseValue(String str) {
        int pos = str.indexOf(61);
        if (pos == -1) {
            throw new IllegalArgumentException("Property syntax error");
        }
        return str.substring(pos + 1).trim();
    }

    private static void log(String string) {
        AbstractTest.log((Object)("      " + string));
    }

    private static class FileContentsProvider {
        private IFile file;
        private String contents;

        private FileContentsProvider() {
        }

        public String getContents(IFile file) throws CoreException, IOException {
            if (!VersionUtil.equals((Object)this.file, (Object)file)) {
                this.contents = VersionUtil.getContents((IFile)file);
                this.file = file;
            }
            return this.contents;
        }
    }
}

