/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.base.impl;

import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.impl.AnnotationImpl;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.base.impl.StringToStringMapEntryImpl;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseFactoryImpl
extends EFactoryImpl
implements BaseFactory {
    private static final Pattern OS_SPECIFIC_LINE_SEPARATOR_PATTERN = Pattern.compile(StringUtil.NL);
    private static final Pattern NORMALIZED_LINE_SEPARATOR_PATTERN = Pattern.compile("\n");
    private static final boolean NEEDS_CONVERSION = !"\n".equals(StringUtil.NL);

    public static BaseFactory init() {
        try {
            BaseFactory theBaseFactory = (BaseFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/oomph/base/1.0");
            if (theBaseFactory != null) {
                return theBaseFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new BaseFactoryImpl();
    }

    public EObject createGen(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createAnnotation();
            }
            case 2: {
                return (EObject)this.createStringToStringMapEntry();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public EObject create(EClass eClass) {
        if (eClass == BasePackage.Literals.MODEL_ELEMENT) {
            return new ModelElementImpl(){};
        }
        return this.createGen(eClass);
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.createURIFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createExceptionFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createTextFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.convertURIToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertExceptionToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertTextToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Annotation createAnnotation() {
        AnnotationImpl annotation = new AnnotationImpl();
        return annotation;
    }

    @Override
    public Annotation createAnnotation(String source) {
        Annotation annotation = this.createAnnotation();
        annotation.setSource(source);
        return annotation;
    }

    @Override
    public Annotation createErrorAnnotation(String diagnostic) {
        Annotation annotation = this.createAnnotation("http://www.eclipse.org/oomph/base/Error");
        annotation.getDetails().put((Object)"diagnostic", (Object)diagnostic);
        return annotation;
    }

    @Override
    public Annotation createWarningAnnotation(String diagnostic) {
        Annotation annotation = this.createAnnotation("http://www.eclipse.org/oomph/base/Warning");
        annotation.getDetails().put((Object)"diagnostic", (Object)diagnostic);
        return annotation;
    }

    @Override
    public Annotation createInfoAnnotation(String diagnostic) {
        Annotation annotation = this.createAnnotation("http://www.eclipse.org/oomph/base/Info");
        annotation.getDetails().put((Object)"diagnostic", (Object)diagnostic);
        return annotation;
    }

    public Map.Entry<String, String> createStringToStringMapEntry() {
        StringToStringMapEntryImpl stringToStringMapEntry = new StringToStringMapEntryImpl();
        return stringToStringMapEntry;
    }

    @Override
    public URI createURI(String literal) {
        return literal == null ? null : URI.createURI((String)literal);
    }

    public URI createURIFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : URI.createURI((String)initialValue);
    }

    @Override
    public String convertURI(URI instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String convertURIToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public Exception createException(String literal) {
        return (Exception)super.createFromString(BasePackage.Literals.EXCEPTION, literal);
    }

    public Exception createExceptionFromString(EDataType eDataType, String initialValue) {
        return this.createException(initialValue);
    }

    @Override
    public String convertException(Exception instanceValue) {
        return super.convertToString(BasePackage.Literals.EXCEPTION, (Object)instanceValue);
    }

    public String convertExceptionToString(EDataType eDataType, Object instanceValue) {
        return this.convertException((Exception)instanceValue);
    }

    @Override
    public String createText(String literal) {
        return literal == null ? null : (NEEDS_CONVERSION ? OS_SPECIFIC_LINE_SEPARATOR_PATTERN.matcher(literal).replaceAll("\n") : literal);
    }

    public String createTextFromString(EDataType eDataType, String initialValue) {
        return this.createText(initialValue);
    }

    @Override
    public String convertText(String instanceValue) {
        return instanceValue == null ? null : (NEEDS_CONVERSION ? NORMALIZED_LINE_SEPARATOR_PATTERN.matcher(instanceValue).replaceAll(StringUtil.NL) : instanceValue);
    }

    public String convertTextToString(EDataType eDataType, Object instanceValue) {
        return this.convertText((String)instanceValue);
    }

    @Override
    public BasePackage getBasePackage() {
        return (BasePackage)this.getEPackage();
    }

    @Deprecated
    public static BasePackage getPackage() {
        return BasePackage.eINSTANCE;
    }
}

