/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.mode;

import java.util.EnumMap;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.mode.IModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.mode.Mode;
import org.eclipse.nebula.widgets.nattable.util.PlatformHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;

public class ModeSupport
implements KeyListener,
MouseListener,
MouseMoveListener,
MouseTrackListener,
FocusListener {
    private EnumMap<Mode, IModeEventHandler> modeEventHandlerMap = new EnumMap(Mode.class);
    private IModeEventHandler currentModeEventHandler;

    public ModeSupport(NatTable natTable) {
        natTable.addKeyListener(this);
        natTable.addMouseListener(this);
        natTable.addFocusListener(this);
        PlatformHelper.callSetter((Object)natTable, "addMouseMoveListener", MouseMoveListener.class, this);
        PlatformHelper.callSetter((Object)natTable, "addMouseTrackListener", MouseTrackListener.class, this);
    }

    public void registerModeEventHandler(Mode mode, IModeEventHandler modeEventHandler) {
        this.modeEventHandlerMap.put(mode, modeEventHandler);
    }

    public void switchMode(Mode mode) {
        if (this.currentModeEventHandler != null) {
            this.currentModeEventHandler.cleanup();
        }
        this.currentModeEventHandler = this.modeEventHandlerMap.get((Object)mode);
    }

    public void switchMode(IModeEventHandler modeEventHandler) {
        if (this.currentModeEventHandler != null) {
            this.currentModeEventHandler.cleanup();
        }
        this.currentModeEventHandler = modeEventHandler;
    }

    public void keyPressed(KeyEvent event) {
        this.currentModeEventHandler.keyPressed(event);
    }

    public void keyReleased(KeyEvent event) {
        this.currentModeEventHandler.keyReleased(event);
    }

    public void mouseDoubleClick(MouseEvent event) {
        this.modifyMouseEventForMac(event);
        this.currentModeEventHandler.mouseDoubleClick(event);
    }

    public void mouseDown(MouseEvent event) {
        this.modifyMouseEventForMac(event);
        this.currentModeEventHandler.mouseDown(event);
    }

    public void mouseUp(MouseEvent event) {
        this.modifyMouseEventForMac(event);
        this.currentModeEventHandler.mouseUp(event);
    }

    public void mouseMove(MouseEvent event) {
        this.modifyMouseEventForMac(event);
        this.currentModeEventHandler.mouseMove(event);
    }

    public void mouseEnter(MouseEvent e) {
        this.currentModeEventHandler.mouseEnter(e);
    }

    public void mouseExit(MouseEvent e) {
        this.currentModeEventHandler.mouseExit(e);
    }

    public void mouseHover(MouseEvent e) {
        this.currentModeEventHandler.mouseHover(e);
    }

    public void focusGained(FocusEvent event) {
        this.currentModeEventHandler.focusGained(event);
    }

    public void focusLost(FocusEvent event) {
        this.currentModeEventHandler.focusLost(event);
    }

    private void modifyMouseEventForMac(MouseEvent event) {
        if (PlatformHelper.isMAC() && event.stateMask == SWT.MOD4 && event.button == 1) {
            event.stateMask &= ~SWT.MOD4;
            event.button = 3;
        }
    }
}

