/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.creole.internal.phrase;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class SimplePhraseModifier
extends PatternBasedElement {
    private static final int CONTENT_GROUP = 1;
    private static final String NOT_A_LINK = "(?<!https?://)";
    private final String delimiter;
    private final DocumentBuilder.SpanType[] spanType;
    private final boolean nesting;

    public SimplePhraseModifier(String delimiter, DocumentBuilder.SpanType spanType) {
        this(delimiter, new DocumentBuilder.SpanType[]{spanType});
    }

    public SimplePhraseModifier(String delimiter, DocumentBuilder.SpanType spanType, boolean nesting) {
        this(delimiter, new DocumentBuilder.SpanType[]{spanType}, nesting);
    }

    public SimplePhraseModifier(String delimiter, DocumentBuilder.SpanType[] spanType) {
        this(delimiter, spanType, false);
    }

    public SimplePhraseModifier(String delimiter, DocumentBuilder.SpanType[] spanType, boolean nesting) {
        this.delimiter = delimiter;
        this.spanType = spanType;
        this.nesting = nesting;
    }

    protected String getPattern(int groupOffset) {
        return Pattern.quote(this.delimiter) + NOT_A_LINK + "(.*?)(?>" + Pattern.quote(this.delimiter) + NOT_A_LINK + "|$)";
    }

    protected int getPatternGroupCount() {
        return 1;
    }

    protected static String getContent(PatternBasedElementProcessor processor) {
        return processor.group(1);
    }

    protected static int getStart(PatternBasedElementProcessor processor) {
        return processor.start(1);
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new SimplePhraseModifierProcessor(this.spanType, this.nesting);
    }

    private static class SimplePhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private final DocumentBuilder.SpanType[] spanType;
        private final boolean nesting;

        public SimplePhraseModifierProcessor(DocumentBuilder.SpanType[] spanType, boolean nesting) {
            this.spanType = spanType;
            this.nesting = nesting;
        }

        public void emit() {
            for (DocumentBuilder.SpanType type : this.spanType) {
                this.getBuilder().beginSpan(type, new Attributes());
            }
            if (this.nesting) {
                this.getMarkupLanguage().emitMarkupLine(this.parser, this.state, SimplePhraseModifier.getStart(this), SimplePhraseModifier.getContent(this), 0);
            } else {
                this.getMarkupLanguage().emitMarkupText(this.parser, this.state, SimplePhraseModifier.getContent(this));
            }
            for (int x = 0; x < this.spanType.length; ++x) {
                this.getBuilder().endSpan();
            }
        }
    }
}

