/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.hyperlinking;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.typesystem.computation.IAmbiguousLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ISuspiciouslyOverloadedCandidate;
import org.eclipse.xtext.xbase.ui.navigation.XbaseHyperLinkHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendHyperlinkHelper
extends XbaseHyperLinkHelper {
    @Inject
    private IJvmModelAssociations associations;

    public void createHyperlinksTo(XtextResource from, Region region, EObject to, IHyperlinkAcceptor acceptor) {
        Set sourceElements = this.associations.getSourceElements(to);
        if (sourceElements.isEmpty()) {
            super.createHyperlinksTo(from, region, to, acceptor);
        } else {
            for (EObject sourceElement : sourceElements) {
                super.createHyperlinksTo(from, region, sourceElement, acceptor);
            }
        }
    }

    protected void createHyperlinksForCrossRef(XtextResource resource, INode crossRefNode, IHyperlinkAcceptor acceptor) {
        EObject crossLinkedEObject = this.getEObjectAtOffsetHelper().getCrossReferencedElement(crossRefNode);
        if (crossLinkedEObject != null && !crossLinkedEObject.eIsProxy()) {
            EObject containedElementAt = this.getEObjectAtOffsetHelper().resolveContainedElementAt(resource, crossRefNode.getOffset());
            if (containedElementAt instanceof XAbstractFeatureCall) {
                XAbstractFeatureCall casted = (XAbstractFeatureCall)containedElementAt;
                if (casted.getFeature() == crossLinkedEObject) {
                    IFeatureLinkingCandidate candidate = this.getBatchTypeResolver().resolveTypes((EObject)casted).getLinkingCandidate(casted);
                    if (candidate instanceof IAmbiguousLinkingCandidate) {
                        this.createMultipleLinks(resource, crossRefNode, ((IAmbiguousLinkingCandidate)candidate).getAlternatives(), acceptor);
                    } else if (candidate instanceof ISuspiciouslyOverloadedCandidate) {
                        ISuspiciouslyOverloadedCandidate castedCandidate = (ISuspiciouslyOverloadedCandidate)candidate;
                        this.createMultipleLinks(resource, crossRefNode, Lists.newArrayList((Object[])new ILinkingCandidate[]{castedCandidate.getChosenCandidate(), castedCandidate.getRejectedCandidate()}), acceptor);
                    } else {
                        this.createHyperlinksTo(resource, crossRefNode, crossLinkedEObject, acceptor);
                    }
                }
            } else if (containedElementAt instanceof XConstructorCall) {
                XConstructorCall casted = (XConstructorCall)containedElementAt;
                if (casted.getConstructor() == crossLinkedEObject) {
                    IConstructorLinkingCandidate candidate = this.getBatchTypeResolver().resolveTypes((EObject)casted).getLinkingCandidate(casted);
                    if (candidate instanceof IAmbiguousLinkingCandidate) {
                        this.createMultipleLinks(resource, crossRefNode, ((IAmbiguousLinkingCandidate)candidate).getAlternatives(), acceptor);
                    } else {
                        this.createHyperlinksTo(resource, crossRefNode, crossLinkedEObject, acceptor);
                    }
                } else {
                    this.createHyperlinksTo(resource, crossRefNode, crossLinkedEObject, acceptor);
                }
            } else {
                this.createHyperlinksTo(resource, crossRefNode, crossLinkedEObject, acceptor);
            }
        }
        super.createHyperlinksForCrossRef(resource, crossRefNode, acceptor);
    }

    private void createMultipleLinks(XtextResource resource, INode crossRefNode, List<? extends ILinkingCandidate> alternatives, IHyperlinkAcceptor acceptor) {
        for (ILinkingCandidate iLinkingCandidate : alternatives) {
            this.createHyperlinksTo(resource, crossRefNode, (EObject)iLinkingCandidate.getFeature(), acceptor);
        }
    }
}

