/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.builder;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.xtext.builder.BuilderParticipant;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.compiler.ElementIssueProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendBuilderParticipant
extends BuilderParticipant {
    private static Logger LOGGER = Logger.getLogger(XtendBuilderParticipant.class);
    @Inject
    private IStorage2UriMapper mapper;
    @Inject
    private ElementIssueProvider.Factory elementIssueProviderFactory;

    protected void handleChangedContents(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, EclipseResourceFileSystemAccess2 fileSystemAccess) throws CoreException {
        if (!this.getResourceServiceProvider().canHandle(delta.getUri())) {
            return;
        }
        Resource resource = context.getResourceSet().getResource(delta.getUri(), true);
        IFile file = this.getFile(resource, context);
        if (file != null) {
            try {
                this.registerCurrentSourceFolder(context, delta, fileSystemAccess);
                try {
                    this.elementIssueProviderFactory.attachData(resource);
                    this.getGenerator().doGenerate(resource, (IFileSystemAccess)fileSystemAccess);
                }
                finally {
                    this.elementIssueProviderFactory.detachData(resource);
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof CoreException) {
                    throw (CoreException)e.getCause();
                }
                throw e;
            }
        }
    }

    protected IFile getFile(Resource resource, IXtextBuilderParticipant.IBuildContext context) {
        Iterable storages = this.mapper.getStorages(resource.getURI());
        for (Pair pair : storages) {
            if (!(pair.getFirst() instanceof IFile) || !((IProject)pair.getSecond()).equals((Object)context.getBuiltProject())) continue;
            return (IFile)pair.getFirst();
        }
        return null;
    }

    protected List<IPath> getSourceFolderPathes(IProject project) {
        ArrayList sourceFolder = Lists.newArrayList();
        try {
            if (project.isOpen() && JavaProject.hasJavaNature((IProject)project)) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                List<IPackageFragmentRoot> packageFragmentRoots = Arrays.asList(javaProject.getPackageFragmentRoots());
                for (IPackageFragmentRoot packageFragmentRoot : packageFragmentRoots) {
                    if (packageFragmentRoot.getKind() != 1) continue;
                    IPath path = packageFragmentRoot.getPath();
                    sourceFolder.add(path);
                }
            }
        }
        catch (JavaModelException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return sourceFolder;
    }

    protected Map<OutputConfiguration, Iterable<IMarker>> getGeneratorMarkers(IProject builtProject, Collection<OutputConfiguration> outputConfigurations) throws CoreException {
        HashMap generatorMarkers = Maps.newHashMap();
        List<IPath> sourcePath = this.getSourceFolderPathes(builtProject);
        for (OutputConfiguration config : outputConfigurations) {
            if (!config.isCleanUpDerivedResources()) continue;
            ArrayList containerToSearchIn = Lists.newArrayList();
            for (IPath sourceFolder : sourcePath) {
                if (sourceFolder.segmentCount() == 1) {
                    containerToSearchIn.add(builtProject);
                    continue;
                }
                IFolder sourcePathBasedContainer = builtProject.getWorkspace().getRoot().getFolder(sourceFolder);
                containerToSearchIn.add(sourcePathBasedContainer);
            }
            ArrayList markers = Lists.newArrayList();
            for (IContainer container : containerToSearchIn) {
                Iterables.addAll((Collection)markers, (Iterable)this.getDerivedResourceMarkers().findDerivedResourceMarkers((IResource)container, this.getGeneratorIdProvider().getGeneratorIdentifier()));
            }
            generatorMarkers.put(config, markers);
        }
        return generatorMarkers;
    }
}

