/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.packrat.debug;

import org.apache.log4j.Logger;
import org.eclipse.xtext.parser.packrat.IMarkerFactory;

public class DebugMarkerFactory
implements IMarkerFactory {
    private static final Logger log = Logger.getLogger(DebugMarkerFactory.class);
    private final IMarkerFactory delegate;

    public DebugMarkerFactory(IMarkerFactory delegate) {
        this.delegate = delegate;
    }

    public IMarkerFactory.IMarker mark() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"mark()");
        }
        IMarkerFactory.IMarker result = this.delegate.mark();
        if (log.isDebugEnabled()) {
            log.debug((Object)("mark() = " + result));
        }
        return new DebuggingMarker(result);
    }

    private static class DebuggingMarker
    implements IMarkerFactory.IMarker {
        private final IMarkerFactory.IMarker delegate;

        public DebuggingMarker(IMarkerFactory.IMarker delegate) {
            this.delegate = delegate;
        }

        public void rollback() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("rollback(" + this.delegate + ")"));
            }
            this.delegate.rollback();
        }

        public void commit() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("commit(" + this.delegate + ")"));
            }
            this.delegate.commit();
        }

        public void flush() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("flush(" + this.delegate + ")"));
            }
            this.delegate.flush();
        }

        public IMarkerFactory.IMarker fork() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fork(" + this.delegate + ")"));
            }
            return new DebuggingMarker(this.delegate.fork());
        }

        public IMarkerFactory.IMarker join(IMarkerFactory.IMarker forkedMarker) {
            IMarkerFactory.IMarker result;
            IMarkerFactory.IMarker join;
            IMarkerFactory.IMarker iMarker = join = forkedMarker instanceof DebuggingMarker ? ((DebuggingMarker)forkedMarker).delegate : forkedMarker;
            if (log.isDebugEnabled()) {
                log.debug((Object)("join(" + join + ")"));
            }
            if (this.delegate != (result = this.delegate.join(forkedMarker))) {
                return new DebuggingMarker(result);
            }
            return this;
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof DebuggingMarker && this.delegate.equals(((DebuggingMarker)obj).delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode() * 37;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " with delegate: " + this.delegate;
        }
    }
}

