/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectableBasedScope
extends AbstractScope {
    private final Predicate<IEObjectDescription> filter;
    private final ISelectable selectable;
    private final EClass type;

    public static IScope createScope(IScope outer, ISelectable selectable, EClass type, boolean ignoreCase) {
        return SelectableBasedScope.createScope(outer, selectable, null, type, ignoreCase);
    }

    public static IScope createScope(IScope outer, ISelectable selectable, Predicate<IEObjectDescription> filter, EClass type, boolean ignoreCase) {
        if (selectable == null || selectable.isEmpty()) {
            return outer;
        }
        return new SelectableBasedScope(outer, selectable, filter, type, ignoreCase);
    }

    protected SelectableBasedScope(IScope outer, ISelectable selectable, Predicate<IEObjectDescription> filter, EClass type, boolean ignoreCase) {
        super(outer, ignoreCase);
        this.filter = filter;
        this.selectable = selectable;
        this.type = type;
    }

    @Override
    protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        Iterable<IEObjectDescription> unfiltered = this.selectable.getExportedObjects(this.type, name, this.isIgnoreCase());
        return this.filterLocalElements(unfiltered);
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        Iterable<IEObjectDescription> unfiltered = this.selectable.getExportedObjectsByType(this.type);
        return this.filterLocalElements(unfiltered);
    }

    protected ISelectable getSelectable() {
        return this.selectable;
    }

    protected Predicate<IEObjectDescription> getFilter() {
        return this.filter;
    }

    protected Iterable<IEObjectDescription> filterLocalElements(Iterable<IEObjectDescription> unfiltered) {
        if (this.filter != null) {
            Iterable result = Iterables.filter(unfiltered, this.filter);
            return result;
        }
        return unfiltered;
    }
}

