/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.packrat.debug;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.xtext.parser.packrat.IHiddenTokenHandler;
import org.eclipse.xtext.parser.packrat.consumers.ITerminalConsumer;

public class DebugHiddenTokenHandler
implements IHiddenTokenHandler {
    private static final Logger log = Logger.getLogger(DebugHiddenTokenHandler.class);
    private final IHiddenTokenHandler delegate;

    public DebugHiddenTokenHandler(IHiddenTokenHandler delegate) {
        this.delegate = delegate;
    }

    public IHiddenTokenHandler.IHiddenTokenState replaceHiddenTokens(ITerminalConsumer ... consumers) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("replaceHiddenTokens(" + Arrays.toString(consumers) + ")"));
        }
        IHiddenTokenHandler.IHiddenTokenState result = this.delegate.replaceHiddenTokens(consumers);
        if (log.isDebugEnabled()) {
            log.debug((Object)("replaceHiddenTokens(..) = " + result));
        }
        return new DebuggingHiddenTokenState(result);
    }

    private static class DebuggingHiddenTokenState
    implements IHiddenTokenHandler.IHiddenTokenState {
        private final IHiddenTokenHandler.IHiddenTokenState delegate;

        public DebuggingHiddenTokenState(IHiddenTokenHandler.IHiddenTokenState delegate) {
            this.delegate = delegate;
        }

        public void restore() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("restore(" + this.delegate + ")"));
            }
            this.delegate.restore();
        }
    }
}

