/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.generator.trace.AbstractStatefulTraceRegion;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class TraceRegion
extends AbstractStatefulTraceRegion {
    public TraceRegion(int myOffset, int myLength, int myLineNumber, int myEndLineNumber, int associatedOffset, int associatedLength, int associatedLineNumber, int associatedEndLineNumber, @Nullable AbstractTraceRegion parent, @Nullable URI associatedPath, @Nullable String associatedProject) {
        this(myOffset, myLength, myLineNumber, myEndLineNumber, new LocationData(associatedOffset, associatedLength, associatedLineNumber, associatedEndLineNumber, associatedPath, associatedProject), parent);
    }

    public TraceRegion(int myOffset, int myLength, int myLineNumber, int myEndLineNumber, ILocationData locationData, @Nullable AbstractTraceRegion parent) {
        super((ITextRegionWithLineInformation)new TextRegionWithLineInformation(myOffset, myLength, myLineNumber, myEndLineNumber), locationData, parent);
        if (myOffset == myLength && myOffset == 0) {
            throw new IllegalArgumentException();
        }
        if (parent == null) {
            if (locationData.getPath() == null) {
                throw new IllegalArgumentException("associatedPath may not be null");
            }
            if (locationData.getProjectName() == null) {
                throw new IllegalArgumentException("associatedProjectName may not be null");
            }
        } else {
            if (parent.getAssociatedPath() == null && locationData.getPath() == null) {
                throw new IllegalArgumentException("associatedPath may not be null");
            }
            if (parent.getAssociatedProjectName() == null && locationData.getProjectName() == null) {
                throw new IllegalArgumentException("associatedProjectName may not be null");
            }
        }
    }

    public TraceRegion(int myOffset, int myLength, int myLineNumber, int myEndLineNumber, List<ILocationData> allLocationData, @Nullable AbstractTraceRegion parent) {
        super((ITextRegionWithLineInformation)new TextRegionWithLineInformation(myOffset, myLength, myLineNumber, myEndLineNumber), Lists.newArrayList(allLocationData), parent);
        if (parent == null) {
            for (ILocationData locationData : allLocationData) {
                if (locationData.getPath() == null) {
                    throw new IllegalArgumentException("associatedPath may not be null");
                }
                if (locationData.getProjectName() != null) continue;
                throw new IllegalArgumentException("associatedProjectName may not be null");
            }
        } else {
            boolean nullSeen = false;
            boolean notNullSeen = false;
            for (ILocationData locationData : allLocationData) {
                if (locationData.getPath() == null) {
                    nullSeen = true;
                } else {
                    notNullSeen = true;
                }
                if (!nullSeen || !notNullSeen) continue;
                throw new IllegalArgumentException("list of locations is inconsistent");
            }
            if (parent.getAssociatedPath() == null && nullSeen) {
                throw new IllegalArgumentException("list of locations is inconsistent with parent");
            }
        }
    }
}

