/*******************************************************************************
 * Copyright (c) 2010 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.xtext.ui.editor.outline;

import java.util.List;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.IReadAccess;

/**
 * A model for a node in the outline. Implementors must inherit from
 * {@link org.eclipse.xtext.ui.editor.outline.impl.AbstractOutlineNode}.
 * 
 * @author Jan Koehnlein - Initial contribution and API
 */
public interface IOutlineNode extends IAdaptable, IReadAccess<EObject> {

	Object getText();

	Image getImage();

	IOutlineNode getParent();

	List<IOutlineNode> getChildren();

	boolean hasChildren();

	/**
	 * The region that triggers selection of this node when "Link with Editor" is enabled.
	 */
	ITextRegion getFullTextRegion();

	/**
	 * The region that is selected in the editor when this node is double clicked or selected in "Link with Editor"
	 * mode.
	 */
	ITextRegion getSignificantTextRegion();

}
