/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.ResourceAccess;
import org.eclipse.xtext.ui.editor.findrefs.TargetURIConverter;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IReferenceUpdater;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;

public class ReferenceUpdaterDispatcher {
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private TargetURIConverter targetURIConverter;
    @Inject
    private Provider<ResourceAccess> resourceAccessProvider;
    @Inject
    private IResourceDescriptions indexData;

    public void createReferenceUpdates(ElementRenameArguments elementRenameArguments, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Updating references", (int)100);
        ResourceAccess resourceAccess = (ResourceAccess)this.resourceAccessProvider.get();
        resourceAccess.registerResourceSet(resourceSet);
        ReferenceDescriptionAcceptor referenceDescriptionAcceptor = this.createFindReferenceAcceptor(updateAcceptor);
        this.referenceFinder.findAllReferences(this.targetURIConverter.fromIterable(elementRenameArguments.getRenamedElementURIs()), (IReferenceFinder.IResourceAccess)resourceAccess, this.indexData, (IReferenceFinder.Acceptor)referenceDescriptionAcceptor, (IProgressMonitor)progress.newChild(2));
        Multimap<IReferenceUpdater, IReferenceDescription> updater2descriptions = referenceDescriptionAcceptor.getReferenceUpdater2ReferenceDescriptions();
        SubMonitor updaterProgress = progress.newChild(98).setWorkRemaining(updater2descriptions.keySet().size());
        for (IReferenceUpdater referenceUpdater : updater2descriptions.keySet()) {
            if (updaterProgress.isCanceled()) {
                return;
            }
            referenceUpdater.createReferenceUpdates(elementRenameArguments, updater2descriptions.get((Object)referenceUpdater), updateAcceptor, (IProgressMonitor)updaterProgress.newChild(1));
        }
    }

    protected ReferenceDescriptionAcceptor createFindReferenceAcceptor(IRefactoringUpdateAcceptor updateAcceptor) {
        return new ReferenceDescriptionAcceptor(this.resourceServiceProviderRegistry, updateAcceptor.getRefactoringStatus());
    }

    protected static class OptionalReferenceUpdaterProxy {
        @Inject(optional=true)
        private IReferenceUpdater referenceUpdater;

        protected OptionalReferenceUpdaterProxy() {
        }

        public IReferenceUpdater get() {
            return this.referenceUpdater;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReferenceDescriptionAcceptor
    implements IReferenceFinder.Acceptor {
        private Map<IResourceServiceProvider, IReferenceUpdater> provider2updater = Maps.newHashMap();
        private Multimap<IReferenceUpdater, IReferenceDescription> updater2refs = HashMultimap.create();
        private StatusWrapper status;
        private final IResourceServiceProvider.Registry resourceServiceProviderRegistry;

        public ReferenceDescriptionAcceptor(IResourceServiceProvider.Registry resourceServiceProviderRegistry, StatusWrapper status) {
            this.resourceServiceProviderRegistry = resourceServiceProviderRegistry;
            this.status = status;
        }

        public void accept(IReferenceDescription referenceDescription) {
            if (referenceDescription.getSourceEObjectUri() == null || referenceDescription.getTargetEObjectUri() == null || referenceDescription.getEReference() == null) {
                this.handleCorruptReferenceDescription(referenceDescription, this.status);
            } else {
                URI sourceResourceURI = referenceDescription.getSourceEObjectUri().trimFragment();
                IReferenceUpdater referenceUpdater = this.getReferenceUpdater(sourceResourceURI);
                if (referenceUpdater == null) {
                    this.handleNoReferenceUpdater(sourceResourceURI, this.status);
                } else {
                    this.updater2refs.put((Object)referenceUpdater, (Object)referenceDescription);
                }
            }
        }

        public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
            this.accept((IReferenceDescription)new DefaultReferenceDescription(sourceURI, targetURI, eReference, index, null));
        }

        protected void handleNoReferenceUpdater(URI sourceResourceURI, StatusWrapper status) {
            status.add(2, "References from {0} will not be updated as the language has not registered an IReferenceUpdater", sourceResourceURI);
        }

        protected void handleCorruptReferenceDescription(IReferenceDescription referenceDescription, StatusWrapper status) {
            status.add(3, "Xtext index contains invalid entries. It is suggested to perform a workspace refresh and a clean build.", new Object[0]);
        }

        protected IReferenceUpdater getReferenceUpdater(URI sourceResourceURI) {
            IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(sourceResourceURI);
            if (resourceServiceProvider == null) {
                return null;
            }
            IReferenceUpdater referenceUpdater = this.provider2updater.get(resourceServiceProvider);
            if (referenceUpdater == null && (referenceUpdater = ((OptionalReferenceUpdaterProxy)resourceServiceProvider.get(OptionalReferenceUpdaterProxy.class)).get()) != null) {
                this.provider2updater.put(resourceServiceProvider, referenceUpdater);
            }
            return referenceUpdater;
        }

        public Multimap<IReferenceUpdater, IReferenceDescription> getReferenceUpdater2ReferenceDescriptions() {
            return this.updater2refs;
        }
    }
}

