/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.containers;

import com.google.inject.Inject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.ui.containers.AbstractAllContainersState;
import org.eclipse.xtext.ui.util.IJdtHelper;

public abstract class AbstractJavaProjectsState
extends AbstractAllContainersState
implements IElementChangedListener {
    @Inject
    private IJdtHelper jdtHelper;

    protected void registerAsListener() {
        super.registerAsListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void unregisterAsListener() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        super.unregisterAsListener();
    }

    public void elementChanged(ElementChangedEvent event) {
        if (event.getDelta() != null && this.isAffectingPackageFragmentRoots(event.getDelta())) {
            this.initialize();
        }
    }

    private boolean isAffectingPackageFragmentRoots(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (element instanceof IPackageFragmentRoot) {
            if (delta.getKind() == 2 || delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0 || (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 0x40) != 0 || ((IPackageFragmentRoot)element).isExternal() && (delta.getFlags() & 0x3001) == delta.getFlags()) {
                return true;
            }
        } else {
            if (element instanceof IJavaModel) {
                return this.isAffectingPackageFragmentRoots(delta.getAffectedChildren());
            }
            if (element instanceof IJavaProject) {
                if ((delta.getFlags() & 0x20000) != 0 || (delta.getFlags() & 0x200000) != 0) {
                    return true;
                }
                return this.isAffectingPackageFragmentRoots(delta.getAffectedChildren());
            }
        }
        return false;
    }

    private boolean isAffectingPackageFragmentRoots(IJavaElementDelta[] affectedChildren) {
        IJavaElementDelta[] iJavaElementDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta delta = iJavaElementDeltaArray[n2];
            if (this.isAffectingPackageFragmentRoots(delta)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isIgnoredResource(IResource resource) {
        return this.jdtHelper.isFromOutputPath(resource);
    }

    public void setJdtHelper(IJdtHelper jdtHelper) {
        this.jdtHelper = jdtHelper;
    }
}

