/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.TypeLiteralDescription;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedTypeLiteralScope
extends AbstractSessionBasedScope {
    private final JvmType outerType;
    private final LightweightTypeReference receiverType;

    protected NestedTypeLiteralScope(IScope parent, IFeatureScopeSession session, XAbstractFeatureCall featureCall, LightweightTypeReference receiverType, JvmType outerType) {
        super(parent, session, featureCall);
        this.outerType = outerType;
        this.receiverType = receiverType;
    }

    @Override
    protected Collection<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall.isExplicitOperationCallOrBuilderSyntax()) {
            return Collections.emptyList();
        }
        if (this.outerType instanceof JvmDeclaredType && name.getSegmentCount() == 1) {
            JvmType result;
            String singleSegment = name.getFirstSegment();
            List lookup = Collections.singletonList(singleSegment);
            if (singleSegment.indexOf(36) != -1) {
                lookup = Strings.split((String)singleSegment, (char)'$');
            }
            if ((result = this.findNestedType((JvmDeclaredType)this.outerType, lookup.iterator())) != null) {
                IEObjectDescription description = EObjectDescription.create((QualifiedName)name, (EObject)result);
                return Collections.singletonList(new TypeLiteralDescription(description, this.receiverType, this.isVisible(result)));
            }
        }
        return Collections.emptyList();
    }

    protected JvmType findNestedType(JvmDeclaredType outerType, Iterator<String> iterator) {
        String current = iterator.next();
        for (JvmMember member : outerType.getMembers()) {
            if (!(member instanceof JvmDeclaredType) || !member.getSimpleName().equals(current)) continue;
            if (iterator.hasNext()) {
                return this.findNestedType((JvmDeclaredType)member, iterator);
            }
            return (JvmDeclaredType)member;
        }
        return null;
    }

    protected boolean isVisible(JvmType type) {
        if (type instanceof JvmMember) {
            return this.getSession().isVisible((JvmMember)type);
        }
        return true;
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)2);
        if (this.outerType instanceof JvmDeclaredType) {
            for (JvmMember member : ((JvmDeclaredType)this.outerType).getMembers()) {
                if (!(member instanceof JvmDeclaredType)) continue;
                IEObjectDescription description = EObjectDescription.create((String)member.getSimpleName(), (EObject)member);
                result.add(new TypeLiteralDescription(description, this.receiverType, this.isVisible((JvmType)member)));
            }
        }
        return result;
    }
}

