/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import java.util.List;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeReferenceVisitorWithParameter<Param> {
    protected void doVisitTypeReference(LightweightTypeReference reference, Param param) {
        throw new UnsupportedOperationException("Missing implementation for " + reference);
    }

    protected void doVisitAnyTypeReference(AnyTypeReference reference, Param param) {
        this.doVisitTypeReference(reference, param);
    }

    protected void doVisitUnknownTypeReference(UnknownTypeReference reference, Param param) {
        this.doVisitTypeReference(reference, param);
    }

    protected void doVisitCompoundTypeReference(CompoundTypeReference reference, Param param) {
        List<LightweightTypeReference> components = reference.getMultiTypeComponents();
        if (components.isEmpty()) {
            this.doVisitTypeReference(reference, param);
        } else {
            for (LightweightTypeReference component : components) {
                component.accept(this, param);
            }
        }
    }

    protected void doVisitMultiTypeReference(CompoundTypeReference reference, Param param) {
        this.doVisitCompoundTypeReference(reference, param);
    }

    protected void doVisitSynonymTypeReference(CompoundTypeReference reference, Param param) {
        this.doVisitCompoundTypeReference(reference, param);
    }

    protected void doVisitArrayTypeReference(ArrayTypeReference reference, Param param) {
        this.doVisitTypeReference(reference, param);
    }

    protected void doVisitFunctionTypeReference(FunctionTypeReference reference, Param param) {
        this.doVisitParameterizedTypeReference(reference, param);
    }

    protected void doVisitParameterizedTypeReference(ParameterizedTypeReference reference, Param param) {
        this.doVisitTypeReference(reference, param);
    }

    protected void doVisitUnboundTypeReference(UnboundTypeReference reference, Param param) {
        this.doVisitTypeReference(reference, param);
    }

    protected void doVisitWildcardTypeReference(WildcardTypeReference reference, Param param) {
        this.doVisitTypeReference(reference, param);
    }
}

