/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightweightTypeReferenceSerializer
extends TypeReferenceVisitor {
    private ISourceAppender appender;

    public LightweightTypeReferenceSerializer(ISourceAppender appender) {
        this.appender = appender;
    }

    @Override
    protected void doVisitAnyTypeReference(AnyTypeReference reference) {
        LightweightTypeReference _javaType = reference.toJavaType();
        _javaType.accept(this);
    }

    @Override
    protected void doVisitArrayTypeReference(ArrayTypeReference reference) {
        LightweightTypeReference _componentType = reference.getComponentType();
        _componentType.accept(this);
        this.appender.append("[]");
    }

    @Override
    protected void doVisitCompoundTypeReference(CompoundTypeReference reference) {
        LightweightTypeReference _javaType = reference.toJavaType();
        _javaType.accept(this);
    }

    @Override
    protected void doVisitFunctionTypeReference(FunctionTypeReference reference) {
        boolean _isJava = this.appender.isJava();
        if (_isJava) {
            this.doVisitParameterizedTypeReference(reference);
        } else {
            this.appender.append("(");
            List<LightweightTypeReference> _parameterTypes = reference.getParameterTypes();
            this.appendCommaSeparated(_parameterTypes);
            this.appender.append(")=>");
            LightweightTypeReference _returnType = reference.getReturnType();
            boolean _equals = Objects.equal((Object)_returnType, null);
            if (_equals) {
                this.appender.append("void");
            } else {
                LightweightTypeReference _returnType_1 = reference.getReturnType();
                _returnType_1.accept(this);
            }
        }
    }

    @Override
    protected void doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
        boolean _isAnonymous = reference.isAnonymous();
        if (_isAnonymous) {
            LightweightTypeReference _namedType = reference.getNamedType();
            _namedType.accept(this);
        } else {
            boolean _not;
            JvmType _type = reference.getType();
            this.appender.append(_type);
            List<LightweightTypeReference> _typeArguments = reference.getTypeArguments();
            boolean _isEmpty = _typeArguments.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                this.appender.append("<");
                List<LightweightTypeReference> _typeArguments_1 = reference.getTypeArguments();
                this.appendCommaSeparated(_typeArguments_1);
                this.appender.append(">");
            }
        }
    }

    @Override
    protected void doVisitUnboundTypeReference(UnboundTypeReference reference) {
        LightweightTypeReference _javaType = reference.toJavaType();
        _javaType.accept(this);
    }

    @Override
    protected void doVisitUnknownTypeReference(UnknownTypeReference reference) {
        String _simpleName = reference.getSimpleName();
        this.appender.append(_simpleName);
    }

    @Override
    protected void doVisitWildcardTypeReference(WildcardTypeReference reference) {
        boolean _notEquals;
        this.appender.append("?");
        LightweightTypeReference _lowerBound = reference.getLowerBound();
        boolean bl = _notEquals = !Objects.equal((Object)_lowerBound, null);
        if (_notEquals) {
            this.appender.append(" super ");
            LightweightTypeReference _lowerBound_1 = reference.getLowerBound();
            _lowerBound_1.accept(this);
        } else {
            boolean _not;
            Functions.Function1<LightweightTypeReference, Boolean> _function;
            List<LightweightTypeReference> _upperBounds = reference.getUpperBounds();
            Iterable relevantUpperBounds = IterableExtensions.filter(_upperBounds, (Functions.Function1)(_function = new Functions.Function1<LightweightTypeReference, Boolean>(){

                public Boolean apply(LightweightTypeReference it) {
                    String _identifier = it.getIdentifier();
                    return !Objects.equal((Object)"java.lang.Object", (Object)_identifier);
                }
            }));
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)relevantUpperBounds);
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                this.appender.append(" extends ");
                boolean isFirst = true;
                for (LightweightTypeReference upperBound : relevantUpperBounds) {
                    if (!isFirst) {
                        this.appender.append(" & ");
                    }
                    isFirst = false;
                    upperBound.accept(this);
                }
            }
        }
    }

    protected void appendCommaSeparated(List<LightweightTypeReference> references) {
        boolean isFirst = true;
        for (LightweightTypeReference reference : references) {
            if (!isFirst) {
                this.appender.append(", ");
            }
            isFirst = false;
            reference.accept(this);
        }
    }
}

