/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xtype.XFunctionTypeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionTypeReference
extends ParameterizedTypeReference {
    private List<LightweightTypeReference> parameterTypes;
    private LightweightTypeReference returnType;

    public FunctionTypeReference(ITypeReferenceOwner owner, JvmType type) {
        super(owner, type);
    }

    @Override
    public int getKind() {
        return 9;
    }

    @Override
    protected FunctionTypeReference doCopyInto(ITypeReferenceOwner owner) {
        FunctionTypeReference result = new FunctionTypeReference(owner, this.getType());
        this.copyTypeArguments(result, owner);
        if (this.parameterTypes != null && !this.parameterTypes.isEmpty()) {
            for (LightweightTypeReference typeArgument : this.parameterTypes) {
                result.addParameterType(typeArgument.copyInto(owner));
            }
        }
        if (this.returnType != null) {
            result.setReturnType(this.returnType.copyInto(owner));
        }
        return result;
    }

    public List<LightweightTypeReference> getParameterTypes() {
        return this.expose(this.parameterTypes);
    }

    public LightweightTypeReference getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isVisible(IVisibilityHelper visibilityHelper) {
        if (super.isVisible(visibilityHelper)) {
            if (this.returnType != null && !this.returnType.isVisible(visibilityHelper)) {
                return false;
            }
            if (this.parameterTypes != null) {
                for (LightweightTypeReference parameterType : this.parameterTypes) {
                    if (parameterType.isVisible(visibilityHelper)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isOwnedBy(ITypeReferenceOwner owner) {
        if (super.isOwnedBy(owner)) {
            if (this.returnType != null && !this.returnType.isOwnedBy(owner)) {
                return false;
            }
            if (this.parameterTypes != null) {
                for (LightweightTypeReference parameterType : this.parameterTypes) {
                    if (parameterType.isOwnedBy(owner)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public JvmTypeReference toTypeReference() {
        XFunctionTypeRef result = this.getOwner().getServices().getXtypeFactory().createXFunctionTypeRef();
        result.setType(this.getType());
        result.setEquivalent(super.toTypeReference());
        if (this.parameterTypes != null) {
            for (LightweightTypeReference parameterType : this.parameterTypes) {
                result.getParamTypes().add((Object)parameterType.toTypeReference());
            }
        }
        if (this.returnType != null) {
            result.setReturnType(this.returnType.toTypeReference());
        }
        return result;
    }

    public void addParameterType(LightweightTypeReference parameterType) {
        if (parameterType == null) {
            throw new NullPointerException("parameterType may not be null");
        }
        if (!parameterType.isOwnedBy(this.getOwner())) {
            throw new NullPointerException("parameterType is not valid in current context");
        }
        if (this.parameterTypes == null) {
            this.parameterTypes = Lists.newArrayListWithCapacity((int)2);
        }
        this.parameterTypes.add(parameterType);
        this.resolved = this.resolved && parameterType.isResolved();
    }

    public void setReturnType(LightweightTypeReference returnType) {
        if (returnType == null) {
            throw new NullPointerException("returnType may not be null");
        }
        if (!returnType.isOwnedBy(this.getOwner())) {
            throw new NullPointerException("returnType is not valid in current context");
        }
        this.returnType = returnType;
        this.resolved = this.resolved && returnType.isResolved();
    }

    @Override
    protected String getAsString(String type, Function<LightweightTypeReference, String> format) {
        if (this.isRawType()) {
            return type;
        }
        return "(" + Joiner.on((String)", ").join(Iterables.transform(this.expose(this.parameterTypes), format)) + ")=>" + (this.returnType != null ? (String)format.apply((Object)this.returnType) : "./.");
    }

    @Override
    public String getJavaIdentifier() {
        return super.getAsString(this.getType().getIdentifier(), LightweightTypeReference.JavaIdentifierFunction.INSTANCE);
    }

    @Override
    public void accept(TypeReferenceVisitor visitor) {
        visitor.doVisitFunctionTypeReference(this);
    }

    @Override
    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        visitor.doVisitFunctionTypeReference(this, param);
    }

    @Override
    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        return visitor.doVisitFunctionTypeReference(this);
    }

    @Override
    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        return visitor.doVisitFunctionTypeReference(this, param);
    }

    @Override
    public FunctionTypeReference tryConvertToFunctionTypeReference(boolean rawType) {
        return this;
    }

    @Override
    public FunctionTypeReference getAsFunctionTypeReference() {
        return this;
    }
}

