/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideTester;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedOperations
extends AbstractResolvedFeatures {
    private List<IResolvedOperation> allOperations;
    private List<IResolvedOperation> declaredOperations;
    private List<IResolvedConstructor> declaredConstructors;
    private ListMultimap<String, IResolvedOperation> allOperationsPerErasure;

    public ResolvedOperations(LightweightTypeReference type, OverrideTester overrideTester) {
        super(type, overrideTester);
    }

    public ResolvedOperations(LightweightTypeReference type) {
        this(type, new OverrideTester());
    }

    public List<IResolvedOperation> getAllOperations() {
        if (this.allOperations != null) {
            return this.allOperations;
        }
        this.allOperations = this.computeAllOperations();
        return this.allOperations;
    }

    public List<IResolvedConstructor> getDeclaredConstructors() {
        if (this.declaredConstructors != null) {
            return this.declaredConstructors;
        }
        this.declaredConstructors = this.computeDeclaredConstructors();
        return this.declaredConstructors;
    }

    public List<IResolvedOperation> getDeclaredOperations() {
        if (this.declaredOperations != null) {
            return this.declaredOperations;
        }
        this.declaredOperations = this.computeDeclaredOperations();
        return this.declaredOperations;
    }

    public List<IResolvedOperation> getDeclaredOperations(String erasedSignature) {
        List<IResolvedOperation> operations = this.getAllOperations(erasedSignature);
        int i = 0;
        while (i < operations.size()) {
            IResolvedOperation current = operations.get(i);
            if (current.getDeclaration().getDeclaringType() != this.getRawType()) {
                return operations.subList(0, i);
            }
            ++i;
        }
        return operations;
    }

    public List<IResolvedOperation> getAllOperations(String erasedSignature) {
        if (this.allOperationsPerErasure != null) {
            return this.allOperationsPerErasure.get((Object)erasedSignature);
        }
        this.allOperationsPerErasure = this.computeIndex();
        return this.allOperationsPerErasure.get((Object)erasedSignature);
    }

    protected ListMultimap<String, IResolvedOperation> computeIndex() {
        return Multimaps.index(this.getAllOperations(), (Function)new Function<IResolvedOperation, String>(){

            public String apply(IResolvedOperation input) {
                return input.getResolvedErasureSignature();
            }
        });
    }

    protected List<IResolvedOperation> computeAllOperations() {
        JvmType rawType = this.getRawType();
        if (!(rawType instanceof JvmDeclaredType)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        HashMultimap processed = HashMultimap.create();
        HashSet processedTypes = Sets.newHashSet();
        this.computeAllOperations((JvmDeclaredType)rawType, (Multimap<String, AbstractResolvedOperation>)processed, processedTypes, result);
        return Collections.unmodifiableList(result);
    }

    protected void computeAllOperations(JvmDeclaredType type, Multimap<String, AbstractResolvedOperation> processedOperations, Set<JvmDeclaredType> processedTypes, List<IResolvedOperation> result) {
        if (type != null && !type.eIsProxy() && processedTypes.add(type)) {
            Iterable operations = type.getDeclaredOperations();
            for (JvmOperation operation : operations) {
                String simpleName = operation.getSimpleName();
                if (processedOperations.containsKey((Object)simpleName) && this.isOverridden(operation, processedOperations.get((Object)simpleName))) continue;
                BottomResolvedOperation resolvedOperation = this.createResolvedOperation(operation);
                processedOperations.put((Object)simpleName, (Object)resolvedOperation);
                result.add(resolvedOperation);
            }
            for (JvmTypeReference superType : type.getSuperTypes()) {
                JvmType rawSuperType = superType.getType();
                if (!(rawSuperType instanceof JvmDeclaredType)) continue;
                this.computeAllOperations((JvmDeclaredType)rawSuperType, processedOperations, processedTypes, result);
            }
        }
    }

    protected List<IResolvedOperation> computeDeclaredOperations() {
        JvmType rawType = this.getRawType();
        if (!(rawType instanceof JvmDeclaredType)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (IResolvedOperation operation : this.getAllOperations()) {
            if (operation.getDeclaration().getDeclaringType() != rawType) continue;
            result.add(operation);
        }
        return Collections.unmodifiableList(result);
    }

    protected List<IResolvedConstructor> computeDeclaredConstructors() {
        JvmType rawType = this.getRawType();
        if (!(rawType instanceof JvmGenericType)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (JvmConstructor constructor : ((JvmGenericType)rawType).getDeclaredConstructors()) {
            result.add(new ResolvedConstructor(constructor, this.getType()));
        }
        return Collections.unmodifiableList(result);
    }
}

