/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.validator;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.ui.validation.XbaseUIValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendUIValidator
extends XbaseUIValidator {
    private static final Logger LOG = Logger.getLogger(XtendUIValidator.class);
    @Inject
    private IStorage2UriMapper storage2UriMapper;

    protected List<EPackage> getEPackages() {
        List packages = super.getEPackages();
        packages.add(XtendPackage.eINSTANCE);
        return packages;
    }

    @Check
    public void checkFileNamingConventions(XtendFile xtendFile) {
        String expectedPackage = this.getExpectedPackageName(xtendFile);
        String declaredPackage = xtendFile.getPackage();
        if (!(expectedPackage == null || Strings.isEmpty((String)expectedPackage) && declaredPackage == null || expectedPackage.equals(declaredPackage))) {
            this.error("The declared package '" + Strings.notNull((Object)declaredPackage) + "' does not match the expected package '" + Strings.notNull((Object)expectedPackage) + "'", (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, -1, "org.eclipse.xtend.core.validation.IssueCodes.wrong_package", new String[]{expectedPackage});
        }
    }

    protected String getExpectedPackageName(XtendFile xtendFile) {
        URI fileURI = xtendFile.eResource().getURI();
        for (Pair storage : this.storage2UriMapper.getStorages(fileURI)) {
            if (!(storage.getFirst() instanceof IFile)) continue;
            IPath fileWorkspacePath = ((IStorage)storage.getFirst()).getFullPath();
            IJavaProject javaProject = JavaCore.create((IProject)((IProject)storage.getSecond()));
            if (javaProject == null || !javaProject.exists() || !javaProject.isOpen()) continue;
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath sourceFolderPath;
                    IResource resource;
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (!root.isArchive() && !root.isExternal() && (resource = root.getResource()) != null && (sourceFolderPath = resource.getFullPath()).isPrefixOf(fileWorkspacePath)) {
                        IPath claspathRelativePath = fileWorkspacePath.makeRelativeTo(sourceFolderPath);
                        return claspathRelativePath.removeLastSegments(1).toString().replace("/", ".");
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                LOG.error((Object)"Error resolving expected path for XtendFile", (Throwable)e);
            }
        }
        return null;
    }
}

