/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.editor;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.ide.editor.InitiallyCollapsableFoldedPosition;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendFoldingRegionProvider
extends DefaultFoldingRegionProvider {
    protected boolean isHandled(EObject object) {
        EClass clazz = object.eClass();
        return clazz == XtendPackage.Literals.XTEND_CLASS || clazz == XtendPackage.Literals.XTEND_FUNCTION || clazz == XtendPackage.Literals.XTEND_CONSTRUCTOR;
    }

    protected boolean shouldProcessContent(EObject object) {
        EClass clazz = object.eClass();
        return clazz == XtendPackage.Literals.XTEND_CLASS || clazz == XtendPackage.Literals.XTEND_FILE;
    }

    protected Collection<FoldedPosition> doGetFoldingRegions(IXtextDocument xtextDocument, XtextResource xtextResource) {
        Collection result = super.doGetFoldingRegions(xtextDocument, xtextResource);
        IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor = this.createAcceptor(xtextDocument, result, true);
        this.computeImportFolding(xtextResource, foldingRegionAcceptor);
        return result;
    }

    protected void computeImportFolding(XtextResource xtextResource, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        ICompositeNode node;
        XtendFile xtendFile;
        EList contents = xtextResource.getContents();
        if (!contents.isEmpty() && (xtendFile = (XtendFile)contents.get(0)).getImportSection() != null && xtendFile.getImportSection().getImportDeclarations().size() > 1 && (node = NodeModelUtils.findActualNodeFor((EObject)xtendFile.getImportSection())) != null) {
            foldingRegionAcceptor.accept(node.getOffset(), node.getLength());
        }
    }

    protected IFoldingRegionAcceptor<ITextRegion> createAcceptor(IXtextDocument xtextDocument, Collection<FoldedPosition> foldedPositions, final boolean initiallyCollapsed) {
        return new DefaultFoldingRegionAcceptor(xtextDocument, foldedPositions){

            protected FoldedPosition newFoldedPosition(IRegion region, ITextRegion significantRegion) {
                if (region == null) {
                    return null;
                }
                if (significantRegion != null) {
                    return new InitiallyCollapsableFoldedPosition(region.getOffset(), region.getLength(), significantRegion.getOffset() - region.getOffset(), significantRegion.getLength(), initiallyCollapsed);
                }
                return new InitiallyCollapsableFoldedPosition(region.getOffset(), region.getLength(), -1, -1, initiallyCollapsed);
            }
        };
    }
}

