/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.RuntimeIOException;

public class JavaIoFileSystemAccess
extends AbstractFileSystemAccess2 {
    @Inject
    private IEncodingProvider encodingProvider;
    @Inject
    private IResourceServiceProvider.Registry registry;
    @Inject
    private TraceFileNameProvider traceFileNameProvider;
    @Inject
    private TraceRegionSerializer traceSerializer;
    private boolean writeTrace = true;

    public JavaIoFileSystemAccess() {
    }

    public JavaIoFileSystemAccess(IResourceServiceProvider.Registry registry, IEncodingProvider encodingProvider) {
        this.registry = registry;
        this.encodingProvider = encodingProvider;
    }

    public JavaIoFileSystemAccess(IResourceServiceProvider.Registry registry, IEncodingProvider encodingProvider, TraceFileNameProvider traceFileNameProvider, TraceRegionSerializer traceRegionSerializer) {
        this.registry = registry;
        this.encodingProvider = encodingProvider;
        this.traceFileNameProvider = traceFileNameProvider;
        this.traceSerializer = traceRegionSerializer;
    }

    public void generateFile(String fileName, String outputConfigName, CharSequence contents) throws RuntimeIOException {
        File file = this.getFile(fileName, outputConfigName);
        try {
            this.createFolder(file.getParentFile());
            String encoding = this.getEncoding(this.getURI(fileName, outputConfigName));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
            try {
                writer.append(this.postProcess(fileName, outputConfigName, contents));
                if (this.writeTrace) {
                    this.generateTrace(fileName, outputConfigName, contents);
                }
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    protected void generateTrace(String generatedFile, String outputConfigName, CharSequence contents) {
        block6: {
            try {
                if (!(contents instanceof ITraceRegionProvider)) break block6;
                String traceFileName = this.traceFileNameProvider.getTraceFromJava(generatedFile);
                File traceFile = this.getFile(traceFileName, outputConfigName);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(traceFile));
                try {
                    AbstractTraceRegion traceRegion = ((ITraceRegionProvider)((Object)contents)).getTraceRegion();
                    this.traceSerializer.writeTraceRegionTo(traceRegion, out);
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException((Throwable)e);
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
    }

    public boolean isWriteTrace() {
        return this.writeTrace;
    }

    public void setWriteTrace(boolean writeTrace) {
        this.writeTrace = writeTrace;
    }

    protected String getEncoding(URI fileURI) {
        IResourceServiceProvider resourceServiceProvider = this.registry.getResourceServiceProvider(fileURI);
        if (resourceServiceProvider != null) {
            return resourceServiceProvider.getEncodingProvider().getEncoding(fileURI);
        }
        return this.encodingProvider.getEncoding(fileURI);
    }

    protected File getFile(String fileName, String outputConfigName) {
        String outlet = this.getPathes().get(outputConfigName);
        if (outlet == null) {
            throw new IllegalArgumentException("A slot with name '" + outputConfigName + "' has not been configured.");
        }
        String pathName = this.toSystemFileName(String.valueOf(outlet) + "/" + fileName);
        File file = new File(pathName).getAbsoluteFile();
        return file;
    }

    protected void createFolder(File parent) {
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new RuntimeIOException("Could not create directory " + parent);
        }
    }

    public void deleteFile(String fileName, String outputConfiguration) {
        File file = this.getFile(fileName, outputConfiguration);
        if (file.exists()) {
            file.delete();
        }
    }

    protected String toSystemFileName(String fileName) {
        return fileName.replace("/", File.separator);
    }

    public URI getURI(String fileName, String outputConfiguration) {
        return URI.createURI((String)this.getFile(fileName, outputConfiguration).toURI().toString());
    }

    public void generateFile(String fileName, String outputCfgName, InputStream content) throws RuntimeIOException {
        File file = this.getFile(fileName, outputCfgName);
        try {
            this.createFolder(file.getParentFile());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            try {
                ByteStreams.copy((InputStream)content, (OutputStream)out);
            }
            finally {
                try {
                    ((OutputStream)out).close();
                }
                finally {
                    content.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public InputStream readBinaryFile(String fileName, String outputCfgName) throws RuntimeIOException {
        File file = this.getFile(fileName, outputCfgName);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public CharSequence readTextFile(String fileName, String outputCfgName) throws RuntimeIOException {
        try {
            File file = this.getFile(fileName, outputCfgName);
            String encoding = this.getEncoding(this.getURI(fileName, outputCfgName));
            return new String(Files.toByteArray((File)file), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }
}

