/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class WildcardConformanceStrategy
extends TypeConformanceStrategy<WildcardTypeReference> {
    public WildcardConformanceStrategy(TypeConformanceComputer conformanceComputer) {
        super(conformanceComputer);
    }

    @Override
    protected TypeConformanceResult doVisitTypeReference(WildcardTypeReference leftWildcard, LightweightTypeReference right, TypeConformanceComputationArgument.Internal<WildcardTypeReference> param) {
        if (param.asTypeArgument) {
            LightweightTypeReference lowerBound = leftWildcard.getLowerBound();
            if (lowerBound != null) {
                TypeConformanceResult result = this.conformanceComputer.isConformant(right, lowerBound, new TypeConformanceComputationArgument(false, false, false, false, param.unboundComputationAddsHints, false));
                if (!result.isConformant()) {
                    return result;
                }
                return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
            }
            for (LightweightTypeReference upperBound : leftWildcard.getUpperBounds()) {
                TypeConformanceResult result = this.conformanceComputer.isConformant(upperBound, right, new TypeConformanceComputationArgument(false, false, false, false, param.unboundComputationAddsHints, false));
                if (result.isConformant()) continue;
                return result;
            }
            return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }

    @Override
    protected TypeConformanceResult doVisitMultiTypeReference(WildcardTypeReference left, CompoundTypeReference right, TypeConformanceComputationArgument.Internal<WildcardTypeReference> param) {
        return this.doVisitTypeReference(left, (LightweightTypeReference)right, param);
    }

    @Override
    protected TypeConformanceResult doVisitWildcardTypeReference(WildcardTypeReference leftWildcard, WildcardTypeReference rightWildcard, TypeConformanceComputationArgument.Internal<WildcardTypeReference> param) {
        if (param.asTypeArgument) {
            LightweightTypeReference leftLowerBound = leftWildcard.getLowerBound();
            if (leftLowerBound != null) {
                LightweightTypeReference rightLowerBound = rightWildcard.getLowerBound();
                if (rightLowerBound != null) {
                    TypeConformanceResult result = this.conformanceComputer.isConformant(rightLowerBound, leftLowerBound, new TypeConformanceComputationArgument(false, false, false, false, param.unboundComputationAddsHints, false));
                    if (!result.isConformant()) {
                        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
                    }
                } else {
                    return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
                }
                return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
            }
            for (LightweightTypeReference upperBound : leftWildcard.getUpperBounds()) {
                TypeConformanceResult result = this.conformanceComputer.isConformant(upperBound, (LightweightTypeReference)rightWildcard, new TypeConformanceComputationArgument(false, false, false, false, param.unboundComputationAddsHints, false));
                if (result.isConformant()) continue;
                return result;
            }
            return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }
}

