/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.xbase.formatting.BlankLineKey;
import org.eclipse.xtext.xbase.formatting.CommentInfo;
import org.eclipse.xtext.xbase.formatting.FormattableDocument;
import org.eclipse.xtext.xbase.formatting.FormattingData;
import org.eclipse.xtext.xbase.formatting.FormattingDataInit;
import org.eclipse.xtext.xbase.formatting.FormattingPreferenceValues;
import org.eclipse.xtext.xbase.formatting.HiddenLeafAccess;
import org.eclipse.xtext.xbase.formatting.HiddenLeafs;
import org.eclipse.xtext.xbase.formatting.LeafInfo;
import org.eclipse.xtext.xbase.formatting.NewLineData;
import org.eclipse.xtext.xbase.formatting.NewLineKey;
import org.eclipse.xtext.xbase.formatting.NewLineOrPreserveKey;
import org.eclipse.xtext.xbase.formatting.WhitespaceData;
import org.eclipse.xtext.xbase.formatting.WhitespaceInfo;
import org.eclipse.xtext.xbase.formatting.WhitespaceKey;
import org.eclipse.xtext.xbase.formatting.XbaseFormatterPreferenceKeys;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattingDataFactory {
    @Inject
    @Extension
    private HiddenLeafAccess _hiddenLeafAccess;

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> newFormattingData(HiddenLeafs leafs, Procedures.Procedure1<? super FormattingDataInit> init) {
        Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData;
        FormattingDataInit _formattingDataInit;
        Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _xblockexpression = null;
        FormattingDataInit data = _formattingDataInit = new FormattingDataInit();
        init.apply((Object)data);
        _xblockexpression = _newFormattingData = this.newFormattingData(leafs, data.key, data);
        return _xblockexpression;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData(final HiddenLeafs leafs, Void key, final FormattingDataInit it) {
        Functions.Function1<FormattableDocument, Iterable<FormattingData>> _function = new Functions.Function1<FormattableDocument, Iterable<FormattingData>>(){

            public Iterable<FormattingData> apply(FormattableDocument doc) {
                boolean _equals;
                boolean _and = false;
                int _newLinesInComments = leafs.getNewLinesInComments();
                boolean bl = _equals = _newLinesInComments == 0;
                if (!_equals) {
                    _and = false;
                } else {
                    boolean _equals_1;
                    boolean _or = false;
                    boolean bl2 = _equals_1 = it.newLines == 0;
                    if (_equals_1) {
                        _or = true;
                    } else {
                        boolean _equals_2 = Objects.equal((Object)it.space, (Object)"");
                        _or = _equals_1 || _equals_2;
                    }
                    boolean bl3 = _and = _equals && _or;
                }
                if (_and) {
                    boolean _isDebugConflicts = doc.isDebugConflicts();
                    return FormattingDataFactory.this.newWhitespaceData(leafs, it.space, it.increaseIndentationChange, it.decreaseIndentationChange, _isDebugConflicts);
                }
                boolean _isDebugConflicts_1 = doc.isDebugConflicts();
                return FormattingDataFactory.this.newNewLineData(leafs, it.newLines, it.newLines, it.increaseIndentationChange, it.decreaseIndentationChange, _isDebugConflicts_1);
            }
        };
        return _function;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData(final HiddenLeafs leafs, final BlankLineKey key, final FormattingDataInit it) {
        Functions.Function1<FormattableDocument, Iterable<FormattingData>> _function = new Functions.Function1<FormattableDocument, Iterable<FormattingData>>(){

            public Iterable<FormattingData> apply(FormattableDocument doc) {
                Iterable<FormattingData> _newNewLineData;
                Iterable<FormattingData> _xblockexpression = null;
                FormattingPreferenceValues _cfg = doc.getCfg();
                int blankline = _cfg.get(key);
                FormattingPreferenceValues _cfg_1 = doc.getCfg();
                int preserve = _cfg_1.get(XbaseFormatterPreferenceKeys.preserveBlankLines);
                int min = blankline + 1;
                int _plus = preserve + 1;
                int max = Math.max(_plus, min);
                boolean _isDebugConflicts = doc.isDebugConflicts();
                _xblockexpression = _newNewLineData = FormattingDataFactory.this.newNewLineData(leafs, min, max, it.increaseIndentationChange, it.decreaseIndentationChange, _isDebugConflicts);
                return _xblockexpression;
            }
        };
        return _function;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData(final HiddenLeafs leafs, final NewLineOrPreserveKey key, final FormattingDataInit it) {
        Functions.Function1<FormattableDocument, Iterable<FormattingData>> _function = new Functions.Function1<FormattableDocument, Iterable<FormattingData>>(){

            public Iterable<FormattingData> apply(FormattableDocument doc) {
                Iterable<FormattingData> _newNewLineData;
                Iterable<FormattingData> _xblockexpression = null;
                FormattingPreferenceValues _cfg = doc.getCfg();
                boolean newLine = _cfg.get(key);
                FormattingPreferenceValues _cfg_1 = doc.getCfg();
                boolean preserve = _cfg_1.get(XbaseFormatterPreferenceKeys.preserveNewLines);
                int _xifexpression = 0;
                _xifexpression = newLine ? 1 : 0;
                int _xifexpression_1 = 0;
                boolean _or = false;
                _or = preserve ? true : preserve || newLine;
                _xifexpression_1 = _or ? 1 : 0;
                boolean _isDebugConflicts = doc.isDebugConflicts();
                _xblockexpression = _newNewLineData = FormattingDataFactory.this.newNewLineData(leafs, _xifexpression, _xifexpression_1, it.increaseIndentationChange, it.decreaseIndentationChange, _isDebugConflicts);
                return _xblockexpression;
            }
        };
        return _function;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData(final HiddenLeafs leafs, final NewLineKey key, final FormattingDataInit it) {
        Functions.Function1<FormattableDocument, Iterable<FormattingData>> _function = new Functions.Function1<FormattableDocument, Iterable<FormattingData>>(){

            public Iterable<FormattingData> apply(FormattableDocument doc) {
                Iterable<FormattingData> _newNewLineData;
                Iterable<FormattingData> _xblockexpression = null;
                FormattingPreferenceValues _cfg = doc.getCfg();
                boolean newLine = _cfg.get(key);
                int _xifexpression = 0;
                _xifexpression = newLine ? 1 : 0;
                int minmax = _xifexpression;
                boolean _isDebugConflicts = doc.isDebugConflicts();
                _xblockexpression = _newNewLineData = FormattingDataFactory.this.newNewLineData(leafs, minmax, minmax, it.increaseIndentationChange, it.decreaseIndentationChange, _isDebugConflicts);
                return _xblockexpression;
            }
        };
        return _function;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData(HiddenLeafs leafs, PreferenceKey key, FormattingDataInit it) {
        Class<?> _class = key.getClass();
        String _plus = "Unknown configuration key kind: " + _class;
        RuntimeException _runtimeException = new RuntimeException(_plus);
        throw _runtimeException;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData(final HiddenLeafs leafs, final WhitespaceKey key, final FormattingDataInit it) {
        Functions.Function1<FormattableDocument, Iterable<FormattingData>> _function = new Functions.Function1<FormattableDocument, Iterable<FormattingData>>(){

            public Iterable<FormattingData> apply(FormattableDocument doc) {
                Iterable<FormattingData> _newWhitespaceData;
                Iterable<FormattingData> _xblockexpression = null;
                FormattingPreferenceValues _cfg = doc.getCfg();
                boolean space = _cfg.get(key);
                String _xifexpression = null;
                _xifexpression = space ? " " : "";
                boolean _isDebugConflicts = doc.isDebugConflicts();
                _xblockexpression = _newWhitespaceData = FormattingDataFactory.this.newWhitespaceData(leafs, _xifexpression, it.increaseIndentationChange, it.decreaseIndentationChange, _isDebugConflicts);
                return _xblockexpression;
            }
        };
        return _function;
    }

    protected Iterable<FormattingData> newWhitespaceData(HiddenLeafs leafs, String space, int increaseIndentationChange, int decreaseIndentationChange, boolean trace) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList((Object[])new FormattingData[0]);
        boolean isFirst = true;
        List<LeafInfo> _leafs = leafs.getLeafs();
        for (LeafInfo leaf : _leafs) {
            boolean _matched = false;
            if (!_matched && leaf instanceof WhitespaceInfo) {
                WhitespaceInfo _whitespaceInfo = (WhitespaceInfo)leaf;
                _matched = true;
                int _offset = _whitespaceInfo.getOffset();
                int _length = _whitespaceInfo.getLength();
                int _xifexpression = 0;
                _xifexpression = isFirst ? increaseIndentationChange : 0;
                int _xifexpression_1 = 0;
                _xifexpression_1 = isFirst ? decreaseIndentationChange : 0;
                RuntimeException _xifexpression_2 = null;
                if (trace) {
                    RuntimeException _runtimeException;
                    _xifexpression_2 = _runtimeException = new RuntimeException();
                }
                WhitespaceData _whitespaceData = new WhitespaceData(_offset, _length, _xifexpression, _xifexpression_1, _xifexpression_2, space);
                result.add(_whitespaceData);
                isFirst = false;
            }
            if (_matched || !(leaf instanceof CommentInfo)) continue;
            CommentInfo _commentInfo = (CommentInfo)leaf;
            _matched = true;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected Iterable<FormattingData> newNewLineData(HiddenLeafs leafs, int minNewLines, int maxNewLines, int increaseIndentationChange, int decreaseIndentationChange, boolean trace) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList((Object[])new FormattingData[0]);
        boolean applied = false;
        List<LeafInfo> _leafs = leafs.getLeafs();
        for (LeafInfo leaf : _leafs) {
            boolean _matched = false;
            if (!_matched && leaf instanceof WhitespaceInfo) {
                boolean _isTrailing;
                WhitespaceInfo _whitespaceInfo = (WhitespaceInfo)leaf;
                _matched = true;
                int _minus = -1;
                int _multiply = decreaseIndentationChange * _minus;
                boolean equalIndentationChange = increaseIndentationChange == _multiply;
                boolean _and = false;
                CommentInfo _trailingComment = _whitespaceInfo.trailingComment();
                boolean bl = _isTrailing = _trailingComment == null ? false : _trailingComment.isTrailing();
                if (!_isTrailing) {
                    _and = false;
                } else {
                    CommentInfo _trailingComment_1 = _whitespaceInfo.trailingComment();
                    boolean _isMultiline = _trailingComment_1 == null ? false : _trailingComment_1.isMultiline();
                    boolean _not = !_isMultiline;
                    boolean bl2 = _and = _isTrailing && _not;
                }
                if (_and) {
                    String _xifexpression = null;
                    int _offset = _whitespaceInfo.getOffset();
                    boolean _equals = _offset == 0;
                    _xifexpression = _equals ? "" : " ";
                    String space = _xifexpression;
                    int _offset_1 = _whitespaceInfo.getOffset();
                    int _length = _whitespaceInfo.getLength();
                    RuntimeException _xifexpression_1 = null;
                    if (trace) {
                        RuntimeException _runtimeException;
                        _xifexpression_1 = _runtimeException = new RuntimeException();
                    }
                    WhitespaceData _whitespaceData = new WhitespaceData(_offset_1, _length, 0, 0, _xifexpression_1, space);
                    result.add(_whitespaceData);
                } else {
                    boolean _not_1;
                    boolean bl3 = _not_1 = !applied;
                    if (_not_1) {
                        boolean _not_2;
                        CommentInfo _leadingComment_1;
                        boolean _endsWithNewLine;
                        boolean _lessThan;
                        int _newLines = leafs.getNewLines();
                        int _max = Math.max(_newLines, minNewLines);
                        int newLines = Math.min(_max, maxNewLines);
                        boolean _and_1 = false;
                        boolean _and_2 = false;
                        boolean bl4 = _lessThan = newLines < 1;
                        if (!_lessThan) {
                            _and_2 = false;
                        } else {
                            int _offset_2 = _whitespaceInfo.getOffset();
                            boolean _greaterThan = _offset_2 > 0;
                            boolean bl5 = _and_2 = _lessThan && _greaterThan;
                        }
                        if (!_and_2) {
                            _and_1 = false;
                        } else {
                            boolean _isMultiline_1;
                            boolean _or = false;
                            CommentInfo _leadingComment = _whitespaceInfo.leadingComment();
                            boolean bl6 = _isMultiline_1 = _leadingComment == null ? false : _leadingComment.isMultiline();
                            if (_isMultiline_1) {
                                _or = true;
                            } else {
                                CommentInfo _trailingComment_2 = _whitespaceInfo.trailingComment();
                                boolean _isMultiline_2 = _trailingComment_2 == null ? false : _trailingComment_2.isMultiline();
                                _or = _isMultiline_1 || _isMultiline_2;
                            }
                            boolean bl7 = _and_1 = _and_2 && _or;
                        }
                        if (_and_1) {
                            newLines = 1;
                        }
                        boolean bl8 = _endsWithNewLine = (_leadingComment_1 = _whitespaceInfo.leadingComment()) == null ? false : _leadingComment_1.endsWithNewLine();
                        if (_endsWithNewLine) {
                            int _minus_1;
                            newLines = _minus_1 = newLines - 1;
                        }
                        boolean _and_3 = false;
                        CommentInfo _leadingComment_2 = _whitespaceInfo.leadingComment();
                        boolean _endsWithNewLine_1 = _leadingComment_2 == null ? false : _leadingComment_2.endsWithNewLine();
                        boolean bl9 = _not_2 = !_endsWithNewLine_1;
                        if (!_not_2) {
                            _and_3 = false;
                        } else {
                            boolean _equals_1 = newLines == 0;
                            boolean bl10 = _and_3 = _not_2 && _equals_1;
                        }
                        if (_and_3) {
                            int _offset_3 = _whitespaceInfo.getOffset();
                            int _length_1 = _whitespaceInfo.getLength();
                            RuntimeException _xifexpression_2 = null;
                            if (trace) {
                                RuntimeException _runtimeException_1;
                                _xifexpression_2 = _runtimeException_1 = new RuntimeException();
                            }
                            String _xifexpression_3 = null;
                            int _offset_4 = _whitespaceInfo.getOffset();
                            boolean _equals_2 = _offset_4 == 0;
                            _xifexpression_3 = _equals_2 ? "" : " ";
                            WhitespaceData _whitespaceData_1 = new WhitespaceData(_offset_3, _length_1, increaseIndentationChange, decreaseIndentationChange, _xifexpression_2, _xifexpression_3);
                            result.add(_whitespaceData_1);
                        } else {
                            boolean _and_4 = false;
                            if (!equalIndentationChange) {
                                _and_4 = false;
                            } else {
                                List<LeafInfo> _leafs_1 = leafs.getLeafs();
                                LeafInfo _last = (LeafInfo)IterableExtensions.last(_leafs_1);
                                boolean _notEquals = !Objects.equal((Object)_last, (Object)_whitespaceInfo);
                                boolean bl11 = _and_4 = equalIndentationChange && _notEquals;
                            }
                            if (_and_4) {
                                int _offset_5 = _whitespaceInfo.getOffset();
                                int _length_2 = _whitespaceInfo.getLength();
                                RuntimeException _xifexpression_4 = null;
                                if (trace) {
                                    RuntimeException _runtimeException_2;
                                    _xifexpression_4 = _runtimeException_2 = new RuntimeException();
                                }
                                NewLineData _newLineData = new NewLineData(_offset_5, _length_2, increaseIndentationChange, decreaseIndentationChange, _xifexpression_4, newLines);
                                result.add(_newLineData);
                            } else {
                                int _offset_6 = _whitespaceInfo.getOffset();
                                int _length_3 = _whitespaceInfo.getLength();
                                int _xifexpression_5 = 0;
                                _xifexpression_5 = equalIndentationChange ? 0 : increaseIndentationChange;
                                int _xifexpression_6 = 0;
                                _xifexpression_6 = equalIndentationChange ? 0 : decreaseIndentationChange;
                                RuntimeException _xifexpression_7 = null;
                                if (trace) {
                                    RuntimeException _runtimeException_3;
                                    _xifexpression_7 = _runtimeException_3 = new RuntimeException();
                                }
                                NewLineData _newLineData_1 = new NewLineData(_offset_6, _length_3, _xifexpression_5, _xifexpression_6, _xifexpression_7, newLines);
                                result.add(_newLineData_1);
                            }
                        }
                        applied = true;
                    } else {
                        boolean _endsWithNewLine_2;
                        int newLines_1 = 1;
                        CommentInfo _leadingComment_3 = _whitespaceInfo.leadingComment();
                        boolean bl12 = _endsWithNewLine_2 = _leadingComment_3 == null ? false : _leadingComment_3.endsWithNewLine();
                        if (_endsWithNewLine_2) {
                            int _minus_2;
                            newLines_1 = _minus_2 = newLines_1 - 1;
                        }
                        boolean _and_5 = false;
                        if (!equalIndentationChange) {
                            _and_5 = false;
                        } else {
                            List<LeafInfo> _leafs_2 = leafs.getLeafs();
                            LeafInfo _last_1 = (LeafInfo)IterableExtensions.last(_leafs_2);
                            boolean _notEquals_1 = !Objects.equal((Object)_last_1, (Object)_whitespaceInfo);
                            boolean bl13 = _and_5 = equalIndentationChange && _notEquals_1;
                        }
                        if (_and_5) {
                            int _offset_7 = _whitespaceInfo.getOffset();
                            int _length_4 = _whitespaceInfo.getLength();
                            RuntimeException _xifexpression_8 = null;
                            if (trace) {
                                RuntimeException _runtimeException_4;
                                _xifexpression_8 = _runtimeException_4 = new RuntimeException();
                            }
                            NewLineData _newLineData_2 = new NewLineData(_offset_7, _length_4, increaseIndentationChange, decreaseIndentationChange, _xifexpression_8, newLines_1);
                            result.add(_newLineData_2);
                        } else {
                            int _offset_8 = _whitespaceInfo.getOffset();
                            int _length_5 = _whitespaceInfo.getLength();
                            RuntimeException _xifexpression_9 = null;
                            if (trace) {
                                RuntimeException _runtimeException_5;
                                _xifexpression_9 = _runtimeException_5 = new RuntimeException();
                            }
                            NewLineData _newLineData_3 = new NewLineData(_offset_8, _length_5, 0, 0, _xifexpression_9, newLines_1);
                            result.add(_newLineData_3);
                        }
                    }
                }
            }
            if (_matched || !(leaf instanceof CommentInfo)) continue;
            CommentInfo _commentInfo = (CommentInfo)leaf;
            _matched = true;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> append(INode node, Procedures.Procedure1<? super FormattingDataInit> init) {
        boolean _notEquals;
        Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)node, null);
        if (_notEquals) {
            Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData;
            HiddenLeafs _hiddenLeafsAfter = this._hiddenLeafAccess.getHiddenLeafsAfter(node);
            _xifexpression = _newFormattingData = this.newFormattingData(_hiddenLeafsAfter, init);
        }
        return _xifexpression;
    }

    public Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> prepend(INode node, Procedures.Procedure1<? super FormattingDataInit> init) {
        boolean _notEquals;
        Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)node, null);
        if (_notEquals) {
            Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData;
            HiddenLeafs _hiddenLeafsBefore = this._hiddenLeafAccess.getHiddenLeafsBefore(node);
            _xifexpression = _newFormattingData = this.newFormattingData(_hiddenLeafsBefore, init);
        }
        return _xifexpression;
    }

    public Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> surround(final INode node, final Procedures.Procedure1<? super FormattingDataInit> init) {
        Functions.Function1<FormattableDocument, ArrayList<FormattingData>> _function = new Functions.Function1<FormattableDocument, ArrayList<FormattingData>>(){

            public ArrayList<FormattingData> apply(FormattableDocument doc) {
                boolean _notEquals;
                ArrayList _xblockexpression = null;
                ArrayList result = CollectionLiterals.newArrayList((Object[])new FormattingData[0]);
                boolean bl = _notEquals = !Objects.equal((Object)node, null);
                if (_notEquals) {
                    Iterable _apply_1;
                    Iterable _apply;
                    Iterable _elvis = null;
                    HiddenLeafs _hiddenLeafsBefore = FormattingDataFactory.this._hiddenLeafAccess.getHiddenLeafsBefore(node);
                    Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData = FormattingDataFactory.this.newFormattingData(_hiddenLeafsBefore, (Procedures.Procedure1<? super FormattingDataInit>)init);
                    Iterable iterable = _apply = _newFormattingData == null ? null : (Iterable)_newFormattingData.apply((Object)doc);
                    if (_apply != null) {
                        _elvis = _apply;
                    } else {
                        List _emptyList = CollectionLiterals.emptyList();
                        _elvis = (Iterable)ObjectExtensions.operator_elvis((Object)_apply, (Object)_emptyList);
                    }
                    Iterables.addAll((Collection)result, (Iterable)_elvis);
                    Iterable _elvis_1 = null;
                    HiddenLeafs _hiddenLeafsAfter = FormattingDataFactory.this._hiddenLeafAccess.getHiddenLeafsAfter(node);
                    Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData_1 = FormattingDataFactory.this.newFormattingData(_hiddenLeafsAfter, (Procedures.Procedure1<? super FormattingDataInit>)init);
                    Iterable iterable2 = _apply_1 = _newFormattingData_1 == null ? null : (Iterable)_newFormattingData_1.apply((Object)doc);
                    if (_apply_1 != null) {
                        _elvis_1 = _apply_1;
                    } else {
                        List _emptyList_1 = CollectionLiterals.emptyList();
                        _elvis_1 = (Iterable)ObjectExtensions.operator_elvis((Object)_apply_1, (Object)_emptyList_1);
                    }
                    Iterables.addAll((Collection)result, (Iterable)_elvis_1);
                }
                _xblockexpression = result;
                return _xblockexpression;
            }
        };
        return _function;
    }

    public Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> surround(final INode node, final Procedures.Procedure1<? super FormattingDataInit> before, final Procedures.Procedure1<? super FormattingDataInit> after) {
        Functions.Function1<FormattableDocument, ArrayList<FormattingData>> _function = new Functions.Function1<FormattableDocument, ArrayList<FormattingData>>(){

            public ArrayList<FormattingData> apply(FormattableDocument doc) {
                boolean _notEquals;
                ArrayList _xblockexpression = null;
                ArrayList result = CollectionLiterals.newArrayList((Object[])new FormattingData[0]);
                boolean bl = _notEquals = !Objects.equal((Object)node, null);
                if (_notEquals) {
                    Iterable _apply_1;
                    Iterable _apply;
                    Iterable _elvis = null;
                    HiddenLeafs _hiddenLeafsBefore = FormattingDataFactory.this._hiddenLeafAccess.getHiddenLeafsBefore(node);
                    Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData = FormattingDataFactory.this.newFormattingData(_hiddenLeafsBefore, (Procedures.Procedure1<? super FormattingDataInit>)before);
                    Iterable iterable = _apply = _newFormattingData == null ? null : (Iterable)_newFormattingData.apply((Object)doc);
                    if (_apply != null) {
                        _elvis = _apply;
                    } else {
                        List _emptyList = CollectionLiterals.emptyList();
                        _elvis = (Iterable)ObjectExtensions.operator_elvis((Object)_apply, (Object)_emptyList);
                    }
                    Iterables.addAll((Collection)result, (Iterable)_elvis);
                    Iterable _elvis_1 = null;
                    HiddenLeafs _hiddenLeafsAfter = FormattingDataFactory.this._hiddenLeafAccess.getHiddenLeafsAfter(node);
                    Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData_1 = FormattingDataFactory.this.newFormattingData(_hiddenLeafsAfter, (Procedures.Procedure1<? super FormattingDataInit>)after);
                    Iterable iterable2 = _apply_1 = _newFormattingData_1 == null ? null : (Iterable)_newFormattingData_1.apply((Object)doc);
                    if (_apply_1 != null) {
                        _elvis_1 = _apply_1;
                    } else {
                        List _emptyList_1 = CollectionLiterals.emptyList();
                        _elvis_1 = (Iterable)ObjectExtensions.operator_elvis((Object)_apply_1, (Object)_emptyList_1);
                    }
                    Iterables.addAll((Collection)result, (Iterable)_elvis_1);
                }
                _xblockexpression = result;
                return _xblockexpression;
            }
        };
        return _function;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> newFormattingData(HiddenLeafs leafs, PreferenceKey key, FormattingDataInit it) {
        if (key instanceof BlankLineKey) {
            return this._newFormattingData(leafs, (BlankLineKey)key, it);
        }
        if (key instanceof NewLineKey) {
            return this._newFormattingData(leafs, (NewLineKey)key, it);
        }
        if (key instanceof NewLineOrPreserveKey) {
            return this._newFormattingData(leafs, (NewLineOrPreserveKey)key, it);
        }
        if (key instanceof WhitespaceKey) {
            return this._newFormattingData(leafs, (WhitespaceKey)key, it);
        }
        if (key == null) {
            return this._newFormattingData(leafs, (Void)null, it);
        }
        if (key != null) {
            return this._newFormattingData(leafs, key, it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(leafs, key, it).toString());
    }
}

