/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping;

import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;

public class NestedTypeAwareImportNormalizer
extends ImportNormalizer {
    public NestedTypeAwareImportNormalizer(QualifiedName importedNamespace, boolean wildcard, boolean ignoreCase) {
        super(importedNamespace, wildcard, ignoreCase);
        if (ignoreCase) {
            throw new IllegalArgumentException("ignoreCase is currently not supported");
        }
    }

    public QualifiedName deresolve(QualifiedName fullyQualifiedName) {
        if (this.hasWildCard()) {
            if (fullyQualifiedName.startsWith(this.getImportedNamespacePrefix()) && fullyQualifiedName.getSegmentCount() != this.getImportedNamespacePrefix().getSegmentCount()) {
                return fullyQualifiedName.skipFirst(this.getImportedNamespacePrefix().getSegmentCount());
            }
        } else {
            if (fullyQualifiedName.equals((Object)this.getImportedNamespacePrefix())) {
                String lastSegment = fullyQualifiedName.getLastSegment();
                int dollar = lastSegment.lastIndexOf(36);
                if (dollar >= 0) {
                    return QualifiedName.create((String)lastSegment.substring(dollar + 1));
                }
                return QualifiedName.create((String)fullyQualifiedName.getLastSegment());
            }
            if (fullyQualifiedName.skipLast(1).equals((Object)this.getImportedNamespacePrefix().skipLast(1))) {
                String lastImportedSegment = this.getImportedNamespacePrefix().getLastSegment();
                String lastSegment = fullyQualifiedName.getLastSegment();
                if (lastSegment.startsWith(lastImportedSegment) && lastSegment.charAt(lastImportedSegment.length()) == '$') {
                    int dollar = lastImportedSegment.lastIndexOf(36);
                    if (dollar == -1) {
                        return fullyQualifiedName.skipFirst(this.getImportedNamespacePrefix().getSegmentCount() - 1);
                    }
                    return QualifiedName.create((String)lastSegment.substring(dollar + 1));
                }
            }
        }
        return null;
    }

    public QualifiedName resolve(QualifiedName relativeName) {
        if (this.hasWildCard()) {
            return this.getImportedNamespacePrefix().append(relativeName);
        }
        if (relativeName.getSegmentCount() == 1) {
            String nestedTypeName;
            if (relativeName.getLastSegment().equals(this.getImportedNamespacePrefix().getLastSegment())) {
                return this.getImportedNamespacePrefix();
            }
            String relativeNameAsString = relativeName.getLastSegment();
            String lastImportedSegment = this.getImportedNamespacePrefix().getLastSegment();
            int dollar = relativeNameAsString.indexOf(36);
            if (dollar >= 0 && dollar == lastImportedSegment.length() && relativeNameAsString.startsWith(lastImportedSegment)) {
                return this.getImportedNamespacePrefix().skipLast(1).append(relativeNameAsString);
            }
            int importedDollar = lastImportedSegment.lastIndexOf(36);
            if (importedDollar >= 0 && relativeNameAsString.startsWith(nestedTypeName = lastImportedSegment.substring(importedDollar + 1))) {
                if (nestedTypeName.length() == relativeNameAsString.length()) {
                    return this.getImportedNamespacePrefix();
                }
                if (relativeNameAsString.charAt(nestedTypeName.length()) == '$') {
                    return this.getImportedNamespacePrefix().skipLast(1).append(String.valueOf(lastImportedSegment) + relativeNameAsString.substring(nestedTypeName.length()));
                }
            }
        }
        return null;
    }
}

