/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.compare;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IViewerCreator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xtext.ui.compare.DefaultContentViewer;
import org.eclipse.xtext.ui.compare.DefaultMergeEditor;
import org.eclipse.xtext.ui.compare.DefaultMergeViewer;
import org.eclipse.xtext.ui.compare.StreamContentDocumentProvider;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;

public class DefaultViewerCreator
implements IViewerCreator {
    @Inject
    protected Provider<DefaultContentViewer> contentViewerProvider;
    @Inject
    protected Provider<DefaultMergeEditor> mergeEditorProvider;
    @Inject
    protected StreamContentDocumentProvider documentProvider;
    @Inject
    protected Provider<XtextSourceViewerConfiguration> sourceViewerConfigurationProvider;

    public Viewer createViewer(Composite parent, CompareConfiguration compareConfiguration) {
        if (compareConfiguration == null) {
            return this.createContentViever(parent, compareConfiguration);
        }
        return this.createMergeViewer(parent, compareConfiguration);
    }

    protected Viewer createMergeViewer(Composite parent, CompareConfiguration compareConfiguration) {
        compareConfiguration.setProperty(DefaultMergeEditor.PROVIDER, this.mergeEditorProvider);
        return new DefaultMergeViewer(parent, 0, compareConfiguration, this.documentProvider, this.sourceViewerConfigurationProvider);
    }

    protected Viewer createContentViever(Composite parent, CompareConfiguration compareConfiguration) {
        DefaultContentViewer defaultContentViewer = (DefaultContentViewer)((Object)this.contentViewerProvider.get());
        defaultContentViewer.init(parent, compareConfiguration);
        return defaultContentViewer;
    }
}

