/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.IRawTypeHelper;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.FeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.LocalVariableScope;
import org.eclipse.xtext.xbase.scoping.batch.ReceiverFeatureScope;
import org.eclipse.xtext.xbase.scoping.batch.StaticExtensionImportsScope;
import org.eclipse.xtext.xbase.scoping.batch.StaticImportsScope;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.featurecalls.DefaultJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.scoping.featurecalls.StaticImplicitMethodsFeatureForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.XAssignmentDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.XAssignmentSugarDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.XFeatureCallSugarDescriptionProvider;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureScopeProvider
implements FeatureNames {
    @Inject
    private Provider<DefaultJvmFeatureDescriptionProvider> defaultFeatureDescProvider;
    @Inject
    private Provider<XFeatureCallSugarDescriptionProvider> sugarFeatureDescProvider;
    @Inject
    private Provider<StaticImplicitMethodsFeatureForTypeProvider> implicitStaticFeatures;
    @Inject
    private Provider<XAssignmentDescriptionProvider> assignmentFeatureDescProvider;
    @Inject
    private Provider<XAssignmentSugarDescriptionProvider> assignmentSugarFeatureDescProvider;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private IRawTypeHelper rawTypeHelper;
    @Inject
    private OperatorMapping operatorMapping;
    protected static final int DEFAULT_MEMBER_CALL_PRIORITY = 0;
    protected static final int DEFAULT_IT_PRIORITY = 10;
    protected static final int DEFAULT_THIS_PRIORITY = 20;
    protected static final int DEFAULT_IMPLICIT_STATIC_FEATURE_PRIORITY = 60;
    protected static final int DEFAULT_SUGAR_PRIORITY_OFFSET = 100;
    protected static final int DEFAULT_STATIC_EXTENSION_PRIORITY_OFFSET = 230;

    public IScope createFeatureCallScope(EObject context, EReference reference, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        if (!(context instanceof XAbstractFeatureCall)) {
            return IScope.NULLSCOPE;
        }
        XAbstractFeatureCall call = (XAbstractFeatureCall)context;
        XExpression syntacticalReceiver = this.getSyntacticalReceiver(call);
        if (syntacticalReceiver == null) {
            IScope result = this.createSimpleFeatureCallScope(call, reference, session, resolvedTypes);
            return result;
        }
        IScope result = this.createFeatureCallScopeForReceiver(call, syntacticalReceiver, reference, session, resolvedTypes);
        return result;
    }

    public boolean isFeatureCallScope(EReference reference) {
        return reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
    }

    public IScope createSimpleFeatureCallScope(EObject context, EReference reference, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        XFeatureCall featureCall;
        if (context instanceof XFeatureCall && (featureCall = (XFeatureCall)context).getDeclaringType() != null) {
            TypeBucket receiverBucket = new TypeBucket(-1, Collections.singletonList(featureCall.getDeclaringType()));
            return new ReceiverFeatureScope(IScope.NULLSCOPE, session, null, null, this.asAbstractFeatureCall(context), receiverBucket, this.operatorMapping);
        }
        IScope staticImports = this.createStaticFeaturesScope(context, IScope.NULLSCOPE, session);
        StaticExtensionImportsScope staticExtensions = this.createStaticExtensionsScope(null, null, context, staticImports, session);
        IScope implicitReceivers = this.createImplicitFeatureCallScope(context, (IScope)staticExtensions, session, resolvedTypes);
        LocalVariableScope localVariables = new LocalVariableScope(implicitReceivers, session, this.asAbstractFeatureCall(context));
        return localVariables;
    }

    protected XAbstractFeatureCall asAbstractFeatureCall(EObject context) {
        return context instanceof XAbstractFeatureCall ? (XAbstractFeatureCall)context : null;
    }

    protected IScope createFeatureScopeForTypeRef(XExpression receiver, JvmTypeReference featureDeclarator, EObject featureCall, IFeatureScopeSession session, IScope parent) {
        List rawTypes = this.rawTypeHelper.getAllRawTypes(featureDeclarator, featureCall.eResource());
        TypeBucket typeBucket = new TypeBucket(-1, rawTypes);
        ReceiverFeatureScope result = new ReceiverFeatureScope(parent, session, receiver, featureDeclarator, this.asAbstractFeatureCall(featureCall), typeBucket, this.operatorMapping);
        return result;
    }

    public IScope createFeatureCallScopeForReceiver(XExpression featureCall, XExpression receiver, EReference reference, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        if (!this.isFeatureCallScope(reference)) {
            return IScope.NULLSCOPE;
        }
        if (receiver == null || receiver.eIsProxy()) {
            return IScope.NULLSCOPE;
        }
        JvmTypeReference receiverType = resolvedTypes.getActualType(receiver);
        if (receiverType != null) {
            StaticExtensionImportsScope result = this.createStaticExtensionsScope(receiver, receiverType, featureCall, IScope.NULLSCOPE, session);
            return this.createFeatureScopeForTypeRef(receiver, receiverType, featureCall, session, (IScope)result);
        }
        return IScope.NULLSCOPE;
    }

    protected StaticExtensionImportsScope createStaticExtensionsScope(XExpression receiver, JvmTypeReference receiverType, EObject featureCall, IScope parent, IFeatureScopeSession session) {
        return new StaticExtensionImportsScope(parent, session, receiver, receiverType, this.asAbstractFeatureCall(featureCall), this.operatorMapping);
    }

    protected XExpression getSyntacticalReceiver(XAbstractFeatureCall call) {
        if (call instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)call).getMemberCallTarget();
        }
        if (call instanceof XBinaryOperation) {
            return ((XBinaryOperation)call).getLeftOperand();
        }
        if (call instanceof XUnaryOperation) {
            return ((XUnaryOperation)call).getOperand();
        }
        if (call instanceof XAssignment) {
            return ((XAssignment)call).getAssignable();
        }
        return null;
    }

    protected IScope createStaticFeaturesScope(EObject featureCall, IScope parent, IFeatureScopeSession session) {
        return new StaticImportsScope(parent, session, this.asAbstractFeatureCall(featureCall));
    }

    protected IScope createImplicitFeatureCallScope(EObject featureCall, IScope parent, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        IScope result = parent;
        result = this.createImplicitFeatureCallScope(THIS, featureCall, session, resolvedTypes, result);
        result = this.createImplicitFeatureCallScope(IT, featureCall, session, resolvedTypes, result);
        return result;
    }

    protected IScope createImplicitFeatureCallScope(QualifiedName implicitName, EObject featureCall, IFeatureScopeSession session, IResolvedTypes resolvedTypes, IScope parent) {
        IEObjectDescription thisDescription = session.getLocalElement(implicitName);
        if (thisDescription != null) {
            JvmIdentifiableElement thisElement = (JvmIdentifiableElement)thisDescription.getEObjectOrProxy();
            JvmTypeReference type = resolvedTypes.getActualType(thisElement);
            return this.createFeatureScopeForTypeRef(null, type, featureCall, session, parent);
        }
        return parent;
    }

    protected void addStaticFeatureDescriptionProviders(Resource resource, JvmDeclaredType contextType, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        StaticImplicitMethodsFeatureForTypeProvider implicitMethodsProvider = this.newImplicitStaticFeaturesProvider();
        implicitMethodsProvider.setResourceContext(resource);
        this.addFeatureDescriptionProviders(contextType, implicitMethodsProvider, null, null, this.getImplicitStaticFeaturePriority(), true, acceptor);
    }

    protected int getThisPriority() {
        return 20;
    }

    protected int getDefaultPriority() {
        return 0;
    }

    protected int getItPriority() {
        return 10;
    }

    protected int getSugarPriorityOffset() {
        return 100;
    }

    protected int getImplicitStaticExtensionPriorityOffset() {
        return 230;
    }

    protected int getImplicitStaticFeaturePriority() {
        return 60;
    }

    protected void addFeatureDescriptionProviders(JvmDeclaredType contextType, IFeaturesForTypeProvider featureProvider, XExpression implicitReceiver, XExpression implicitArgument, int priority, boolean preferStatics, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        DefaultJvmFeatureDescriptionProvider defaultProvider = this.newDefaultFeatureDescriptionProvider();
        defaultProvider.setContextType(contextType);
        defaultProvider.setPriority(priority);
        if (featureProvider != null) {
            defaultProvider.setFeaturesForTypeProvider(featureProvider);
        }
        defaultProvider.setImplicitReceiver(implicitReceiver);
        defaultProvider.setImplicitArgument(implicitArgument);
        defaultProvider.setPreferStatics(preferStatics);
        acceptor.accept((Object)defaultProvider);
        XFeatureCallSugarDescriptionProvider sugarProvider = this.newSugarDescriptionProvider();
        sugarProvider.setContextType(contextType);
        sugarProvider.setPriority(priority + this.getSugarPriorityOffset());
        if (featureProvider != null) {
            sugarProvider.setFeaturesForTypeProvider(featureProvider);
        }
        sugarProvider.setImplicitReceiver(implicitReceiver);
        sugarProvider.setImplicitArgument(implicitArgument);
        sugarProvider.setPreferStatics(preferStatics);
        acceptor.accept((Object)sugarProvider);
    }

    protected void addFeatureDescriptionProviders(Resource resource, JvmDeclaredType contextType, XExpression implicitReceiver, XExpression implicitArgument, int priority, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        this.addFeatureDescriptionProviders(contextType, null, implicitReceiver, implicitArgument, priority, false, acceptor);
        if (implicitArgument == null) {
            StaticImplicitMethodsFeatureForTypeProvider implicitStaticFeatures = this.newImplicitStaticFeaturesProvider();
            implicitStaticFeatures.setResourceContext(resource);
            implicitStaticFeatures.setExtensionProvider(true);
            this.addFeatureDescriptionProviders(contextType, implicitStaticFeatures, implicitReceiver, implicitArgument, priority + this.getImplicitStaticExtensionPriorityOffset(), true, acceptor);
        }
    }

    private StaticImplicitMethodsFeatureForTypeProvider newImplicitStaticFeaturesProvider() {
        return (StaticImplicitMethodsFeatureForTypeProvider)this.implicitStaticFeatures.get();
    }

    protected void addFeatureDescriptionProvidersForAssignment(Resource resource, JvmDeclaredType contextType, XExpression implicitReceiver, XExpression implicitArgument, int priority, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        this.addFeatureDescriptionProvidersForAssignment(contextType, null, implicitReceiver, implicitArgument, priority, false, acceptor);
    }

    protected void addFeatureDescriptionProvidersForAssignment(JvmDeclaredType contextType, IFeaturesForTypeProvider featureProvider, XExpression implicitReceiver, XExpression implicitArgument, int priority, boolean preferStatics, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        XAssignmentDescriptionProvider assignmentProvider = (XAssignmentDescriptionProvider)this.assignmentFeatureDescProvider.get();
        assignmentProvider.setContextType(contextType);
        if (featureProvider != null) {
            assignmentProvider.setFeaturesForTypeProvider(featureProvider);
        }
        assignmentProvider.setImplicitReceiver(implicitReceiver);
        assignmentProvider.setImplicitArgument(implicitArgument);
        assignmentProvider.setPriority(priority);
        assignmentProvider.setPreferStatics(preferStatics);
        acceptor.accept((Object)assignmentProvider);
        XAssignmentSugarDescriptionProvider sugarProvider = (XAssignmentSugarDescriptionProvider)this.assignmentSugarFeatureDescProvider.get();
        sugarProvider.setContextType(contextType);
        if (featureProvider != null) {
            sugarProvider.setFeaturesForTypeProvider(featureProvider);
        }
        sugarProvider.setImplicitReceiver(implicitReceiver);
        sugarProvider.setImplicitArgument(implicitArgument);
        sugarProvider.setPriority(this.getSugarPriorityOffset() + priority);
        sugarProvider.setPreferStatics(preferStatics);
        acceptor.accept((Object)sugarProvider);
    }

    private DefaultJvmFeatureDescriptionProvider newDefaultFeatureDescriptionProvider() {
        return (DefaultJvmFeatureDescriptionProvider)this.defaultFeatureDescProvider.get();
    }

    private XFeatureCallSugarDescriptionProvider newSugarDescriptionProvider() {
        return (XFeatureCallSugarDescriptionProvider)this.sugarFeatureDescProvider.get();
    }
}

