/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.hover;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.impl.FeatureCallToJavaMapping;
import org.eclipse.xtext.xbase.scoping.XbaseScopeProvider;
import org.eclipse.xtext.xbase.util.XbaseSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendHoverSerializer {
    private static final String STATICDELIMITER = "::";
    private static final String SEPERATOR = ", ";
    private static final String DELIMITER = ".";
    @Inject
    private FeatureCallToJavaMapping featureCallToJavaMapping;

    public String computeUnsugaredExpression(EObject object) {
        if (object instanceof XAbstractFeatureCall) {
            StringBuilder stringBuilder = new StringBuilder();
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)object;
            JvmIdentifiableElement feature = featureCall.getFeature();
            if (feature != null && !feature.eIsProxy()) {
                JvmOperation jvmOperation;
                if (featureCall instanceof XMemberFeatureCall && feature instanceof JvmOperation && (jvmOperation = (JvmOperation)feature).isStatic()) {
                    return stringBuilder.append(this.getStaticCallDesugaredVersion(featureCall, (JvmMember)jvmOperation)).toString();
                }
                if (featureCall.getImplicitReceiver() != null || featureCall.getImplicitFirstArgument() != null) {
                    if (feature instanceof JvmField && ((JvmField)feature).isStatic() || feature instanceof JvmOperation && ((JvmOperation)feature).isStatic()) {
                        return stringBuilder.append(this.getStaticCallDesugaredVersion(featureCall, (JvmMember)feature)).toString();
                    }
                    XExpression receiver = this.featureCallToJavaMapping.getActualReceiver(featureCall);
                    if (receiver instanceof XMemberFeatureCall) {
                        stringBuilder.append(XbaseScopeProvider.THIS).append(DELIMITER);
                        stringBuilder.append(((XMemberFeatureCall)receiver).getFeature().getSimpleName()).append(DELIMITER);
                    } else if (receiver instanceof XAbstractFeatureCall) {
                        JvmIdentifiableElement receiverFeature = ((XAbstractFeatureCall)receiver).getFeature();
                        if (receiverFeature.getSimpleName().equals(XbaseScopeProvider.IT.toString())) {
                            stringBuilder.append(XbaseScopeProvider.IT).append(DELIMITER);
                        }
                        if (receiverFeature == feature.eContainer()) {
                            stringBuilder.append(XbaseScopeProvider.THIS).append(DELIMITER);
                        }
                    }
                    stringBuilder.append(feature.getSimpleName());
                    if (feature instanceof JvmExecutable) {
                        stringBuilder.append(this.computeArguments(featureCall));
                    }
                    return stringBuilder.toString();
                }
            }
        }
        return "";
    }

    protected String getStaticCallDesugaredVersion(XAbstractFeatureCall featureCall, JvmMember jvmMember) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(jvmMember.getDeclaringType().getSimpleName());
        stringBuilder.append(STATICDELIMITER);
        stringBuilder.append(jvmMember.getSimpleName());
        stringBuilder.append(this.computeArguments(featureCall));
        return stringBuilder.toString();
    }

    public String computeArguments(XAbstractFeatureCall featureCall) {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (featureCall != null) {
            String doSwitch;
            XExpression implicitFirstArgument = null;
            List arguments = Lists.newArrayList();
            boolean needsSeperator = false;
            if (featureCall instanceof XMemberFeatureCall) {
                arguments = ((XMemberFeatureCall)featureCall).getMemberCallArguments();
                implicitFirstArgument = ((XMemberFeatureCall)featureCall).getMemberCallTarget();
                needsSeperator = implicitFirstArgument != null && arguments.size() > 0;
            } else {
                implicitFirstArgument = featureCall.getImplicitFirstArgument();
                arguments = this.featureCallToJavaMapping.getActualArguments(featureCall);
                if (arguments.size() > 0 && featureCall.getImplicitReceiver() == arguments.get(0)) {
                    implicitFirstArgument = (XExpression)arguments.get(0);
                }
                needsSeperator = implicitFirstArgument != null && arguments.size() > 1;
            }
            XtendHoverXbaseSwitch xbaseSwitch = new XtendHoverXbaseSwitch();
            if (implicitFirstArgument != null && (doSwitch = ((String)xbaseSwitch.doSwitch((EObject)implicitFirstArgument)).trim()) != null) {
                stringBuilder.append(doSwitch);
            }
            if (arguments.size() > 0) {
                XExpression last;
                XExpression first = (XExpression)arguments.get(0);
                if (needsSeperator) {
                    stringBuilder.append(SEPERATOR);
                }
                if (first == implicitFirstArgument && arguments.size() > 1) {
                    first = (XExpression)arguments.get(1);
                }
                if ((last = (XExpression)arguments.get(arguments.size() - 1)) != implicitFirstArgument) {
                    ICompositeNode startNode = NodeModelUtils.getNode((EObject)first);
                    ICompositeNode endNode = NodeModelUtils.getNode((EObject)last);
                    if (startNode != null && endNode != null) {
                        IParseResult parseResult;
                        int startOffset = startNode.getTotalOffset();
                        int endOffset = endNode.getTotalEndOffset();
                        XtextResource resource = (XtextResource)featureCall.eResource();
                        if (resource != null && (parseResult = resource.getParseResult()) != null) {
                            String model = parseResult.getRootNode().getText();
                            stringBuilder.append(model.substring(startOffset, endOffset).trim());
                        }
                    }
                }
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public Pair<String, String> computePreAndSuffix(EObject element) {
        IParseResult parseResult;
        XtextResource resource;
        ICompositeNode node = NodeModelUtils.getNode((EObject)element);
        if (node != null && (resource = (XtextResource)element.eResource()) != null && (parseResult = resource.getParseResult()) != null) {
            String model = parseResult.getRootNode().getText();
            return Tuples.create((Object)(String.valueOf(model.substring(0, node.getTotalOffset())) + "\n"), (Object)("\n" + model.substring(node.getTotalEndOffset())));
        }
        return Tuples.create((Object)"", (Object)"");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XtendHoverXbaseSwitch
    extends XbaseSwitch<String> {
        private XtendHoverXbaseSwitch() {
        }

        public String caseXAbstractFeatureCall(XAbstractFeatureCall object) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)object);
            if (node != null) {
                return node.getText();
            }
            return object.getFeature().getSimpleName();
        }

        public String caseXExpression(XExpression object) {
            ICompositeNode node;
            if (object != null && (node = NodeModelUtils.getNode((EObject)object)) != null) {
                return node.getText();
            }
            return "";
        }
    }
}

