/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typing;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.FeatureOverridesService;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.typing.XbaseTypeConformanceComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionConversion {
    @Inject
    private XbaseTypeConformanceComputer conformanceComputer;
    @Inject
    private TypeArgumentContextProvider contextProvider;
    @Inject
    private TypesFactory factory = TypesFactory.eINSTANCE;
    @Inject
    private TypeReferences typeRefs;
    @Inject
    private Primitives primitives;
    @Inject
    private FeatureOverridesService overridesService;

    public boolean isConformant(JvmTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        FuncDesc leftDesc = this.toFuncDesc(left);
        FuncDesc rightDesc = this.toFuncDesc(right);
        if (leftDesc == null || rightDesc == null) {
            return false;
        }
        if (ignoreGenerics) {
            return leftDesc.getArgumentSize() == rightDesc.getArgumentSize();
        }
        TypeArgumentContext leftCtx = this.contextProvider.getReceiverContext(left);
        TypeArgumentContext rightCtx = this.contextProvider.getReceiverContext(right);
        boolean result = this.isConformant(leftDesc, leftCtx, rightDesc, rightCtx);
        return result;
    }

    protected FuncDesc toFuncDesc(JvmTypeReference typeReference) {
        if (this.isFunction(typeReference)) {
            FunctionRefFuncDef result = new FunctionRefFuncDef();
            JvmParameterizedTypeReference parameterizedTypeRef = (JvmParameterizedTypeReference)typeReference;
            if (parameterizedTypeRef.getArguments().isEmpty()) {
                result.argumentSize = ((JvmTypeParameterDeclarator)parameterizedTypeRef.getType()).getTypeParameters().size() - 1;
            } else {
                result.arguments = (List)((JvmParameterizedTypeReference)typeReference).getArguments();
            }
            return result;
        }
        JvmOperation operation = this.findSingleMethod(typeReference);
        if (operation == null) {
            return null;
        }
        JvmOperationFuncDef result = new JvmOperationFuncDef();
        result.delegate = operation;
        return result;
    }

    protected boolean isConformant(FuncDesc left, TypeArgumentContext leftCtx, FuncDesc right, TypeArgumentContext rightCtx) {
        List<? extends JvmTypeReference> paramTypes = left.getParameterTypes();
        Iterator leftIter = paramTypes.iterator();
        List<? extends JvmTypeReference> paramTypes2 = right.getParameterTypes();
        Iterator rightIter = paramTypes2.iterator();
        while (leftIter.hasNext() && rightIter.hasNext()) {
            JvmTypeReference convertedRightParam;
            JvmTypeReference leftType = (JvmTypeReference)leftIter.next();
            JvmTypeReference rightType = (JvmTypeReference)rightIter.next();
            JvmTypeReference convertedLeftParam = leftCtx.resolve(leftType);
            if (convertedLeftParam instanceof JvmAnyTypeReference || this.conformanceComputer.isConformant(convertedLeftParam, convertedRightParam = rightCtx.resolve(rightType))) continue;
            return false;
        }
        if (leftIter.hasNext() || rightIter.hasNext()) {
            return false;
        }
        JvmTypeReference leftResult = leftCtx.resolve(left.getReturnType());
        JvmTypeReference rightResult = rightCtx.resolve(right.getReturnType());
        return this.conformanceComputer.isConformant(leftResult, rightResult);
    }

    public JvmOperation findSingleMethod(JvmTypeReference type) {
        if (this.primitives.isPrimitive(type)) {
            return null;
        }
        Iterable features = Iterables.filter((Iterable)this.overridesService.getAllJvmFeatures(type), JvmOperation.class);
        JvmOperation operation = null;
        for (JvmOperation op : features) {
            if (!this.isValidFunction(op)) continue;
            if (operation == null) {
                operation = op;
                continue;
            }
            return null;
        }
        return operation;
    }

    protected boolean isValidFunction(JvmOperation op) {
        if (op.getVisibility() == JvmVisibility.PUBLIC) {
            if (Object.class.getName().equals(op.getDeclaringType().getIdentifier())) {
                return false;
            }
            String name = op.getSimpleName();
            if (name.equals("toString") && op.getParameters().isEmpty()) {
                return false;
            }
            if (name.equals("equals") && op.getParameters().size() == 1) {
                return false;
            }
            return !name.equals("hashCode") || !op.getParameters().isEmpty();
        }
        return false;
    }

    public boolean isFunction(JvmTypeReference type) {
        if (type instanceof JvmAnyTypeReference) {
            return false;
        }
        if (type instanceof JvmMultiTypeReference) {
            for (JvmTypeReference reference : ((JvmMultiTypeReference)type).getReferences()) {
                if (this.isFunction(reference)) continue;
                return false;
            }
            return true;
        }
        return type != null && type.getType() != null && type.getType().getIdentifier().startsWith(Functions.class.getCanonicalName());
    }

    public JvmTypeReference getResolvedExpectedType(JvmTypeReference expectedType, JvmTypeReference actualType) {
        if (expectedType == null) {
            return actualType;
        }
        if (!(expectedType instanceof JvmParameterizedTypeReference)) {
            return actualType;
        }
        JvmGenericType expectedTypeDeclaration = (JvmGenericType)expectedType.getType();
        TypeArgumentContext context = this.contextProvider.getReceiverContext(actualType);
        JvmOperation from = this.findSingleMethod(actualType);
        JvmOperation to = this.findSingleMethod(expectedType);
        HashMap resolutions = Maps.newHashMap();
        EList list = expectedTypeDeclaration.getTypeParameters();
        JvmParameterizedTypeReference resultType = this.factory.createJvmParameterizedTypeReference();
        resultType.setType((JvmType)expectedTypeDeclaration);
        for (JvmTypeParameter jvmTypeParameter : list) {
            JvmParameterizedTypeReference reference = this.factory.createJvmParameterizedTypeReference();
            reference.setType((JvmType)jvmTypeParameter);
            resultType.getArguments().add((Object)reference);
            resolutions.put(jvmTypeParameter, new TypeArgumentContextProvider.ResolveInfo((JvmTypeReference)this.factory.createJvmWildcardTypeReference()));
            JvmTypeReference result = this.findMatch(jvmTypeParameter, to.getReturnType(), context.resolve(from.getReturnType()));
            if (result != null) {
                resolutions.put(jvmTypeParameter, new TypeArgumentContextProvider.ResolveInfo(result));
            }
            EList fromParams = from.getParameters();
            EList toParams = to.getParameters();
            int i = 0;
            while (i < fromParams.size()) {
                JvmTypeReference fromParamType;
                JvmTypeReference toParamType = ((JvmFormalParameter)toParams.get(i)).getParameterType();
                result = this.findMatch(jvmTypeParameter, toParamType, context.resolve(fromParamType = ((JvmFormalParameter)fromParams.get(i)).getParameterType()));
                if (result != null) {
                    resolutions.put(jvmTypeParameter, new TypeArgumentContextProvider.ResolveInfo(result));
                }
                ++i;
            }
        }
        TypeArgumentContext typeArgContext = this.contextProvider.get((Map)resolutions);
        return typeArgContext.resolve((JvmTypeReference)resultType);
    }

    public JvmTypeReference getReturnType(JvmTypeReference functionType) {
        JvmOperation operation = this.findSingleMethod(functionType);
        if (operation == null) {
            return null;
        }
        TypeArgumentContext context = this.contextProvider.getReceiverContext(functionType);
        JvmTypeReference result = context.getUpperBound(operation.getReturnType(), (Notifier)operation);
        return result;
    }

    public JvmTypeReference findMatch(JvmTypeParameter jvmTypeParameter, JvmTypeReference declaration, JvmTypeReference information) {
        if (this.isTypeParamReference(jvmTypeParameter, declaration)) {
            return information;
        }
        if (declaration instanceof JvmParameterizedTypeReference && information instanceof JvmParameterizedTypeReference) {
            JvmParameterizedTypeReference declaration2 = (JvmParameterizedTypeReference)declaration;
            JvmParameterizedTypeReference information2 = (JvmParameterizedTypeReference)information;
            EList declArgs = declaration2.getArguments();
            EList infoArgs = information2.getArguments();
            int i = 0;
            while (i < declArgs.size() && i < infoArgs.size()) {
                JvmTypeReference match = this.findMatch(jvmTypeParameter, (JvmTypeReference)declArgs.get(i), (JvmTypeReference)infoArgs.get(i));
                if (match != null) {
                    return match;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean isTypeParamReference(JvmTypeParameter jvmTypeParameter, JvmTypeReference declaration) {
        if (declaration.getType() == jvmTypeParameter) {
            return true;
        }
        if (declaration instanceof JvmWildcardTypeReference) {
            JvmWildcardTypeReference wc = (JvmWildcardTypeReference)declaration;
            EList list = wc.getConstraints();
            for (JvmTypeConstraint constraint : list) {
                if (constraint.getTypeReference().getType() != jvmTypeParameter) continue;
                return true;
            }
        }
        return false;
    }

    public JvmParameterizedTypeReference createRawFunctionTypeRef(EObject context, int parameterCount) {
        JvmParameterizedTypeReference ref = this.factory.createJvmParameterizedTypeReference();
        Class<?> loadFunctionClass = this.loadFunctionClass("Function" + (parameterCount > 6 ? 6 : parameterCount));
        JvmGenericType declaredType = (JvmGenericType)this.typeRefs.findDeclaredType(loadFunctionClass, context);
        ref.setType((JvmType)declaredType);
        return ref;
    }

    public JvmParameterizedTypeReference createFunctionTypeRef(EObject context, List<JvmTypeReference> parameterTypes, JvmTypeReference returnType) {
        JvmParameterizedTypeReference result = this.createRawFunctionTypeRef(context, parameterTypes.size());
        JvmGenericType functionType = (JvmGenericType)result.getType();
        if (functionType == null) {
            return result;
        }
        int i = 0;
        while (i < parameterTypes.size()) {
            JvmTypeReference parameterType = parameterTypes.get(i);
            if (parameterType == null) {
                JvmParameterizedTypeReference reference = this.factory.createJvmParameterizedTypeReference();
                JvmTypeParameter typeParameter = (JvmTypeParameter)functionType.getTypeParameters().get(i);
                reference.setType((JvmType)typeParameter);
                result.getArguments().add((Object)reference);
            } else {
                parameterType = this.primitives.asWrapperTypeIfPrimitive(parameterType);
                result.getArguments().add((Object)((JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)parameterType)));
            }
            ++i;
        }
        if (returnType != null) {
            if ((returnType = this.primitives.asWrapperTypeIfPrimitive(returnType)) != null && returnType.getType() instanceof JvmVoid && !returnType.getType().eIsProxy()) {
                returnType = this.typeRefs.getTypeForName(Void.class, context, new JvmTypeReference[0]);
            }
            result.getArguments().add((Object)((JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)returnType)));
        } else {
            JvmParameterizedTypeReference reference = this.factory.createJvmParameterizedTypeReference();
            JvmTypeParameter typeParameter = (JvmTypeParameter)Iterables.getLast((Iterable)functionType.getTypeParameters());
            reference.setType((JvmType)typeParameter);
            result.getArguments().add((Object)reference);
        }
        return result;
    }

    protected Class<?> loadFunctionClass(String simpleFunctionName) {
        try {
            return Functions.class.getClassLoader().loadClass(String.valueOf(Functions.class.getCanonicalName()) + "$" + simpleFunctionName);
        }
        catch (ClassNotFoundException e) {
            throw new WrappedException((Exception)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface FuncDesc {
        public JvmTypeReference getReturnType();

        public List<? extends JvmTypeReference> getParameterTypes();

        public int getArgumentSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionRefFuncDef
    implements FuncDesc {
        private List<? extends JvmTypeReference> arguments;
        public int argumentSize = -1;

        private FunctionRefFuncDef() {
        }

        @Override
        public JvmTypeReference getReturnType() {
            return this.arguments.get(this.arguments.size() - 1);
        }

        @Override
        public List<? extends JvmTypeReference> getParameterTypes() {
            if (this.arguments == null || this.arguments.size() <= 1) {
                return Collections.emptyList();
            }
            return this.arguments.subList(0, this.arguments.size() - 1);
        }

        @Override
        public int getArgumentSize() {
            if (this.argumentSize != -1) {
                return this.argumentSize;
            }
            return this.getParameterTypes().size();
        }

        public String toString() {
            if (this.argumentSize != -1) {
                return "FunctionRef: [" + this.argumentSize + "]";
            }
            return "FunctionRef: " + this.arguments;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JvmOperationFuncDef
    implements FuncDesc {
        private JvmOperation delegate;

        private JvmOperationFuncDef() {
        }

        @Override
        public JvmTypeReference getReturnType() {
            return this.delegate.getReturnType();
        }

        public List<JvmTypeReference> getParameterTypes() {
            return Lists.transform((List)this.delegate.getParameters(), (Function)new Function<JvmFormalParameter, JvmTypeReference>(){

                public JvmTypeReference apply(JvmFormalParameter from) {
                    return from.getParameterType();
                }
            });
        }

        @Override
        public int getArgumentSize() {
            return this.delegate.getParameters().size();
        }

        public String toString() {
            return "OperationRef: " + this.delegate.getIdentifier();
        }
    }
}

