/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.VisibilityService;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.featurecalls.DefaultFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureSignatureProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJvmFeatureDescriptionProvider
implements IJvmFeatureDescriptionProvider,
IFeaturesForTypeProvider {
    @Inject
    protected VisibilityService visibilityService;
    @Inject
    protected IFeaturesForTypeProvider featuresForTypeProvider = new DefaultFeaturesForTypeProvider();
    @Inject
    protected JvmFeatureSignatureProvider signatureProvider = new JvmFeatureSignatureProvider();
    protected JvmDeclaredType contextType;
    protected XExpression implicitReceiver;

    public void setVisibilityService(VisibilityService visibilityService) {
        this.visibilityService = visibilityService;
    }

    public void setFeaturesForTypeProvider(IFeaturesForTypeProvider featuresForTypeProvider) {
        this.featuresForTypeProvider = featuresForTypeProvider;
    }

    @Override
    public Iterable<? extends JvmFeature> getFeaturesForType(JvmTypeReference declType) {
        return this.featuresForTypeProvider.getFeaturesForType(declType);
    }

    public void setContextType(JvmDeclaredType contextType) {
        this.contextType = contextType;
    }

    public void setImplicitReceiver(XExpression implicitReceiver) {
        this.implicitReceiver = implicitReceiver;
    }

    protected JvmFeatureDescription createJvmFeatureDescription(QualifiedName name, JvmFeature jvmFeature, TypeArgumentContext ctx, String shadowingString, boolean isValid) {
        return new JvmFeatureDescription(name, jvmFeature, ctx, shadowingString, isValid, this.implicitReceiver, this.getNumberOfIrrelevantArguments());
    }

    protected JvmFeatureDescription createJvmFeatureDescription(QualifiedName name, JvmFeature jvmFeature, TypeArgumentContext ctx, Provider<String> shadowingStringProvider, boolean isValid) {
        return new JvmFeatureDescription(name, jvmFeature, ctx, shadowingStringProvider, isValid, this.implicitReceiver, this.getNumberOfIrrelevantArguments());
    }

    private int getNumberOfIrrelevantArguments() {
        if (this.isExtensionProvider()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isExtensionProvider() {
        return this.featuresForTypeProvider != null ? this.featuresForTypeProvider.isExtensionProvider() : false;
    }

    protected JvmFeatureDescription createJvmFeatureDescription(JvmFeature jvmFeature, TypeArgumentContext ctx, Provider<String> shadowingStringProvider, boolean isValid) {
        return this.createJvmFeatureDescription(QualifiedName.create((String[])new String[]{jvmFeature.getSimpleName()}), jvmFeature, ctx, shadowingStringProvider, isValid);
    }

    @Override
    public void addFeatureDescriptions(JvmFeature feature, TypeArgumentContext context, IAcceptor<JvmFeatureDescription> acceptor) {
        Provider<String> signatureProvider = this.getSignature(feature, context);
        acceptor.accept((Object)this.createJvmFeatureDescription(feature, context, signatureProvider, this.isValid(feature)));
    }

    protected Provider<String> getSignature(final JvmFeature feature, final TypeArgumentContext context) {
        return new Provider<String>(){

            public String get() {
                return DefaultJvmFeatureDescriptionProvider.this.signatureProvider.getSignature(feature, context, DefaultJvmFeatureDescriptionProvider.this.getNumberOfIrrelevantArguments());
            }
        };
    }

    protected boolean isValid(JvmFeature feature) {
        JvmFeature jvmMember = feature;
        return this.visibilityService.isVisible((JvmMember)jvmMember, this.contextType);
    }

    @Override
    public String getText() {
        return this.getClass().getSimpleName();
    }
}

