/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.interpreter.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.impl.ClassFinder;
import org.eclipse.xtext.common.types.util.JavaReflectAccess;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XIntLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.impl.FeatureCallToJavaMapping;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.IEvaluationResult;
import org.eclipse.xtext.xbase.interpreter.IExpressionInterpreter;
import org.eclipse.xtext.xbase.interpreter.impl.ClosureInvocationHandler;
import org.eclipse.xtext.xbase.interpreter.impl.DefaultEvaluationResult;
import org.eclipse.xtext.xbase.interpreter.impl.DelegatingInvocationHandler;
import org.eclipse.xtext.xbase.interpreter.impl.EvaluationException;
import org.eclipse.xtext.xbase.interpreter.impl.FinallyDidNotCompleteException;
import org.eclipse.xtext.xbase.interpreter.impl.InterpreterCanceledException;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.scoping.XbaseScopeProvider;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.util.XExpressionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseInterpreter
implements IExpressionInterpreter {
    @Inject
    private IdentifiableSimpleNameProvider featureNameProvider;
    @Inject
    private Provider<IEvaluationContext> contextProvider;
    @Inject
    private JavaReflectAccess javaReflectAccess;
    @Inject
    private FeatureCallToJavaMapping callToJavaMapping;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private TypeReferences typeRefs;
    @Inject
    private Primitives primitives;
    @Inject
    private XExpressionHelper expressionHelper;
    private ClassFinder classFinder;
    private ClassLoader classLoader;
    private PolymorphicDispatcher<Object> evaluateDispatcher = this.createEvaluateDispatcher();
    private PolymorphicDispatcher<Object> assignmentDispatcher = this.createAssignmentDispatcher();
    private PolymorphicDispatcher<Object> featureCallDispatcher = this.createFeatureCallDispatcher();

    public XbaseInterpreter() {
    }

    public XbaseInterpreter(Provider<IEvaluationContext> contextProvider, JavaReflectAccess javaReflectAccess, ClassLoader loader) {
        this.contextProvider = contextProvider;
        this.javaReflectAccess = javaReflectAccess;
        this.setClassLoader(loader);
    }

    public void setFeatureNameProvider(IdentifiableSimpleNameProvider featureNameProvider) {
        this.featureNameProvider = featureNameProvider;
    }

    @Inject
    public void setClassLoader(ClassLoader classLoader) {
        this.classFinder = new ClassFinder(classLoader);
        this.classLoader = classLoader;
        this.javaReflectAccess.setClassLoader(classLoader);
    }

    protected Class<?> getClass(Class<?> class1) {
        try {
            return this.classLoader.loadClass(class1.getName());
        }
        catch (ClassNotFoundException e) {
            throw new EvaluationException(e);
        }
    }

    protected PolymorphicDispatcher<Object> createEvaluateDispatcher() {
        return PolymorphicDispatcher.createForSingleTarget((Predicate)new PrefixMethodFilter("_evaluate", 3, 3), (Object)this);
    }

    protected PolymorphicDispatcher<Object> createAssignmentDispatcher() {
        return PolymorphicDispatcher.createForSingleTarget((Predicate)new PrefixMethodFilter("_assignValue", 5, 5), (Object)this);
    }

    protected PolymorphicDispatcher<Object> createFeatureCallDispatcher() {
        return PolymorphicDispatcher.createForSingleTarget((Predicate)new PrefixMethodFilter("_featureCall", 5, 5), (Object)this);
    }

    @Override
    public IEvaluationResult evaluate(XExpression expression) {
        return this.evaluate(expression, this.createContext(), CancelIndicator.NullImpl);
    }

    protected IEvaluationContext createContext() {
        return (IEvaluationContext)this.contextProvider.get();
    }

    @Override
    public IEvaluationResult evaluate(XExpression expression, IEvaluationContext context, CancelIndicator indicator) {
        try {
            Object result = this.internalEvaluate(expression, context, indicator != null ? indicator : CancelIndicator.NullImpl);
            return new DefaultEvaluationResult(result, null);
        }
        catch (ReturnValue e) {
            return new DefaultEvaluationResult(e.returnValue, null);
        }
        catch (EvaluationException e) {
            return new DefaultEvaluationResult(null, e.getCause());
        }
        catch (InterpreterCanceledException e) {
            return null;
        }
    }

    protected Object internalEvaluate(XExpression expression, IEvaluationContext context, CancelIndicator indicator) throws EvaluationException {
        if (indicator.isCanceled()) {
            throw new InterpreterCanceledException();
        }
        Object result = this.evaluateDispatcher.invoke(new Object[]{expression, context, indicator});
        JvmTypeReference expectedType = this.typeProvider.getExpectedType(expression);
        result = this.wrapArray(result, expectedType);
        return result;
    }

    protected Object _evaluateNullLiteral(XNullLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        return null;
    }

    protected Object _evaluateReturnExpression(XReturnExpression returnExpr, IEvaluationContext context, CancelIndicator indicator) {
        Object returnValue = this.internalEvaluate(returnExpr.getExpression(), context, indicator);
        throw new ReturnValue(returnValue);
    }

    protected Object _evaluateStringLiteral(XStringLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        return literal.getValue();
    }

    protected Object _evaluateIntLiteral(XIntLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        return literal.getValue();
    }

    protected Object _evaluateBooleanLiteral(XBooleanLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        return literal.isIsTrue();
    }

    protected Object _evaluateTypeLiteral(XTypeLiteral literal, IEvaluationContext context, CancelIndicator indicator) {
        if (literal.getType() == null || literal.getType().eIsProxy()) {
            List nodesForFeature = NodeModelUtils.findNodesForFeature((EObject)literal, (EStructuralFeature)XbasePackage.Literals.XTYPE_LITERAL__TYPE);
            if (nodesForFeature.isEmpty()) {
                throw new EvaluationException(new ClassNotFoundException());
            }
            throw new EvaluationException(new ClassNotFoundException(((INode)nodesForFeature.get(0)).getText()));
        }
        try {
            Class result = this.classFinder.forName(literal.getType().getQualifiedName());
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            throw new EvaluationException(cnfe);
        }
    }

    protected Object _evaluateClosure(XClosure closure, IEvaluationContext context, CancelIndicator indicator) {
        Class<?> functionIntf = null;
        switch (closure.getFormalParameters().size()) {
            case 0: {
                functionIntf = this.getClass(Functions.Function0.class);
                break;
            }
            case 1: {
                functionIntf = this.getClass(Functions.Function1.class);
                break;
            }
            case 2: {
                functionIntf = this.getClass(Functions.Function2.class);
                break;
            }
            case 3: {
                functionIntf = this.getClass(Functions.Function3.class);
                break;
            }
            case 4: {
                functionIntf = this.getClass(Functions.Function4.class);
                break;
            }
            case 5: {
                functionIntf = this.getClass(Functions.Function5.class);
                break;
            }
            case 6: {
                functionIntf = this.getClass(Functions.Function6.class);
                break;
            }
            default: {
                throw new IllegalStateException("Closures with more then 6 parameters are not supported.");
            }
        }
        ClosureInvocationHandler invocationHandler = new ClosureInvocationHandler(closure, context, this, indicator);
        Object proxy = Proxy.newProxyInstance(this.classLoader, new Class[]{functionIntf}, (InvocationHandler)invocationHandler);
        return proxy;
    }

    protected Object _evaluateBlockExpression(XBlockExpression literal, IEvaluationContext context, CancelIndicator indicator) {
        EList<XExpression> expressions = literal.getExpressions();
        Object result = null;
        IEvaluationContext forkedContext = context.fork();
        int i = 0;
        while (i < expressions.size()) {
            result = this.internalEvaluate((XExpression)expressions.get(i), forkedContext, indicator);
            ++i;
        }
        return result;
    }

    protected Object _evaluateIfExpression(XIfExpression ifExpression, IEvaluationContext context, CancelIndicator indicator) {
        Object conditionResult = this.internalEvaluate(ifExpression.getIf(), context, indicator);
        if (Boolean.TRUE.equals(conditionResult)) {
            return this.internalEvaluate(ifExpression.getThen(), context, indicator);
        }
        if (ifExpression.getElse() == null) {
            return null;
        }
        return this.internalEvaluate(ifExpression.getElse(), context, indicator);
    }

    protected Object _evaluateSwitchExpression(XSwitchExpression switchExpression, IEvaluationContext context, CancelIndicator indicator) {
        IEvaluationContext forkedContext = context.fork();
        Object conditionResult = this.internalEvaluate(switchExpression.getSwitch(), forkedContext, indicator);
        String simpleName = this.featureNameProvider.getSimpleName(switchExpression);
        if (simpleName != null) {
            forkedContext.newValue(QualifiedName.create((String[])new String[]{simpleName}), conditionResult);
        }
        for (XCasePart casePart : switchExpression.getCases()) {
            Class expectedType = null;
            if (casePart.getTypeGuard() != null) {
                String typeName = casePart.getTypeGuard().getType().getQualifiedName();
                try {
                    expectedType = this.classFinder.forName(typeName);
                }
                catch (ClassNotFoundException e) {
                    throw new EvaluationException(new NoClassDefFoundError(typeName));
                }
            }
            if (expectedType != null && conditionResult == null) {
                throw new IllegalStateException("Switch without expression or implicit 'this' may not use type guards");
            }
            if (expectedType != null && !expectedType.isInstance(conditionResult)) continue;
            if (casePart.getCase() != null) {
                Object casePartResult = this.internalEvaluate(casePart.getCase(), forkedContext, indicator);
                if (!Boolean.TRUE.equals(casePartResult) && !this.eq(conditionResult, casePartResult)) continue;
                return this.internalEvaluate(casePart.getThen(), forkedContext, indicator);
            }
            return this.internalEvaluate(casePart.getThen(), forkedContext, indicator);
        }
        if (switchExpression.getDefault() != null) {
            Object defaultResult = this.internalEvaluate(switchExpression.getDefault(), forkedContext, indicator);
            return defaultResult;
        }
        return null;
    }

    protected Object _evaluateCastedExpression(XCastedExpression castedExpression, IEvaluationContext context, CancelIndicator indicator) {
        Object result = this.internalEvaluate(castedExpression.getTarget(), context, indicator);
        result = this.wrapArray(result, castedExpression.getType());
        result = this.coerceArgumentType(result, castedExpression.getType());
        String typeName = castedExpression.getType().getType().getQualifiedName();
        Class expectedType = null;
        try {
            expectedType = this.classFinder.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new EvaluationException(new NoClassDefFoundError(typeName));
        }
        try {
            expectedType.cast(result);
        }
        catch (ClassCastException e) {
            throw new EvaluationException(e);
        }
        return result;
    }

    protected Object _evaluateThrowExpression(XThrowExpression throwExpression, IEvaluationContext context, CancelIndicator indicator) {
        Object thrown = this.internalEvaluate(throwExpression.getExpression(), context, indicator);
        if (thrown == null) {
            return this.throwNullPointerException(throwExpression, "throwable expression evaluated to 'null'");
        }
        if (!(thrown instanceof Throwable)) {
            return this.throwClassCastException(throwExpression.getExpression(), thrown, Throwable.class);
        }
        throw new EvaluationException((Throwable)thrown);
    }

    /*
     * Unable to fully structure code
     */
    protected Object _evaluateTryCatchFinallyExpression(XTryCatchFinallyExpression tryCatchFinally, IEvaluationContext context, CancelIndicator indicator) {
        block9: {
            result = null;
            try {
                result = this.internalEvaluate(tryCatchFinally.getExpression(), context, indicator);
                break block9;
            }
            catch (EvaluationException evaluationException) {
                cause = evaluationException.getCause();
                ** for (catchClause : tryCatchFinally.getCatchClauses())
            }
lbl-1000:
            // 1 sources

            {
                exception = catchClause.getDeclaredParam();
                exceptionTypeName = exception.getParameterType().getType().getQualifiedName();
                try {
                    exceptionType = this.classFinder.forName(exceptionTypeName);
                    if (!exceptionType.isInstance(cause)) {
                        continue;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new EvaluationException(new NoClassDefFoundError(exceptionTypeName));
                }
                forked = context.fork();
                forked.newValue(QualifiedName.create((String[])new String[]{exception.getName()}), cause);
                result = this.internalEvaluate(catchClause.getExpression(), forked, indicator);
                break;
            }
        }
        if (tryCatchFinally.getFinallyExpression() != null) {
            try {
                this.internalEvaluate(tryCatchFinally.getFinallyExpression(), context, indicator);
            }
            catch (EvaluationException e) {
                throw new EvaluationException(new FinallyDidNotCompleteException(e));
            }
        }
        return result;
    }

    protected boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    protected Object throwNullPointerException(XExpression expression, String message) {
        throw new EvaluationException(new NullPointerException(message));
    }

    protected Object throwClassCastException(XExpression expression, Object result, Class<?> expectedType) {
        throw new EvaluationException(new ClassCastException("Expected: " + expectedType.getCanonicalName() + " but got: " + result.getClass().getCanonicalName()));
    }

    protected Object wrapArray(Object result, JvmTypeReference jvmTypeReference) {
        if (this.typeRefs.is(jvmTypeReference, List.class) || this.typeRefs.is(jvmTypeReference, Iterable.class) || this.typeRefs.is(jvmTypeReference, Collection.class)) {
            return Conversions.doWrapArray((Object)result);
        }
        return result;
    }

    protected Object _evaluateForLoopExpression(XForLoopExpression forLoop, IEvaluationContext context, CancelIndicator indicator) {
        Object iterableOrIterator = this.internalEvaluate(forLoop.getForExpression(), context, indicator);
        if (iterableOrIterator == null) {
            return this.throwNullPointerException(forLoop.getForExpression(), "iterable evaluated to 'null'");
        }
        Iterator iter = null;
        if (iterableOrIterator instanceof Iterable) {
            iter = ((Iterable)iterableOrIterator).iterator();
        } else if (iterableOrIterator.getClass().isArray()) {
            iter = ((Iterable)Conversions.doWrapArray((Object)iterableOrIterator)).iterator();
        } else {
            return this.throwClassCastException(forLoop.getForExpression(), iterableOrIterator, Iterable.class);
        }
        IEvaluationContext forkedContext = context.fork();
        QualifiedName paramName = QualifiedName.create((String[])new String[]{forLoop.getDeclaredParam().getName()});
        forkedContext.newValue(paramName, null);
        while (iter.hasNext()) {
            Object next = iter.next();
            forkedContext.assignValue(paramName, next);
            this.internalEvaluate(forLoop.getEachExpression(), forkedContext, indicator);
        }
        return null;
    }

    protected Object _evaluateWhileExpression(XWhileExpression whileLoop, IEvaluationContext context, CancelIndicator indicator) {
        Object condition = this.internalEvaluate(whileLoop.getPredicate(), context, indicator);
        while (Boolean.TRUE.equals(condition)) {
            this.internalEvaluate(whileLoop.getBody(), context, indicator);
            condition = this.internalEvaluate(whileLoop.getPredicate(), context, indicator);
        }
        return null;
    }

    protected IEvaluationResult _evaluateDoWhileExpression(XDoWhileExpression doWhileLoop, IEvaluationContext context, CancelIndicator indicator) {
        Object condition = null;
        do {
            this.internalEvaluate(doWhileLoop.getBody(), context, indicator);
        } while (Boolean.TRUE.equals(condition = this.internalEvaluate(doWhileLoop.getPredicate(), context, indicator)));
        return null;
    }

    protected Object _evaluateConstructorCall(XConstructorCall constructorCall, IEvaluationContext context, CancelIndicator indicator) {
        JvmConstructor jvmConstructor = constructorCall.getConstructor();
        List<Object> arguments = this.evaluateArgumentExpressions((JvmExecutable)jvmConstructor, (List<XExpression>)constructorCall.getArguments(), context, indicator);
        Constructor constructor = this.javaReflectAccess.getConstructor(jvmConstructor);
        try {
            if (constructor == null) {
                throw new NoSuchMethodException("Could not find constructor " + jvmConstructor.getIdentifier());
            }
            constructor.setAccessible(true);
            Object result = constructor.newInstance(arguments.toArray(new Object[arguments.size()]));
            return result;
        }
        catch (InvocationTargetException targetException) {
            throw new EvaluationException(targetException.getTargetException());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not invoke constructor: " + jvmConstructor.getIdentifier(), e);
        }
    }

    protected Object _evaluateMemberFeatureCall(XMemberFeatureCall featureCall, IEvaluationContext context, CancelIndicator indicator) {
        Object receiverObj;
        if (featureCall.isSpreading()) {
            Object memberCallTarget = this.internalEvaluate(featureCall.getMemberCallTarget(), context, indicator);
            if (memberCallTarget == null) {
                return this.throwNullPointerException(featureCall.getMemberCallTarget(), "iterable evaluated to 'null'");
            }
            if (memberCallTarget instanceof Iterable) {
                Iterable iterable = (Iterable)memberCallTarget;
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class Spread
                implements Function<Object, Object> {
                    private final /* synthetic */ XMemberFeatureCall val$featureCall;
                    private final /* synthetic */ IEvaluationContext val$context;
                    private final /* synthetic */ CancelIndicator val$indicator;

                    Spread(XMemberFeatureCall xMemberFeatureCall, IEvaluationContext iEvaluationContext, CancelIndicator cancelIndicator) {
                        this.val$featureCall = xMemberFeatureCall;
                        this.val$context = iEvaluationContext;
                        this.val$indicator = cancelIndicator;
                    }

                    public Object apply(Object from) {
                        Object result = XbaseInterpreter.this.internalFeatureCallDispatch(this.val$featureCall, from, this.val$context, this.val$indicator);
                        return result;
                    }
                }
                return Lists.newArrayList((Iterable)Iterables.transform((Iterable)iterable, (Function)new Spread(featureCall, context, indicator)));
            }
            return this.throwClassCastException(featureCall.getMemberCallTarget(), memberCallTarget, Iterable.class);
        }
        XExpression receiver = this.callToJavaMapping.getActualReceiver(featureCall, featureCall.getFeature(), featureCall.getImplicitReceiver());
        Object object = receiverObj = receiver == null ? null : this.internalEvaluate(receiver, context, indicator);
        if (featureCall.isNullSafe() && receiverObj == null) {
            return this.getDefaultObjectValue(this.typeProvider.getType(featureCall));
        }
        return this.internalFeatureCallDispatch(featureCall, receiverObj, context, indicator);
    }

    protected Object getDefaultObjectValue(JvmTypeReference type) {
        if (!this.primitives.isPrimitive(type)) {
            return null;
        }
        JvmPrimitiveType primitive = (JvmPrimitiveType)type.getType();
        switch (this.primitives.primitiveKind(primitive)) {
            case Byte: {
                return (byte)0;
            }
            case Short: {
                return (short)0;
            }
            case Char: {
                return Character.valueOf('\u0000');
            }
            case Int: {
                return 0;
            }
            case Long: {
                return 0L;
            }
            case Float: {
                return Float.valueOf(0.0f);
            }
            case Double: {
                return Double.valueOf("0.");
            }
            case Boolean: {
                return Boolean.FALSE;
            }
            case Void: {
                return null;
            }
        }
        throw new IllegalArgumentException("Not a primitive : " + primitive);
    }

    protected Object _evaluateInstanceOf(XInstanceOfExpression instanceOf, IEvaluationContext context, CancelIndicator indicator) {
        Object instance = this.internalEvaluate(instanceOf.getExpression(), context, indicator);
        if (instance == null) {
            return Boolean.FALSE;
        }
        Class expectedType = null;
        String className = instanceOf.getType().getQualifiedName();
        try {
            expectedType = this.classFinder.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new EvaluationException(new NoClassDefFoundError(className));
        }
        return expectedType.isInstance(instance);
    }

    protected Object _evaluateVariableDeclaration(XVariableDeclaration variableDecl, IEvaluationContext context, CancelIndicator indicator) {
        Object initialValue = null;
        if (variableDecl.getRight() != null) {
            initialValue = this.internalEvaluate(variableDecl.getRight(), context, indicator);
        } else if (this.primitives.isPrimitive(variableDecl.getType())) {
            switch (this.primitives.primitiveKind((JvmPrimitiveType)variableDecl.getType().getType())) {
                case Boolean: {
                    initialValue = Boolean.FALSE;
                    break;
                }
                case Char: {
                    initialValue = Character.valueOf('\u0000');
                    break;
                }
                case Double: {
                    initialValue = 0.0;
                    break;
                }
                case Byte: {
                    initialValue = (byte)0;
                    break;
                }
                case Float: {
                    initialValue = Float.valueOf(0.0f);
                    break;
                }
                case Int: {
                    initialValue = 0;
                    break;
                }
                case Long: {
                    initialValue = 0L;
                    break;
                }
                case Short: {
                    initialValue = (short)0;
                    break;
                }
                case Void: {
                    throw new IllegalStateException("Void is not a valid variable type.");
                }
            }
        }
        context.newValue(QualifiedName.create((String[])new String[]{variableDecl.getName()}), initialValue);
        return null;
    }

    protected Object _evaluateAbstractFeatureCall(XAbstractFeatureCall featureCall, IEvaluationContext context, CancelIndicator indicator) {
        if (this.expressionHelper.isShortCircuiteBooleanOperation(featureCall)) {
            XExpression leftOperand = ((XBinaryOperation)featureCall).getLeftOperand();
            Object result = this.internalEvaluate(leftOperand, context, indicator);
            boolean isAND = featureCall.getConcreteSyntaxFeatureName().equals(this.expressionHelper.getAndOperator());
            if (isAND && !((Boolean)result).booleanValue()) {
                return false;
            }
            if (!isAND && ((Boolean)result).booleanValue()) {
                return true;
            }
            JvmOperation operation = (JvmOperation)featureCall.getFeature();
            XExpression receiver = this.callToJavaMapping.getActualReceiver(featureCall, featureCall.getFeature(), featureCall.getImplicitReceiver());
            List<XExpression> operationArguments = this.callToJavaMapping.getActualArguments(featureCall, featureCall.getFeature(), featureCall.getImplicitReceiver());
            ArrayList argumentValues = Lists.newArrayList();
            for (XExpression expr : operationArguments) {
                if (expr == leftOperand) {
                    argumentValues.add(result);
                    continue;
                }
                argumentValues.add(this.internalEvaluate(expr, context, indicator));
            }
            return this.invokeOperation(operation, receiver, argumentValues);
        }
        XExpression receiver = this.callToJavaMapping.getActualReceiver(featureCall, featureCall.getFeature(), featureCall.getImplicitReceiver());
        Object receiverObj = receiver == null ? null : this.internalEvaluate(receiver, context, indicator);
        return this.internalFeatureCallDispatch(featureCall, receiverObj, context, indicator);
    }

    protected Object internalFeatureCallDispatch(XAbstractFeatureCall featureCall, Object receiverObj, IEvaluationContext context, CancelIndicator indicator) {
        return this.featureCallDispatcher.invoke(new Object[]{featureCall.getFeature(), featureCall, receiverObj, context, indicator});
    }

    protected Object _featureCallJvmIdentifyableElement(JvmIdentifiableElement identifiable, XFeatureCall featureCall, Object receiver, IEvaluationContext context, CancelIndicator indicator) {
        if (receiver != null) {
            throw new IllegalStateException("feature was simple feature call but got receiver instead of null. Receiver: " + receiver);
        }
        String localVarName = this.featureNameProvider.getSimpleName(identifiable);
        Object value = context.getValue(QualifiedName.create((String[])new String[]{localVarName}));
        return value;
    }

    protected Object _featureCallField(JvmField jvmField, XAbstractFeatureCall featureCall, Object receiver, IEvaluationContext context, CancelIndicator indicator) {
        return this.featureCallField(jvmField, receiver);
    }

    protected Object featureCallField(JvmField jvmField, Object receiver) {
        Field field = this.javaReflectAccess.getField(jvmField);
        try {
            if (field == null) {
                throw new NoSuchFieldException("Could not find field " + jvmField.getIdentifier());
            }
            field.setAccessible(true);
            Object result = field.get(receiver);
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access field: " + jvmField.getIdentifier() + " on instance: " + receiver, e);
        }
    }

    protected Object _featureCallOperation(JvmOperation operation, XAbstractFeatureCall featureCall, Object receiver, IEvaluationContext context, CancelIndicator indicator) {
        List<XExpression> operationArguments = this.callToJavaMapping.getActualArguments(featureCall, featureCall.getFeature(), featureCall.getImplicitReceiver());
        List<Object> argumentValues = this.evaluateArgumentExpressions((JvmExecutable)operation, operationArguments, context, indicator);
        return this.invokeOperation(operation, receiver, argumentValues);
    }

    protected Object invokeOperation(JvmOperation operation, Object receiver, List<Object> argumentValues) {
        Method method = this.javaReflectAccess.getMethod(operation);
        try {
            if (method == null) {
                throw new NoSuchMethodException("Could not find method " + operation.getIdentifier());
            }
            method.setAccessible(true);
            if (!Modifier.isStatic(method.getModifiers()) && receiver == null) {
                throw new EvaluationException(new NullPointerException("cannot invoke method " + method + " on null"));
            }
            if (Modifier.isStatic(method.getModifiers()) && receiver != null) {
                throw new IllegalArgumentException("A static method can't be invoked on a receiver.");
            }
            Object result = method.invoke(receiver, argumentValues.toArray(new Object[argumentValues.size()]));
            return result;
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (InvocationTargetException targetException) {
            if (targetException.getCause() instanceof InterpreterCanceledException) {
                throw (InterpreterCanceledException)targetException.getCause();
            }
            throw new EvaluationException(targetException.getTargetException());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not invoke method: " + operation.getIdentifier() + " on instance: " + receiver, e);
        }
    }

    protected List<Object> evaluateArgumentExpressions(JvmExecutable executable, List<XExpression> expressions, IEvaluationContext context, CancelIndicator indicator) {
        XExpression arg;
        ArrayList result = Lists.newArrayList();
        int paramCount = executable.getParameters().size();
        if (executable.isVarArgs()) {
            --paramCount;
        }
        int i = 0;
        while (i < paramCount) {
            arg = expressions.get(i);
            Object argResult = this.internalEvaluate(arg, context, indicator);
            JvmTypeReference parameterType = ((JvmFormalParameter)executable.getParameters().get(i)).getParameterType();
            Object argumentValue = this.coerceArgumentType(argResult, parameterType);
            result.add(argumentValue);
            ++i;
        }
        if (executable.isVarArgs()) {
            Class<?> componentType = null;
            if (executable instanceof JvmOperation) {
                Method method = this.javaReflectAccess.getMethod((JvmOperation)executable);
                componentType = method.getParameterTypes()[paramCount].getComponentType();
            } else {
                Constructor constructor = this.javaReflectAccess.getConstructor((JvmConstructor)executable);
                componentType = constructor.getParameterTypes()[paramCount].getComponentType();
            }
            if (expressions.size() == executable.getParameters().size()) {
                arg = expressions.get(paramCount);
                Object lastArgResult = this.internalEvaluate(arg, context, indicator);
                if (componentType.isInstance(lastArgResult)) {
                    Object array = Array.newInstance(componentType, 1);
                    Array.set(array, 0, lastArgResult);
                    result.add(array);
                } else {
                    result.add(lastArgResult);
                }
            } else {
                Object array = Array.newInstance(componentType, expressions.size() - paramCount);
                int i2 = paramCount;
                while (i2 < expressions.size()) {
                    XExpression arg2 = expressions.get(i2);
                    Object argValue = this.internalEvaluate(arg2, context, indicator);
                    Array.set(array, i2 - paramCount, argValue);
                    ++i2;
                }
                result.add(array);
            }
        }
        return result;
    }

    protected Object coerceArgumentType(Object value, JvmTypeReference expectedType) {
        if (value == null) {
            return null;
        }
        if (expectedType.getType() instanceof JvmGenericType && ((JvmGenericType)expectedType.getType()).isInterface()) {
            try {
                JvmType type = expectedType.getType();
                Class functionIntf = this.classFinder.forName(type.getIdentifier());
                if (!functionIntf.isInstance(value)) {
                    InvocationHandler invocationHandler = null;
                    if (Proxy.isProxyClass(value.getClass())) {
                        invocationHandler = Proxy.getInvocationHandler(value);
                    } else if (this.getClass(Functions.Function0.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function0.class));
                    } else if (this.getClass(Functions.Function1.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function1.class));
                    } else if (this.getClass(Functions.Function2.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function2.class));
                    } else if (this.getClass(Functions.Function3.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function3.class));
                    } else if (this.getClass(Functions.Function4.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function4.class));
                    } else if (this.getClass(Functions.Function5.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function5.class));
                    } else if (this.getClass(Functions.Function6.class).isInstance(value)) {
                        invocationHandler = new DelegatingInvocationHandler(value, this.getClass(Functions.Function6.class));
                    } else {
                        return value;
                    }
                    Object proxy = Proxy.newProxyInstance(this.classLoader, new Class[]{functionIntf}, invocationHandler);
                    return proxy;
                }
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
        }
        return value;
    }

    protected Object _evaluateAssignment(XAssignment assignment, IEvaluationContext context, CancelIndicator indicator) {
        Object value = this.internalEvaluate(assignment.getValue(), context, indicator);
        Object assign = this.assignValue(assignment.getFeature(), assignment, value, context, indicator);
        return assign;
    }

    protected Object assignValue(JvmIdentifiableElement feature, XAssignment assignment, Object value, IEvaluationContext context, CancelIndicator indicator) {
        return this.assignmentDispatcher.invoke(new Object[]{feature, assignment, value, context, indicator});
    }

    protected Object _assignValueToDeclaredVariable(XVariableDeclaration variable, XAssignment assignment, Object value, IEvaluationContext context, CancelIndicator indicator) {
        context.assignValue(QualifiedName.create((String[])new String[]{variable.getName()}), value);
        return value;
    }

    protected Object _assignValueToField(JvmField jvmField, XAssignment assignment, Object value, IEvaluationContext context, CancelIndicator indicator) {
        Object receiver = this.getReceiver(assignment, context, indicator);
        if (receiver == null) {
            throw new EvaluationException(new NullPointerException("Cannot assign value to field: " + jvmField.getIdentifier() + " on null instance"));
        }
        Field field = this.javaReflectAccess.getField(jvmField);
        try {
            if (field == null) {
                throw new NoSuchFieldException("Could not find field " + jvmField.getIdentifier());
            }
            field.setAccessible(true);
            field.set(receiver, value);
            return value;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access field: " + jvmField.getIdentifier() + " on instance: " + receiver, e);
        }
    }

    protected Object getReceiver(XAssignment assignment, IEvaluationContext context, CancelIndicator indicator) {
        Object receiver = null;
        receiver = assignment.getAssignable() == null ? context.getValue(XbaseScopeProvider.THIS) : this.internalEvaluate(assignment.getAssignable(), context, indicator);
        return receiver;
    }

    protected Object _assignValueByOperation(JvmOperation jvmOperation, XAssignment assignment, Object value, IEvaluationContext context, CancelIndicator indicator) {
        Object receiver = this.getReceiver(assignment, context, indicator);
        if (receiver == null) {
            throw new EvaluationException(new NullPointerException("Cannot invoke instance method: " + jvmOperation.getIdentifier() + " without receiver"));
        }
        ArrayList argumentValues = Lists.newArrayList((Object[])new Object[]{value});
        Object result = this.invokeOperation(jvmOperation, receiver, argumentValues);
        return result;
    }

    protected ClassFinder getClassFinder() {
        return this.classFinder;
    }

    protected JavaReflectAccess getJavaReflectAccess() {
        return this.javaReflectAccess;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrefixMethodFilter
    extends PolymorphicDispatcher.MethodNameFilter {
        public PrefixMethodFilter(String prefix, int minParams, int maxParams) {
            super(prefix, minParams, maxParams);
        }

        public boolean apply(Method param) {
            return param.getName().startsWith(this.methodName) && param.getParameterTypes().length >= this.minParams && param.getParameterTypes().length <= this.maxParams;
        }
    }

    static class ReturnValue
    extends RuntimeException {
        public Object returnValue;

        public ReturnValue(Object value) {
            this.returnValue = value;
        }
    }
}

