/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.Messages;
import org.eclipse.xtext.builder.internal.Activator;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BuildScheduler {
    private static final Logger log = Logger.getLogger(BuildScheduler.class);
    private Set<IProject> projectsScheduledForBuild = Sets.newHashSet();
    @Inject
    private IWorkspace workspace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleBuildIfNecessary(Iterable<IProject> toUpdate, IBuildFlag ... buildFlags) {
        for (IProject project : toUpdate) {
            if (!this.isBuildable(project)) continue;
            Set<IProject> set = this.projectsScheduledForBuild;
            synchronized (set) {
                if (!this.projectsScheduledForBuild.contains(project)) {
                    this.projectsScheduledForBuild.add(project);
                    new BuildJob(Messages.BuildScheduler_JobName, project, buildFlags).schedule();
                }
            }
        }
    }

    protected boolean isBuildable(IProject project) {
        return XtextProjectHelper.hasNature((IProject)project);
    }

    protected class BuildJob
    extends Job {
        private IProject project;
        private Map<String, String> builderArguments;

        public BuildJob(String name, IProject project, IBuildFlag ... buildFlags) {
            super(name);
            this.project = project;
            if (buildFlags != null && buildFlags.length > 0) {
                this.builderArguments = Maps.newHashMap();
                IBuildFlag[] iBuildFlagArray = buildFlags;
                int n = buildFlags.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildFlag buildFlag = iBuildFlagArray[n2];
                    buildFlag.addToMap(this.builderArguments);
                    ++n2;
                }
            } else {
                this.builderArguments = null;
            }
            this.setRule(BuildScheduler.this.workspace.getRuleFactory().buildRule());
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_AUTO_BUILD == family;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            try {
                Set set = BuildScheduler.this.projectsScheduledForBuild;
                synchronized (set) {
                    BuildScheduler.this.projectsScheduledForBuild.remove(this.project);
                }
                try {
                    if (BuildScheduler.this.isBuildable(this.project)) {
                        this.project.build(6, "org.eclipse.xtext.ui.shared.xtextBuilder", this.builderArguments, (IProgressMonitor)progress.newChild(1));
                    } else {
                        progress.worked(1);
                    }
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    if (monitor != null) {
                        monitor.done();
                    }
                    return iStatus;
                }
                catch (Exception x) {
                    Status status;
                    block15: {
                        log.error((Object)x.getMessage(), (Throwable)x);
                        status = new Status(4, Activator.getDefault().getBundle().getSymbolicName(), String.valueOf(Messages.BuildScheduler_BuildOf) + Strings.notNull((Object)this.project.getName()) + Messages.BuildScheduler_FailedEtc);
                        if (monitor == null) break block15;
                        monitor.done();
                    }
                    return status;
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
            return Status.OK_STATUS;
        }
    }
}

