/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.annotations.Beta;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Beta
public class JavaRuntimeVersion {
    public static int JAVA_VERSION = JavaRuntimeVersion.determineJavaVersion();

    public static void main(String[] args) {
        System.out.println(JAVA_VERSION);
    }

    public static boolean isJava11OrLater() {
        return JAVA_VERSION >= 11;
    }

    public static boolean isJava12OrLater() {
        return JAVA_VERSION >= 13;
    }

    public static boolean isJava13OrLater() {
        return JAVA_VERSION >= 13;
    }

    public static boolean isJava14OrLater() {
        return JAVA_VERSION >= 14;
    }

    public static boolean isJava15OrLater() {
        return JAVA_VERSION >= 15;
    }

    public static boolean isJava16OrLater() {
        return JAVA_VERSION >= 16;
    }

    public static boolean isJava17OrLater() {
        return JAVA_VERSION >= 17;
    }

    public static boolean isJava21OrLater() {
        return JAVA_VERSION >= 21;
    }

    private static int determineJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null) {
            return 8;
        }
        return JavaRuntimeVersion.determineJavaVersion(javaVersion);
    }

    static int determineJavaVersion(String javaVersion) {
        if (javaVersion.startsWith("1.")) {
            try {
                Pattern p = Pattern.compile("1\\.(\\d+)(.)*");
                Matcher matcher = p.matcher(javaVersion);
                if (matcher.matches()) {
                    String first = matcher.group(1);
                    int version = Integer.parseInt(first);
                    return version;
                }
            }
            catch (NumberFormatException p) {
                // empty catch block
            }
            return 8;
        }
        try {
            Pattern p = Pattern.compile("(\\d+)(.)*");
            Matcher matcher = p.matcher(javaVersion);
            if (matcher.matches()) {
                String first = matcher.group(1);
                int version = Integer.parseInt(first);
                return version;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 17;
    }
}

