/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.Util;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.model.edit.ITextualMultiModification;
import org.eclipse.xtext.ui.editor.model.edit.IssueModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.ILanguageResourceHelper;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.internal.XtextPluginImages;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;

@Beta
public class TextualMultiModificationWorkbenchMarkerResolutionAdapter
extends WorkbenchMarkerResolution {
    private static final Logger log = Logger.getLogger(TextualMultiModificationWorkbenchMarkerResolutionAdapter.class);
    private static final int MAX_QUICKFIXES = 5000;
    @Inject
    private IssueModificationContext.Factory modificationContextFactory;
    @Inject
    private IssueUtil issueUtil;
    @Inject
    private IImageHelper imageHelper;
    @Inject
    private ILanguageResourceHelper languageResourceHelper;
    @Named(value="org.eclipse.xtext.ui.editor.quickfix.AbstractIssueResolutionProviderAdapter.DEFAULT_IMAGE")
    @Inject(optional=true)
    private String defaultImage = "org.eclipse.xtext.ui.CORRECTION_CHANGE";
    private IssueResolution resolution;
    private IMarker marker;

    public IssueResolution getResolution() {
        return this.resolution;
    }

    public void setResolution(IssueResolution resolution) {
        if (!(resolution.getModification() instanceof ITextualMultiModification)) {
            throw new IllegalArgumentException("ITextualMultiModification expected");
        }
        this.resolution = resolution;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public void setMarker(IMarker marker) {
        this.marker = marker;
    }

    public String getLabel() {
        return this.resolution.getLabel();
    }

    public void run(IMarker pMarker) {
        Issue issue = this.issueUtil.createIssue(pMarker);
        if (issue == null) {
            return;
        }
        try {
            this.resolution.getModification().apply(this.modificationContextFactory.createModificationContext(issue));
        }
        catch (Exception exc) {
            throw new WrappedException(exc);
        }
    }

    public String getDescription() {
        return this.resolution.getDescription();
    }

    public Image getImage() {
        return this.getImage(this.resolution);
    }

    public Image getImage(IssueResolution resolution) {
        if (Strings.isEmpty((String)resolution.getImage())) {
            return XtextPluginImages.get(this.defaultImage);
        }
        return this.imageHelper.getImage(resolution.getImage());
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> result;
        block5: {
            result = new ArrayList<IMarker>();
            try {
                Object markerCodeKey = this.marker.getAttribute("CODE_KEY");
                if (markerCodeKey == null) break block5;
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    Object canidateCodeKey;
                    IMarker candidate = iMarkerArray[n2];
                    if (this.languageResourceHelper.isLanguageResource(this.marker.getResource()) && candidate != this.marker && Objects.equals(markerCodeKey, canidateCodeKey = candidate.getAttribute("CODE_KEY"))) {
                        result.add(candidate);
                        if (result.size() >= 5000) break;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                log.error((Object)"Reading of Marker attributes failed", (Throwable)e);
            }
        }
        return result.toArray(new IMarker[result.size()]);
    }

    public void processUIEvents(int waitTime) {
        if (Display.getCurrent() != null) {
            while (Display.getDefault().readAndDispatch()) {
            }
        }
        if (waitTime != 0) {
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                log.error((Object)"processUIEvents() interrupted", (Throwable)e);
            }
        }
    }

    public void run(IMarker[] markers, IProgressMonitor parentMonitor) {
        int count = markers.length;
        Comparator<IMarker> c1 = Comparator.comparing(e -> e.getResource().toString());
        Comparator<IMarker> c2 = Comparator.comparing(e -> -e.getAttribute("charEnd", 0));
        Arrays.sort(markers, c1.thenComparing(c2));
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)parentMonitor, (int)count);
        int i = 1;
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            if (parentMonitor.isCanceled()) {
                return;
            }
            monitor.subTask("fixing (" + i + "/" + count + ") in " + m.getResource().getName() + " Line " + Util.getProperty((String)"lineNumber", (IMarker)m));
            this.processUIEvents(0);
            this.run(m);
            monitor.worked(1);
            ++i;
            ++n2;
        }
    }

    public static class Factory {
        @Inject
        protected Provider<TextualMultiModificationWorkbenchMarkerResolutionAdapter> provider;

        public IMarkerResolution create(IMarker marker, IssueResolution resolution) {
            TextualMultiModificationWorkbenchMarkerResolutionAdapter adapter = (TextualMultiModificationWorkbenchMarkerResolutionAdapter)((Object)this.provider.get());
            adapter.setMarker(marker);
            adapter.setResolution(resolution);
            return adapter;
        }
    }
}

