/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.formatter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.ITextReplacement;
import org.eclipse.xtext.formatting2.TextReplacements;
import org.eclipse.xtext.formatting2.debug.TextRegionsToString;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeModelBasedRegionAccess;
import org.eclipse.xtext.junit4.formatter.FormatterTestRequest;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ExceptionAcceptor;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.junit.Assert;

public class FormatterTester {
    @Inject(optional=true)
    private Provider<IFormatter2> formatter;
    @Inject
    private Provider<FormatterTestRequest> formatterRequestProvider;
    @Inject
    private Provider<NodeModelBasedRegionAccess.Builder> nodeModelTokenAccessBuilderProvider;
    @Inject
    private ParseHelper<EObject> parseHelper;

    protected void assertAllHiddenRegionsAre(ITextRegionAccess expectation, List<ITextReplacement> actual) {
    }

    public void assertFormatted(FormatterTestRequest req) {
        Preconditions.checkNotNull((Object)req);
        Preconditions.checkNotNull((Object)req.getToBeFormatted());
        FormatterRequest request = req.getRequest();
        Preconditions.checkArgument((request.getTextRegionAccess() == null ? 1 : 0) != 0);
        String document = req.getToBeFormatted().toString();
        XtextResource parsed = this.parse(document);
        if (req.isAllowSyntaxErrors()) {
            request.setExceptionHandler((IAcceptor)ExceptionAcceptor.IGNORING);
        } else {
            this.assertNoSyntaxErrors(parsed);
            request.setExceptionHandler((IAcceptor)ExceptionAcceptor.THROWING);
        }
        request.setTextRegionAccess((ITextRegionAccess)((NodeModelBasedRegionAccess.Builder)this.nodeModelTokenAccessBuilderProvider.get()).withResource(parsed).create());
        if (request.getPreferences() == null) {
            request.setPreferences((ITypedPreferenceValues)new MapBasedPreferenceValues((Map)Maps.newLinkedHashMap()));
        }
        List format = this.createFormatter(req).format(request);
        this.assertReplacementsAreInRegion(format, request.getRegions(), document);
        this.assertAllHiddenRegionsAre(request.getTextRegionAccess(), format);
        String applied = TextReplacements.apply((CharSequence)document, (Iterable)format);
        Assert.assertEquals((Object)req.getExpectationOrToBeFormatted().toString(), (Object)applied);
    }

    public void assertFormatted(Procedures.Procedure1<FormatterTestRequest> init) {
        FormatterTestRequest request = (FormatterTestRequest)this.formatterRequestProvider.get();
        init.apply((Object)request);
        this.assertFormatted(request);
    }

    protected void assertNoSyntaxErrors(XtextResource resource) {
        Iterable syntaxErrors = resource.getParseResult().getSyntaxErrors();
        if (!Iterables.isEmpty((Iterable)syntaxErrors)) {
            StringBuilder builder = new StringBuilder();
            builder.append("This document can't be formatted because of syntax errors:\n");
            for (INode node : syntaxErrors) {
                SyntaxErrorMessage msg = node.getSyntaxErrorMessage();
                builder.append(String.format("Line %02d: %s\n", node.getTotalStartLine(), msg.getMessage()));
            }
            this.fail(builder, resource.getParseResult().getRootNode().getText());
        }
    }

    protected void assertReplacementsAreInRegion(List<ITextReplacement> rep, Collection<ITextRegion> regions, String doc) {
        HashSet invalid = Sets.newHashSet();
        block0: for (ITextRegion allowed : regions) {
            for (ITextReplacement r : rep) {
                if (allowed.contains((ITextRegion)r)) continue block0;
                invalid.add(r);
            }
        }
        if (!invalid.isEmpty()) {
            String visualized = new TextRegionsToString().addAllReplacements((Iterable)invalid).toString();
            this.fail("One or more TextReplacements are outside of the allowed region. Region: " + regions, visualized);
        }
    }

    protected IFormatter2 createFormatter(FormatterTestRequest request) {
        return (IFormatter2)this.formatter.get();
    }

    protected void fail(CharSequence error, CharSequence document) {
        StringBuilder builder = new StringBuilder(Strings.trimTrailingLineBreak((CharSequence)error));
        if (document != null) {
            builder.append("\n----------------------------------------------------------\n");
            builder.append(Strings.trimTrailingLineBreak((CharSequence)document));
            builder.append("\n----------------------------------------------------------");
        }
        String msg = builder.toString();
        System.err.println(msg);
        Assert.fail((String)msg);
    }

    protected XtextResource parse(String document) {
        try {
            return (XtextResource)this.parseHelper.parse(document).eResource();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

