/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.project;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.xtext.xtext.ui.wizard.project.Messages;
import org.eclipse.xtext.xtext.ui.wizard.project.WizardContribution;

public class WizardNewXtextProjectCreationPage
extends WizardNewProjectCreationPage {
    private Text languageNameField;
    private final IStructuredSelection selection;
    private Text extensionsField;
    private Combo generatorConfigurationField;
    private Button createFeatureProject;

    public WizardNewXtextProjectCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection = selection;
        this.setTitle(Messages.WizardNewXtextProjectCreationPage_WindowTitle);
        this.setDescription(Messages.WizardNewXtextProjectCreationPage_Description);
    }

    public void createControl(Composite parent) {
        String projectsuffix = this.findNextValidProjectSuffix("org.xtext.example", "mydsl");
        this.setInitialProjectName("org.xtext.example." + projectsuffix);
        super.createControl(parent);
        this.createLanguageSelectionGroup((Composite)this.getControl());
        this.createProjectLayoutGroup((Composite)this.getControl());
        this.createWorkingSetGroup((Composite)this.getControl(), this.selection, this.getWorkingSetIdents());
        this.setDefaults(projectsuffix);
        Dialog.applyDialogFont((Control)this.getControl());
    }

    protected String[] getWorkingSetIdents() {
        return new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.pde.ui.pluginWorkingSet", "org.eclipse.ui.resourceWorkingSetPage"};
    }

    protected void setDefaults(String projectSuffix) {
        this.languageNameField.setText("org.xtext.example." + projectSuffix + ".MyDsl");
        this.extensionsField.setText(projectSuffix);
        this.fillMweSnippet();
        this.validatePage();
    }

    protected void fillMweSnippet() {
        Map<String, WizardContribution> contributions = WizardContribution.getFromRegistry();
        ArrayList contrib = Lists.newArrayList(contributions.values());
        Collections.sort(contrib);
        ArrayList names = Lists.newArrayList((Iterable)Iterables.transform((Iterable)contrib, (Function)new Function<WizardContribution, String>(){

            public String apply(WizardContribution input) {
                return input.getName();
            }
        }));
        if (this.generatorConfigurationField != null) {
            this.generatorConfigurationField.setItems(names.toArray(new String[names.size()]));
            this.generatorConfigurationField.select(this.indexOfDefault(names));
        }
    }

    protected int indexOfDefault(List<String> contributions) {
        int indexOf = contributions.indexOf(this.getDefaultConfigName());
        return indexOf != -1 ? indexOf : 0;
    }

    protected String getDefaultConfigName() {
        return "Standard";
    }

    protected String findNextValidProjectSuffix(String prefix, String name) {
        String candidate = name;
        int suffix = 1;
        while (ResourcesPlugin.getWorkspace().getRoot().getProject((String.valueOf(prefix) + "." + candidate).toLowerCase()).exists()) {
            candidate = String.valueOf(name) + suffix;
            ++suffix;
        }
        return candidate;
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        IStatus status = JavaConventions.validatePackageName((String)this.getProjectName(), (String)"1.5", (String)"1.5");
        if (!status.isOK()) {
            this.setErrorMessage(String.valueOf(Messages.WizardNewXtextProjectCreationPage_ErrorMessageProjectName) + status.getMessage());
            return false;
        }
        if (this.languageNameField == null) {
            return true;
        }
        if (this.languageNameField.getText().length() == 0) {
            return false;
        }
        status = JavaConventions.validateJavaTypeName((String)this.languageNameField.getText(), (String)"1.5", (String)"1.5");
        if (!status.isOK()) {
            this.setErrorMessage(String.valueOf(Messages.WizardNewXtextProjectCreationPage_ErrorMessageLanguageName) + status.getMessage());
            return false;
        }
        if (this.extensionsField.getText().length() == 0) {
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    protected void createLanguageSelectionGroup(Composite parent) {
        Group languageGroup = new Group(parent, 0);
        languageGroup.setFont(parent.getFont());
        languageGroup.setText(Messages.WizardNewXtextProjectCreationPage_LabelLanguage);
        languageGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        languageGroup.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite((Composite)languageGroup, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label languageLabel = new Label(composite, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        languageLabel.setText(Messages.WizardNewXtextProjectCreationPage_LabelName);
        this.languageNameField = new Text(composite, 2048);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.languageNameField.setLayoutData((Object)data);
        this.languageNameField.setFont(parent.getFont());
        Label extensionsLabel = new Label(composite, 0);
        extensionsLabel.setText(Messages.WizardNewXtextProjectCreationPage_LabelExtensions);
        this.extensionsField = new Text(composite, 2048);
        GridData textData = new GridData(4, 0x1000000, true, false);
        textData.horizontalSpan = 1;
        textData.horizontalIndent = 0;
        this.extensionsField.setLayoutData((Object)textData);
        Listener modifyListener = new Listener(){

            public void handleEvent(Event event) {
                WizardNewXtextProjectCreationPage.this.setPageComplete(WizardNewXtextProjectCreationPage.this.validatePage());
            }
        };
        this.languageNameField.addListener(24, modifyListener);
        this.extensionsField.addListener(24, modifyListener);
    }

    protected void createProjectLayoutGroup(Composite parent) {
        boolean showGeneratorConfigCombo = WizardContribution.getFromRegistry().size() > 1;
        Group layoutGroup = new Group(parent, 0);
        layoutGroup.setFont(parent.getFont());
        layoutGroup.setText(Messages.WizardNewXtextProjectCreationPage_LabelLayout);
        layoutGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        layoutGroup.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite((Composite)layoutGroup, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setLayout((Layout)new GridLayout(showGeneratorConfigCombo ? 2 : 1, false));
        if (showGeneratorConfigCombo) {
            Label generatorConfigLabel = new Label(composite, 0);
            generatorConfigLabel.setText(Messages.WizardNewXtextProjectCreationPage_GeneratorConfiguration);
            this.generatorConfigurationField = new Combo(composite, 8);
            GridData data = new GridData(768);
            data.horizontalSpan = 1;
            this.generatorConfigurationField.setLayoutData((Object)data);
            this.generatorConfigurationField.setFont(parent.getFont());
        }
        this.createFeatureProject = new Button(composite, 32);
        this.createFeatureProject.setText(Messages.WizardNewXtextProjectCreationPage_CreateFeatureLabel);
        GridData featureGD = new GridData(4, 0x1000000, true, false);
        featureGD.horizontalSpan = 1;
        this.createFeatureProject.setLayoutData((Object)featureGD);
        this.createFeatureProject.setSelection(true);
    }

    public String getFileExtensions() {
        return this.extensionsField.getText();
    }

    public String getLanguageName() {
        return this.languageNameField.getText();
    }

    public String getGeneratorConfig() {
        if (this.generatorConfigurationField == null) {
            return WizardContribution.getFromRegistry().values().iterator().next().getName();
        }
        return this.generatorConfigurationField.getItems()[this.generatorConfigurationField.getSelectionIndex()];
    }

    public boolean isCreateFeatureProject() {
        return this.createFeatureProject.getSelection();
    }
}

