/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.editor.outline;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.ModeAwareOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineMode;
import org.eclipse.xtext.ui.label.StylerFactory;
import org.eclipse.xtext.xtext.UsedRulesFinder;
import org.eclipse.xtext.xtext.ui.editor.outline.RuleNode;
import org.eclipse.xtext.xtext.ui.editor.syntaxcoloring.SemanticHighlightingConfiguration;

public class XtextOutlineTreeProvider
extends ModeAwareOutlineTreeProvider {
    private static final String ALIAS_TYPE_SEPARATOR = "::";
    public static final String NAME_TYPE_SEPARATOR = " - ";
    private static final OutlineMode SHOW_INHERITED_MODE = new OutlineMode("show", "show inherited rules");
    private static final OutlineMode HIDE_INHERITED_MODE = new OutlineMode("hide", "hide inherited rules");
    private static final List<OutlineMode> MODES = Lists.newArrayList((Object[])new OutlineMode[]{HIDE_INHERITED_MODE, SHOW_INHERITED_MODE});
    @Inject
    private SemanticHighlightingConfiguration semanticHighlightingConfiguration;
    @Inject
    private StylerFactory stylerFactory;
    private Set<AbstractRule> calledRules = Sets.newHashSet();

    public List<OutlineMode> getOutlineModes() {
        return MODES;
    }

    protected Object _text(AbstractRule rule) {
        StyledString ruleText = null;
        ruleText = !this.calledRules.isEmpty() && !this.calledRules.contains(rule) ? new StyledString(this.safeName(rule.getName()), this.stylerFactory.createXtextStyleAdapterStyler(this.semanticHighlightingConfiguration.unusedRule())) : (GrammarUtil.isDatatypeRule((AbstractRule)rule) ? new StyledString(this.safeName(rule.getName()), this.stylerFactory.createXtextStyleAdapterStyler(this.semanticHighlightingConfiguration.dataTypeRule())) : new StyledString(this.safeName(rule.getName())));
        return ruleText;
    }

    protected StyledString getReturnTypeText(AbstractRule rule) {
        StringBuilder typeName = new StringBuilder(NAME_TYPE_SEPARATOR);
        if (rule.getType() != null && rule.getType().getClassifier() != null && rule.getType().getMetamodel() != null) {
            String alias = rule.getType().getMetamodel().getAlias();
            if (alias != null) {
                typeName.append(alias);
                typeName.append(ALIAS_TYPE_SEPARATOR);
            }
            typeName.append(this.safeName(rule.getType().getClassifier().getName()));
        } else {
            typeName.append(this.safeName(rule.getName()));
        }
        StyledString styledType = new StyledString(typeName.toString(), this.stylerFactory.createXtextStyleAdapterStyler(this.semanticHighlightingConfiguration.typeReference()));
        return styledType;
    }

    protected void _createNode(DocumentRootNode parentNode, Grammar grammar) {
        this.calledRules = Sets.newHashSet();
        if (!grammar.getRules().isEmpty()) {
            UsedRulesFinder usedRulesFinder = new UsedRulesFinder(this.calledRules);
            usedRulesFinder.compute(grammar);
        }
        super._createNode(parentNode, (EObject)grammar);
    }

    protected void _createNode(IOutlineNode parentNode, AbstractRule rule) {
        this.createRuleNode(parentNode, rule, false, true);
    }

    protected void createRuleNode(IOutlineNode parentNode, AbstractRule rule, boolean isShowGrammar, boolean isLocalRule) {
        EObject grammar;
        StyledString text = (StyledString)this.textDispatcher.invoke(new Object[]{rule});
        if (isShowGrammar && (grammar = rule.eContainer()) instanceof Grammar) {
            text.append(new StyledString(" (" + ((Grammar)grammar).getName() + ")", StyledString.COUNTER_STYLER));
        }
        Image image = (Image)this.imageDispatcher.invoke(new Object[]{rule});
        RuleNode ruleNode = new RuleNode((EObject)rule, parentNode, image, text, (Boolean)this.isLeafDispatcher.invoke(new Object[]{rule}));
        if (isLocalRule) {
            ICompositeNode parserNode = NodeModelUtils.getNode((EObject)rule);
            if (parserNode != null) {
                ruleNode.setTextRegion(parserNode.getTextRegion());
            }
            ruleNode.setShortTextRegion(this.locationInFileProvider.getSignificantTextRegion((EObject)rule));
            ruleNode.setFullText(new StyledString().append(text).append(this.getReturnTypeText(rule)));
        }
    }

    protected void _createChildren(IOutlineNode parentNode, Grammar grammar) {
        for (AbstractMetamodelDeclaration metamodelDeclaration : grammar.getMetamodelDeclarations()) {
            this.createNode(parentNode, (EObject)metamodelDeclaration);
        }
        for (AbstractRule rule : grammar.getRules()) {
            this.createNode(parentNode, (EObject)rule);
        }
        if (this.getCurrentMode() == SHOW_INHERITED_MODE) {
            for (AbstractRule rule : GrammarUtil.allRules((Grammar)grammar)) {
                if (rule.eContainer() == grammar) continue;
                this.createRuleNode(parentNode, rule, true, false);
            }
        }
    }

    protected boolean _isLeaf(AbstractRule rule) {
        return true;
    }

    protected String safeName(String s) {
        return s == null ? "<unnamed>" : s;
    }
}

