/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor.copyqualifiedname;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.ui.editor.copyqualifiedname.DefaultCopyQualifiedNameService;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class XbaseCopyQualifiedNameService
extends DefaultCopyQualifiedNameService {
    @Inject
    private OverrideHelper overrideHelper;
    @Inject
    private IBatchTypeResolver typeResolver;

    protected String toQualifiedName(JvmExecutable jvmExecutable) {
        return String.valueOf(this.toFullyQualifiedName((EObject)jvmExecutable)) + "(" + this.toQualifiedNames((List)jvmExecutable.getParameters(), parameter -> parameter.getParameterType().getSimpleName()) + ")";
    }

    protected String toQualifiedName(XExpression expression, IResolvedExecutable resolvedExecutable, JvmExecutable executable, IResolvedTypes resolvedTypes, List<XExpression> arguments) {
        LightweightTypeReference actualType = resolvedTypes.getActualType(expression);
        if (actualType != null && !actualType.isAny() && !actualType.isUnknown()) {
            return actualType.getHumanReadableName();
        }
        int index = arguments.indexOf(expression);
        if (resolvedExecutable == null) {
            return ((JvmFormalParameter)executable.getParameters().get(index)).getParameterType().getSimpleName();
        }
        return ((LightweightTypeReference)resolvedExecutable.getResolvedParameterTypes().get(index)).getSimpleName();
    }

    public String getQualifiedName(EObject constructor, EObject constructorCall) {
        if (constructor instanceof JvmConstructor && constructorCall instanceof XConstructorCall) {
            return this._getQualifiedName((JvmConstructor)constructor, (XConstructorCall)constructorCall);
        }
        if (constructor instanceof JvmExecutable && constructorCall instanceof XAbstractFeatureCall) {
            return this._getQualifiedName((JvmExecutable)constructor, (XAbstractFeatureCall)constructorCall);
        }
        if (constructor instanceof JvmExecutable && constructorCall != null) {
            return this._getQualifiedName((JvmExecutable)constructor, constructorCall);
        }
        if (constructor instanceof JvmExecutable && constructorCall == null) {
            return this._getQualifiedName((JvmExecutable)constructor, (Void)null);
        }
        if (constructor != null && constructorCall != null) {
            return this._getQualifiedName(constructor, constructorCall);
        }
        if (constructor != null && constructorCall == null) {
            return this._getQualifiedName(constructor, null);
        }
        if (constructor == null && constructorCall != null) {
            return this._getQualifiedName(null, constructorCall);
        }
        return this._getQualifiedName(null, null);
    }

    protected String _getQualifiedName(JvmExecutable jvmExecutable, EObject context) {
        return this.toQualifiedName(jvmExecutable);
    }

    protected String _getQualifiedName(JvmExecutable jvmExecutable, Void context) {
        return this.toQualifiedName(jvmExecutable);
    }

    protected String _getQualifiedName(JvmExecutable executable, XAbstractFeatureCall featureCall) {
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)featureCall);
        IResolvedExecutable resolvedExecutable = this.resolveExecutable(executable, (XExpression)featureCall, resolvedTypes);
        return String.valueOf(this.toFullyQualifiedName((EObject)executable)) + "(" + this.toQualifiedNames((List)featureCall.getActualArguments(), argument -> this.toQualifiedName((XExpression)argument, resolvedExecutable, executable, resolvedTypes, (List<XExpression>)featureCall.getActualArguments())) + ")";
    }

    protected String _getQualifiedName(JvmConstructor constructor, XConstructorCall constructorCall) {
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)constructorCall);
        IResolvedExecutable resolvedExecutable = this.resolveExecutable((JvmExecutable)constructor, (XExpression)constructorCall, resolvedTypes);
        return String.valueOf(this.toFullyQualifiedName((EObject)constructor)) + "(" + this.toQualifiedNames((List)constructorCall.getArguments(), argument -> this.toQualifiedName((XExpression)argument, resolvedExecutable, (JvmExecutable)constructor, resolvedTypes, (List<XExpression>)constructorCall.getArguments())) + ")";
    }

    protected IResolvedExecutable resolveExecutable(JvmExecutable consturctor, XExpression expression, IResolvedTypes resolvedTypes) {
        if (consturctor instanceof JvmConstructor && expression instanceof XAbstractFeatureCall) {
            return this._resolveExecutable((JvmConstructor)consturctor, (XAbstractFeatureCall)expression, resolvedTypes);
        }
        if (consturctor instanceof JvmConstructor && expression instanceof XConstructorCall) {
            return this._resolveExecutable((JvmConstructor)consturctor, (XConstructorCall)expression, resolvedTypes);
        }
        if (consturctor instanceof JvmOperation && expression instanceof XAbstractFeatureCall) {
            return this._resolveExecutable((JvmOperation)consturctor, (XAbstractFeatureCall)expression, resolvedTypes);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(consturctor, expression, resolvedTypes).toString());
    }

    private IResolvedExecutable findDeclaredConstructor(JvmConstructor constructor, LightweightTypeReference actualType) {
        ResolvedFeatures resolvedFeatures = this.overrideHelper.getResolvedFeatures(actualType);
        for (IResolvedConstructor declaredConstructor : resolvedFeatures.getDeclaredConstructors()) {
            if (!declaredConstructor.getDeclaration().equals(constructor)) continue;
            return declaredConstructor;
        }
        return null;
    }

    protected IResolvedExecutable _resolveExecutable(JvmConstructor constructor, XAbstractFeatureCall featureCall, IResolvedTypes resolvedTypes) {
        XExpression actualReceiver = featureCall.getActualReceiver();
        if (actualReceiver != null) {
            LightweightTypeReference actualType = resolvedTypes.getActualType(actualReceiver);
            return this.findDeclaredConstructor(constructor, actualType);
        }
        return null;
    }

    protected IResolvedExecutable _resolveExecutable(JvmConstructor constructor, XConstructorCall constructorCall, IResolvedTypes resolvedTypes) {
        LightweightTypeReference actualType = resolvedTypes.getActualType((XExpression)constructorCall);
        if (actualType != null) {
            return this.findDeclaredConstructor(constructor, actualType);
        }
        return null;
    }

    protected IResolvedExecutable _resolveExecutable(JvmOperation operation, XAbstractFeatureCall featureCall, IResolvedTypes resolvedTypes) {
        XExpression actualReceiver = featureCall.getActualReceiver();
        if (actualReceiver != null) {
            LightweightTypeReference actualType = resolvedTypes.getActualType(actualReceiver);
            ResolvedFeatures resolvedFeatures = this.overrideHelper.getResolvedFeatures(actualType);
            for (IResolvedOperation resolvedOperation : resolvedFeatures.getAllOperations()) {
                if (!resolvedOperation.getDeclaration().equals(operation)) continue;
                return resolvedOperation;
            }
        }
        return null;
    }
}

