/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Pair;

public class IdeContentProposalAcceptor
implements IIdeContentProposalAcceptor,
Comparator<Pair<Integer, ContentAssistEntry>> {
    @Inject
    private OperationCanceledManager operationCanceledManager;
    protected CancelIndicator cancelIndicator;
    protected final Set<Pair<Integer, ContentAssistEntry>> entries = new TreeSet<Pair<Integer, ContentAssistEntry>>(this);

    public void setCancelIndicator(CancelIndicator cancelIndicator) {
        this.cancelIndicator = cancelIndicator;
    }

    @Override
    public void accept(ContentAssistEntry entry, int priority) {
        this.operationCanceledManager.checkCanceled(this.cancelIndicator);
        if (entry != null) {
            if (entry.getProposal() == null) {
                throw new IllegalArgumentException("Proposal must not be null.");
            }
            this.entries.add((Pair<Integer, ContentAssistEntry>)Pair.of((Object)priority, (Object)entry));
        }
    }

    @Override
    public boolean canAcceptMoreProposals() {
        return this.entries.size() < 100;
    }

    @Override
    public int compare(Pair<Integer, ContentAssistEntry> p1, Pair<Integer, ContentAssistEntry> p2) {
        String s2;
        int prioResult = ((Integer)p2.getKey()).compareTo((Integer)p1.getKey());
        if (prioResult != 0) {
            return prioResult;
        }
        String s1 = ((ContentAssistEntry)p1.getValue()).getLabel() != null ? ((ContentAssistEntry)p1.getValue()).getLabel() : ((ContentAssistEntry)p1.getValue()).getProposal();
        int ignoreCase = s1.compareToIgnoreCase(s2 = ((ContentAssistEntry)p2.getValue()).getLabel() != null ? ((ContentAssistEntry)p2.getValue()).getLabel() : ((ContentAssistEntry)p2.getValue()).getProposal());
        if (ignoreCase == 0) {
            return s1.compareTo(s2);
        }
        return ignoreCase;
    }

    public Iterable<ContentAssistEntry> getEntries() {
        return Iterables.transform(this.entries, e -> (ContentAssistEntry)e.getValue());
    }
}

