/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.parser;

import lpg.runtime.IAst;
import lpg.runtime.IToken;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;

public class LPGSourcePositionLocator
implements ISourcePositionLocator {
    private final IParseController fParseController;

    public LPGSourcePositionLocator(IParseController parseController) {
        this.fParseController = parseController;
    }

    public Object findNode(Object root, int offset) {
        return this.findNode(root, offset, offset);
    }

    public Object findNode(Object root, int startOffset, int endOffset) {
        if (!(root instanceof IAst)) {
            return root;
        }
        IAst astNode = (IAst)root;
        if (astNode.getAllChildren() != null) {
            int i = 0;
            while (i < astNode.getAllChildren().size()) {
                IAst maybe = (IAst)this.findNode(astNode.getAllChildren().get(i), startOffset, endOffset);
                if (maybe != null) {
                    return maybe;
                }
                ++i;
            }
        }
        if (startOffset >= astNode.getLeftIToken().getStartOffset() && endOffset <= astNode.getRightIToken().getEndOffset()) {
            return astNode;
        }
        return null;
    }

    public int getStartOffset(Object entity) {
        if (entity instanceof IAst) {
            IAst n = (IAst)entity;
            return n.getLeftIToken().getStartOffset();
        }
        if (entity instanceof IToken) {
            IToken tok = (IToken)entity;
            return tok.getStartOffset();
        }
        if (entity instanceof ModelTreeNode) {
            ModelTreeNode treeNode = (ModelTreeNode)entity;
            return ((IAst)treeNode.getASTNode()).getLeftIToken().getStartOffset();
        }
        return 0;
    }

    public int getEndOffset(Object entity) {
        if (entity instanceof IAst) {
            IAst n = (IAst)entity;
            return n.getRightIToken().getEndOffset();
        }
        if (entity instanceof IToken) {
            IToken tok = (IToken)entity;
            return tok.getEndOffset();
        }
        if (entity instanceof ModelTreeNode) {
            ModelTreeNode treeNode = (ModelTreeNode)entity;
            return ((IAst)treeNode.getASTNode()).getRightIToken().getEndOffset();
        }
        return 0;
    }

    public int getLength(Object node) {
        return this.getEndOffset(node) - this.getStartOffset(node);
    }

    public IPath getPath(Object entity) {
        if (entity instanceof IAst) {
            IAst node = (IAst)entity;
            return this.fParseController.getProject().getRawProject().getFile(node.getLeftIToken().getILexStream().getFileName()).getFullPath();
        }
        if (entity instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)entity;
            return cu.getPath();
        }
        return new Path("");
    }
}

