/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.view;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.ui.viewer.ColumnResizer;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedPropertySheetPage
extends PropertySheetPage {
    protected List<Object> objectsToSelect = new ArrayList<Object>();
    protected AdapterFactoryEditingDomain editingDomain;
    protected DiagnosticDecorator diagnosticDecorator;
    protected IDialogSettings dialogSettings;
    protected List<?> input = Collections.emptyList();
    protected IPropertySourceProvider propertySourceProvider;
    protected IAction locateValueAction = new LocateValueAction();
    protected SetValueAction setValueAction = new SetValueAction();
    protected IAction restoreValueAction;
    protected int autoExpandLevel;
    protected boolean autoResizeColumns;
    protected ColumnResizer.Handler columnResizer;

    public ExtendedPropertySheetPage(AdapterFactoryEditingDomain editingDomain) {
        this(editingDomain, Decoration.NONE, null, 0, false);
    }

    public ExtendedPropertySheetPage(AdapterFactoryEditingDomain editingDomain, Decoration decoration) {
        this(editingDomain, decoration, null, 0, false);
    }

    public ExtendedPropertySheetPage(AdapterFactoryEditingDomain editingDomain, Decoration decoration, IDialogSettings dialogSettings) {
        this(editingDomain, decoration, dialogSettings, 0, false);
    }

    public ExtendedPropertySheetPage(AdapterFactoryEditingDomain editingDomain, Decoration decoration, IDialogSettings dialogSettings, int autoExpandLevel, boolean autoResizeColumns) {
        this.editingDomain = editingDomain;
        this.dialogSettings = dialogSettings;
        this.autoExpandLevel = autoExpandLevel;
        this.autoResizeColumns = autoResizeColumns;
        this.autoResizeColumns = autoResizeColumns;
        this.diagnosticDecorator = this.createDiagnosticDecorator(decoration);
    }

    protected DiagnosticDecorator createDiagnosticDecorator(Decoration decoration) {
        switch (decoration) {
            case MANUAL: {
                return new DiagnosticDecorator(this.editingDomain.getResourceSet(), this);
            }
            case LIVE: {
                return new DiagnosticDecorator((EditingDomain)this.editingDomain, this, this.dialogSettings);
            }
        }
        return null;
    }

    public void setPropertySourceProvider(IPropertySourceProvider newProvider) {
        this.propertySourceProvider = newProvider;
        super.setPropertySourceProvider(newProvider);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        ExtendedPropertySheetEntry decoratingPropertySheetEntry = new ExtendedPropertySheetEntry(this.diagnosticDecorator);
        decoratingPropertySheetEntry.setPropertySourceProvider(this.propertySourceProvider);
        this.setRootEntry((IPropertySheetEntry)decoratingPropertySheetEntry);
        Tree tree = (Tree)this.getControl();
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object data = e.item.getData();
                ExtendedPropertySheetPage.this.handleEntrySelection((ISelection)new StructuredSelection(data));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.autoResizeColumns) {
            this.columnResizer = ColumnResizer.addColumnResizer((Tree)tree);
        }
    }

    protected void setSelectionToViewer(List<?> selection) {
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        class DelegatingToolBarManager
        implements IToolBarManager {
            private final /* synthetic */ IToolBarManager val$toolBarManager;

            DelegatingToolBarManager(IToolBarManager iToolBarManager) {
                this.val$toolBarManager = iToolBarManager;
            }

            public void add(IAction action) {
                if ("defaults".equals(action.getId())) {
                    ExtendedPropertySheetPage.this.restoreValueAction = action;
                    if (ExtendedPropertySheetPage.this.setValueAction != null) {
                        this.val$toolBarManager.add((IAction)ExtendedPropertySheetPage.this.setValueAction);
                    }
                }
                this.val$toolBarManager.add(action);
            }

            public void add(IContributionItem item) {
                this.val$toolBarManager.add(item);
            }

            public void appendToGroup(String groupName, IAction action) {
                this.val$toolBarManager.appendToGroup(groupName, action);
            }

            public void appendToGroup(String groupName, IContributionItem item) {
                this.val$toolBarManager.appendToGroup(groupName, item);
            }

            public IContributionItem find(String id) {
                return this.val$toolBarManager.find(id);
            }

            public IContributionItem[] getItems() {
                return this.val$toolBarManager.getItems();
            }

            public IContributionManagerOverrides getOverrides() {
                return this.val$toolBarManager.getOverrides();
            }

            public void insertAfter(String id, IAction action) {
                this.val$toolBarManager.insertAfter(id, action);
            }

            public void insertAfter(String id, IContributionItem item) {
                this.val$toolBarManager.insertAfter(id, item);
            }

            public void insertBefore(String id, IAction action) {
                this.val$toolBarManager.insertBefore(id, action);
            }

            public void insertBefore(String id, IContributionItem item) {
                this.val$toolBarManager.insertBefore(id, item);
            }

            public boolean isDirty() {
                return this.val$toolBarManager.isDirty();
            }

            public boolean isEmpty() {
                return this.val$toolBarManager.isEmpty();
            }

            public void markDirty() {
                this.val$toolBarManager.markDirty();
            }

            public void prependToGroup(String groupName, IAction action) {
                this.val$toolBarManager.prependToGroup(groupName, action);
            }

            public void prependToGroup(String groupName, IContributionItem item) {
                this.val$toolBarManager.prependToGroup(groupName, item);
            }

            public IContributionItem remove(String id) {
                return this.val$toolBarManager.remove(id);
            }

            public IContributionItem remove(IContributionItem item) {
                return this.val$toolBarManager.remove(item);
            }

            public void removeAll() {
                this.val$toolBarManager.removeAll();
            }

            public void update(boolean force) {
                this.val$toolBarManager.update(force);
            }
        }
        super.makeContributions(menuManager, (IToolBarManager)new DelegatingToolBarManager(toolBarManager), statusLineManager);
        toolBarManager.add(this.locateValueAction);
    }

    public void handleEntrySelection(ISelection selection) {
        Object[] values;
        Object object;
        IStructuredSelection structuredSelection;
        ExtendedPropertySheetEntry entry = null;
        this.objectsToSelect.clear();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (object = structuredSelection.getFirstElement()) instanceof ExtendedPropertySheetEntry && (values = (entry = (ExtendedPropertySheetEntry)((Object)object)).getValues()) != null) {
            int i = 0;
            while (i < values.length) {
                Object value = values[i];
                if (value instanceof IItemPropertySource) {
                    Object realValue = ((IItemPropertySource)value).getEditableValue(null);
                    if (realValue instanceof Collection) {
                        for (Object o : (Collection)realValue) {
                            this.addObjectToSelect(o);
                        }
                    } else {
                        this.addObjectToSelect(realValue);
                    }
                }
                ++i;
            }
        }
        this.locateValueAction.setEnabled(!this.objectsToSelect.isEmpty());
        if (this.restoreValueAction == null || entry == null) {
            super.handleEntrySelection(selection);
        } else {
            this.restoreValueAction.setEnabled(entry.isRestoreValueEnabled());
        }
        if (this.setValueAction != null) {
            this.setValueAction.setEntry(entry);
        }
    }

    protected void addObjectToSelect(Object object) {
        if (object instanceof EObject) {
            this.objectsToSelect.add(object);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.input = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toList() : Collections.emptyList();
        super.selectionChanged(part, selection);
        if (this.autoExpandLevel != 0) {
            Tree tree = (Tree)this.getControl();
            try {
                tree.setRedraw(false);
                this.expand(tree, tree.getItems(), this.autoExpandLevel);
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }

    private void expand(Tree tree, TreeItem[] items, int level) {
        if (level != 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                Event event = new Event();
                event.item = treeItem;
                if (!treeItem.getExpanded()) {
                    tree.notifyListeners(17, event);
                    treeItem.setExpanded(true);
                }
                this.expand(tree, treeItem.getItems(), level - 1);
                ++n2;
            }
        }
    }

    public List<?> getInput() {
        return this.input;
    }

    public void dispose() {
        if (this.diagnosticDecorator != null) {
            this.diagnosticDecorator.dispose();
        }
        super.dispose();
    }

    public void refreshLabels() {
        try {
            Field viewerField = PropertySheetPage.class.getDeclaredField("viewer");
            viewerField.setAccessible(true);
            Viewer viewer = (Viewer)viewerField.get((Object)this);
            viewer.refresh();
            if (this.columnResizer != null) {
                this.columnResizer.resizeColumns();
            }
            return;
        }
        catch (Throwable throwable) {
            this.refresh();
            return;
        }
    }

    public void refresh() {
        Control control = this.getControl();
        Control focusControl = control.getDisplay().getFocusControl();
        if (focusControl != null && focusControl != control) {
            Composite parent = focusControl.getParent();
            while (parent != null) {
                if (parent == control) {
                    if (this.autoResizeColumns) {
                        this.columnResizer.resizeColumns();
                    }
                    return;
                }
                parent = parent.getParent();
            }
        }
        if (this.setValueAction.entry != null && this.setValueAction.entry.editor != null && this.setValueAction.entry.editor.getControl() != null && !this.setValueAction.entry.editor.getControl().isDisposed() && this.setValueAction.entry.editor.getControl().isFocusControl()) {
            if (this.columnResizer != null) {
                this.columnResizer.resizeColumns();
            }
            return;
        }
        super.refresh();
        if (this.columnResizer != null) {
            this.columnResizer.resizeColumns();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Decoration {
        NONE,
        MANUAL,
        LIVE;

    }

    public static class ExtendedPropertySheetEntry
    extends PropertySheetEntry {
        protected DiagnosticDecorator diagnosticDecorator;
        protected CellEditor editor;

        public ExtendedPropertySheetEntry(DiagnosticDecorator diagnosticDecorator) {
            this.diagnosticDecorator = diagnosticDecorator;
        }

        protected PropertySheetEntry createChildEntry() {
            return new ExtendedPropertySheetEntry(this.diagnosticDecorator);
        }

        public boolean isRestoreValueEnabled() {
            PropertySheetEntry parent = this.getParent();
            if (parent != null) {
                Object[] objects = parent.getValues();
                IPropertyDescriptor descriptor = this.getDescriptor();
                Object id = descriptor.getId();
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    IPropertySource source = this.getPropertySource(object);
                    IPropertyDescriptor[] iPropertyDescriptorArray = source.getPropertyDescriptors();
                    int n3 = iPropertyDescriptorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPropertyDescriptor propertyDescriptor = iPropertyDescriptorArray[n4];
                        if (id.equals(propertyDescriptor.getId())) {
                            if (!source.isPropertySet(id) || source instanceof IPropertySource2 && !((IPropertySource2)source).isPropertyResettable(id)) break;
                            return true;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public boolean isSetValueEnabled() {
            PropertySheetEntry parent = this.getParent();
            if (parent != null) {
                Object[] objects = parent.getValues();
                IPropertyDescriptor descriptor = this.getDescriptor();
                Object id = descriptor.getId();
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    IPropertySource source = this.getPropertySource(object);
                    IPropertyDescriptor[] iPropertyDescriptorArray = source.getPropertyDescriptors();
                    int n3 = iPropertyDescriptorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPropertyDescriptor propertyDescriptor = iPropertyDescriptorArray[n4];
                        if (id.equals(propertyDescriptor.getId())) {
                            if (source.isPropertySet(id) || !(source instanceof IUnsettablePropertySource) || !((IUnsettablePropertySource)source).isPropertyUnsettable(id)) break;
                            return true;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public void setPropertyValue() {
            PropertySheetEntry parent = this.getParent();
            if (parent != null) {
                boolean change = false;
                Object[] objects = parent.getValues();
                IPropertyDescriptor descriptor = this.getDescriptor();
                Object id = descriptor.getId();
                int i = 0;
                while (i < objects.length) {
                    Object object = objects[i];
                    IPropertySource source = this.getPropertySource(object);
                    Object value = this.getEditValue(i);
                    source.setPropertyValue(id, value);
                    change = true;
                    ++i;
                }
                if (change) {
                    this.refreshFromRoot();
                }
            }
        }

        public Image getImage() {
            Diagnostic featureDiagnostic;
            Image image = super.getImage();
            if (image == null) {
                image = ExtendedImageRegistry.INSTANCE.getImage(ItemPropertyDescriptor.GENERIC_VALUE_IMAGE);
            }
            return (featureDiagnostic = this.findDiagnostic()) != null ? this.diagnosticDecorator.decorate(image, featureDiagnostic) : image;
        }

        protected Diagnostic findDiagnostic() {
            IPropertyDescriptor descriptor;
            if (this.diagnosticDecorator != null && (descriptor = this.getDescriptor()) instanceof PropertyDescriptor) {
                Object feature = ((PropertyDescriptor)descriptor).getFeature();
                Map<Object, ? extends Diagnostic> decorations = this.diagnosticDecorator.getDecorations();
                if (!decorations.isEmpty() && feature != null) {
                    for (Diagnostic diagnostic : decorations.values()) {
                        Diagnostic featureDiagnostic = this.find(diagnostic, feature);
                        if (featureDiagnostic == null) continue;
                        return featureDiagnostic;
                    }
                }
            }
            return null;
        }

        protected Diagnostic find(Diagnostic diagnostic, Object feature) {
            if (diagnostic.getData().contains(feature)) {
                return diagnostic;
            }
            for (Diagnostic child : diagnostic.getChildren()) {
                Diagnostic result = this.find(child, feature);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public String getDescription() {
            String description = super.getDescription();
            Diagnostic featureDiagnostic = this.findDiagnostic();
            if (featureDiagnostic != null) {
                List children = featureDiagnostic.getChildren();
                if (!children.isEmpty()) {
                    return String.valueOf(description) + " - " + DiagnosticDecorator.strip(((Diagnostic)children.get(0)).getMessage());
                }
                return String.valueOf(description) + " - " + DiagnosticDecorator.strip(featureDiagnostic.getMessage());
            }
            return description;
        }

        public CellEditor getEditor(Composite parent) {
            TreeItem[] selection;
            this.editor = null;
            Tree tree = (Tree)parent;
            TreeItem[] treeItemArray = selection = tree.getSelection();
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                if (treeItem.getData() == this) {
                    this.editor = super.getEditor(parent);
                    break;
                }
                ++n2;
            }
            return this.editor;
        }

        public void setValues(Object[] objects) {
            this.editor = null;
            super.setValues(objects);
        }

        public void applyEditorValue() {
            if (this.editor != null && this.editor.isDirty()) {
                super.applyEditorValue();
            }
        }
    }

    public static interface IUnsettablePropertySource
    extends IPropertySource2 {
        public boolean isPropertyUnsettable(Object var1);
    }

    protected class LocateValueAction
    extends Action {
        public LocateValueAction() {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_LocateValue_action"));
            this.setToolTipText(EMFEditUIPlugin.INSTANCE.getString("_UI_LocateValue_action_tool_tip"));
            this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage("full/elcl16/LocateValue")));
            this.setDisabledImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage("full/dlcl16/LocateValue")));
        }

        public void run() {
            ArrayList<Object> selection = new ArrayList<Object>();
            for (Object object : ExtendedPropertySheetPage.this.objectsToSelect) {
                selection.add(ExtendedPropertySheetPage.this.editingDomain.getWrapper(object));
            }
            ExtendedPropertySheetPage.this.setSelectionToViewer(selection);
        }
    }

    protected static class SetValueAction
    extends Action {
        protected ExtendedPropertySheetEntry entry;

        public SetValueAction() {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_SetValue_action"));
            this.setToolTipText(EMFEditUIPlugin.INSTANCE.getString("_UI_SetValue_action_tool_tip"));
            this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage("full/elcl16/SetProperty.png")));
            this.setDisabledImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage("full/dlcl16/SetProperty.png")));
        }

        public void run() {
            this.entry.setPropertyValue();
        }

        public void setEntry(ExtendedPropertySheetEntry entry) {
            this.entry = entry;
            this.setEnabled(entry != null && entry.isSetValueEnabled());
        }
    }
}

