/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.editor.UMLEditorPlugin;
import org.eclipse.uml2.uml.editor.actions.UMLCommandAction;
import org.eclipse.uml2.uml.editor.dialogs.AbstractChoicesDialogDelegate;
import org.eclipse.uml2.uml.editor.dialogs.ChoicesDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnapplyStereotypeAction
extends UMLCommandAction {
    protected Command createActionCommand(EditingDomain editingDomain, Collection<?> collection) {
        if (collection.size() == 1 && collection.iterator().next() instanceof Element) {
            return IdentityCommand.INSTANCE;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void run(IAction action) {
        if (this.command != UnexecutableCommand.INSTANCE) {
            final Element element = (Element)this.collection.iterator().next();
            final ArrayList<Stereotype> choiceOfValues = new ArrayList<Stereotype>();
            for (Stereotype appliedStereotype : element.getAppliedStereotypes()) {
                choiceOfValues.add(appliedStereotype);
            }
            Collections.sort(choiceOfValues, new UMLCommandAction.TextComparator(this));
            String label = UMLEditorPlugin.INSTANCE.getString("_UI_UnapplyStereotypeActionCommand_label");
            final ChoicesDialog<Stereotype> dialog = new ChoicesDialog<Stereotype>(this.workbenchPart.getSite().getShell(), element, label, new AbstractChoicesDialogDelegate<Stereotype>(Stereotype.class){

                @Override
                public String getChoicesLabelText() {
                    return UMLEditorPlugin.INSTANCE.getString("_UI_AppliedStereotypes_label");
                }

                @Override
                public String getValuesLabelText() {
                    return UMLEditorPlugin.INSTANCE.getString("_UI_StereotypesToUnapply_label");
                }

                @Override
                public String getAddButtonText() {
                    return UMLEditorPlugin.INSTANCE.getString("_UI_Unapply_label");
                }

                @Override
                public String getRemoveButtonText() {
                    return UMLEditorPlugin.INSTANCE.getString("_UI_Apply_label");
                }

                @Override
                public ILabelProvider getLabelProvider() {
                    return UnapplyStereotypeAction.this.getLabelProvider();
                }

                @Override
                public ILabelProvider createLabelProvider(Viewer viewer) {
                    return new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider(UnapplyStereotypeAction.this.getAdapterFactory(), viewer){

                        public StyledString getStyledText(Object object) {
                            StyledString result = super.getStyledText(object);
                            if (object instanceof Stereotype && element.isStereotypeRequired((Stereotype)object)) {
                                result.append(" (required)", StyledString.QUALIFIER_STYLER);
                            }
                            return result;
                        }
                    });
                }

                @Override
                public Collection<Stereotype> getChoiceOfValues() {
                    return choiceOfValues;
                }

                @Override
                public boolean allowsReordering() {
                    return false;
                }

                @Override
                public boolean canAdd(IStructuredSelection selection, Collection<Stereotype> values) {
                    boolean result = true;
                    for (Object next : selection.toList()) {
                        if (!element.isStereotypeRequired((Stereotype)next)) continue;
                        result = false;
                        break;
                    }
                    return result;
                }
            });
            dialog.open();
            if (dialog.getReturnCode() == 0 && !dialog.getResult().isEmpty()) {
                this.editingDomain.getCommandStack().execute((Command)new UMLCommandAction.RefreshingChangeCommand(this, this.editingDomain, new Runnable(){

                    public void run() {
                        for (Stereotype result : dialog.getResult()) {
                            element.unapplyStereotype(result);
                        }
                    }
                }, label));
            }
        }
    }
}

