/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ObjectNodeOrderingKind implements Enumerator
{
    UNORDERED_LITERAL(0, "unordered", "unordered"),
    ORDERED_LITERAL(1, "ordered", "ordered"),
    LIFO_LITERAL(2, "LIFO", "LIFO"),
    FIFO_LITERAL(3, "FIFO", "FIFO");

    public static final int UNORDERED = 0;
    public static final int ORDERED = 1;
    public static final int LIFO = 2;
    public static final int FIFO = 3;
    private static final ObjectNodeOrderingKind[] VALUES_ARRAY;
    public static final List<ObjectNodeOrderingKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ObjectNodeOrderingKind[]{UNORDERED_LITERAL, ORDERED_LITERAL, LIFO_LITERAL, FIFO_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ObjectNodeOrderingKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectNodeOrderingKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectNodeOrderingKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectNodeOrderingKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectNodeOrderingKind get(int value) {
        switch (value) {
            case 0: {
                return UNORDERED_LITERAL;
            }
            case 1: {
                return ORDERED_LITERAL;
            }
            case 2: {
                return LIFO_LITERAL;
            }
            case 3: {
                return FIFO_LITERAL;
            }
        }
        return null;
    }

    private ObjectNodeOrderingKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

