/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.properties.ui.providers.CreateInFeatureContentProvider;
import org.eclipse.papyrus.infra.properties.ui.providers.FeatureContentProvider;
import org.eclipse.papyrus.infra.properties.ui.widgets.layout.PropertiesLayout;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrus.uml.properties.messages.Messages;
import org.eclipse.papyrus.uml.properties.widgets.EStructuralFeatureEditor;
import org.eclipse.papyrus.uml.tools.providers.UMLContainerContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class EObjectContentsEditor
extends Composite {
    protected Composite contents;
    protected Composite buttonsBar;
    protected EReference reference;
    protected IObservableValue modelElementObservable;
    protected Button addButton;
    protected Button deleteButton;
    protected IChangeListener valueListener;
    protected Composite self;
    private final ScrolledComposite scrolled;
    private final MouseWheelListener mouseWheelListener = new MouseWheelListener(){

        public void mouseScrolled(MouseEvent e) {
            Point or = EObjectContentsEditor.this.scrolled.getOrigin();
            or.y += -e.count * EObjectContentsEditor.this.scrolled.getVerticalBar().getIncrement();
            EObjectContentsEditor.this.scrolled.setOrigin(or);
        }
    };

    public EObjectContentsEditor(Composite parent, int style, EReference reference) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.self = new Group((Composite)this, 0);
        StringBuilder builder = new StringBuilder();
        if (reference != null) {
            builder.append(reference.getName());
            builder.append(":");
            if (reference.getEType() != null) {
                builder.append(reference.getEType().getName());
            }
        }
        ((Group)this.self).setText(builder.toString());
        this.self.setLayout((Layout)new PropertiesLayout());
        this.buttonsBar = new Composite(this.self, 0);
        this.buttonsBar.setLayout((Layout)new FillLayout());
        this.buttonsBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.createAddButton();
        this.createDeleteButton();
        this.updateButtonsBar();
        this.scrolled = new ScrolledComposite(this.self, 512);
        this.scrolled.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolled.setLayout((Layout)new PropertiesLayout());
        this.scrolled.setExpandHorizontal(true);
        this.scrolled.setExpandVertical(true);
        this.scrolled.setMinSize(250, 100);
        this.contents = new Composite((Composite)this.scrolled, 0);
        this.contents.setLayout((Layout)new PropertiesLayout());
        this.contents.setLayoutData((Object)new GridData(4, 4, true, true));
        this.contents.setBackgroundMode(1);
        this.contents.setBackground(this.self.getBackground());
        this.scrolled.setContent((Control)this.contents);
        this.reference = reference;
        this.valueListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                EObjectContentsEditor.this.updateContents();
            }
        };
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EObjectContentsEditor.this.dispose();
            }
        });
    }

    public void setValue(IObservableValue observable) {
        if (this.modelElementObservable != null) {
            this.modelElementObservable.removeChangeListener(this.valueListener);
        }
        this.modelElementObservable = observable;
        this.modelElementObservable.addChangeListener(this.valueListener);
        this.updateContents();
    }

    public void dispose() {
        if (this.modelElementObservable != null) {
            this.modelElementObservable.removeChangeListener(this.valueListener);
        }
    }

    protected void updateContents() {
        EObject dataTypeInstance = (EObject)this.modelElementObservable.getValue();
        this.unregisteredMouseWheelListener((Control)this.scrolled);
        Control[] controlArray = this.contents.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (dataTypeInstance != null) {
            UMLLabelProvider labelProvider;
            EClass dataTypeDefinition = dataTypeInstance.eClass();
            try {
                labelProvider = dataTypeInstance.eResource() == null && dataTypeDefinition.eResource() != null ? ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)dataTypeDefinition)).getLabelProvider() : ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)dataTypeInstance)).getLabelProvider();
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
                labelProvider = new UMLLabelProvider();
            }
            for (EStructuralFeature feature : dataTypeDefinition.getEAllStructuralFeatures()) {
                EStructuralFeatureEditor propertyEditor = new EStructuralFeatureEditor(this.contents, 0);
                if (dataTypeInstance.eResource() == null && dataTypeDefinition.eResource() != null) {
                    propertyEditor.setProviders((IStaticContentProvider)new UMLContentProvider(dataTypeInstance, feature, null, dataTypeDefinition.eResource().getResourceSet()), (ILabelProvider)labelProvider);
                } else {
                    propertyEditor.setProviders((IStaticContentProvider)new UMLContentProvider(dataTypeInstance, feature), (ILabelProvider)labelProvider);
                }
                if (feature instanceof EReference) {
                    propertyEditor.setValueFactory((ReferenceValueFactory)this.getUMLPropertyEditorFactory(dataTypeInstance, (EReference)feature));
                }
                propertyEditor.setFeatureToEdit(feature.getName(), feature, null, dataTypeInstance);
            }
        }
        this.scrolled.setMinSize(this.contents.computeSize(-1, -1));
        this.registerMouseWheelListener((Control)this.scrolled);
        this.updateButtonsBar();
        this.layout();
    }

    private void registerMouseWheelListener(Control control) {
        control.addMouseWheelListener(this.mouseWheelListener);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control ctrl = controlArray[n2];
                this.registerMouseWheelListener(ctrl);
                ++n2;
            }
        }
    }

    private void unregisteredMouseWheelListener(Control control) {
        control.removeMouseWheelListener(this.mouseWheelListener);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control ctrl = controlArray[n2];
                this.unregisteredMouseWheelListener(ctrl);
                ++n2;
            }
        }
    }

    public void layout() {
        this.contents.layout();
        this.self.layout();
        super.layout();
        this.getParent().layout();
    }

    protected void createAddButton() {
        this.addButton = new Button(this.buttonsBar, 8);
        this.addButton.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("icons/Add_12x12.gif"));
        this.addButton.setToolTipText(Messages.EObjectContentsEditor_CreateElement);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EObjectContentsEditor.this.addAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void addAction() {
        EClassifier classifier = this.reference.getEType();
        if (classifier instanceof EClass) {
            EClass classToInstantiate = (EClass)classifier;
            classToInstantiate.isAbstract();
            EPackage ePackage = classToInstantiate.getEPackage();
            EObject value = ePackage.getEFactoryInstance().create(classToInstantiate);
            this.modelElementObservable.setValue((Object)value);
        }
    }

    protected void createDeleteButton() {
        this.deleteButton = new Button(this.buttonsBar, 8);
        this.deleteButton.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("icons/Delete_12x12.gif"));
        this.deleteButton.setToolTipText(Messages.EObjectContentsEditor_UnsetValue);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EObjectContentsEditor.this.deleteAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void deleteAction() {
        this.modelElementObservable.setValue(null);
    }

    protected void updateButtonsBar() {
        this.deleteButton.setEnabled(this.modelElementObservable != null && this.modelElementObservable.getValue() != null);
    }

    protected UMLPropertyEditorFactory getUMLPropertyEditorFactory(EObject dataTypeInstance, EReference reference) {
        ResourceSet resourceSet;
        UMLPropertyEditorFactory factory = new UMLPropertyEditorFactory(reference);
        EClass type = reference.getEReferenceType();
        factory.setContainerLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
        factory.setReferenceLabelProvider((ILabelProvider)new EMFLabelProvider());
        Resource res = dataTypeInstance.eResource() != null ? dataTypeInstance.eResource() : null;
        ResourceSet resourceSet2 = resourceSet = res != null ? res.getResourceSet() : null;
        if (resourceSet == null && dataTypeInstance.eClass().eResource() != null) {
            resourceSet = dataTypeInstance.eClass().eResource().getResourceSet();
        }
        UMLContainerContentProvider contentProvider = dataTypeInstance.eResource() != null ? new UMLContainerContentProvider(dataTypeInstance, reference) : new UMLContainerContentProvider(dataTypeInstance, reference, resourceSet);
        EMFGraphicalContentProvider provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)contentProvider, (ResourceSet)resourceSet, (String)HistoryUtil.getHistoryID((EObject)dataTypeInstance, (EStructuralFeature)reference, (String)"container"));
        factory.setContainerContentProvider((IStaticContentProvider)provider);
        factory.setReferenceContentProvider((CreateInFeatureContentProvider)new FeatureContentProvider(type));
        return factory;
    }
}

