/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.RobotML.DeploymentPlan;
import org.eclipse.papyrus.RobotML.Environment;
import org.eclipse.papyrus.robotml.deployment.CommandSupport;
import org.eclipse.papyrus.robotml.deployment.DepCreation;
import org.eclipse.papyrus.robotml.deployment.DepPlanSync;
import org.eclipse.papyrus.robotml.deployment.DepPlanUtils;
import org.eclipse.papyrus.robotml.deployment.RunnableWithResult;
import org.eclipse.papyrus.robotml.deployment.StUtils;
import org.eclipse.papyrus.robotml.deployment.TransformationException;
import org.eclipse.papyrus.robotml.deployment.handlers.CmdHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CreateDepPlanHandler
extends CmdHandler {
    private final String DepPlanPostfix = "DepPlan";
    private Package depPlans;

    public boolean isEnabled() {
        this.updateSelectedEObject();
        EObject selectedObj = this.getSelectedEObject();
        return selectedObj instanceof Class && this.isEnvironment((Class)selectedObj);
    }

    private boolean isEnvironment(Class elt) {
        Environment environment = (Environment)UMLUtil.getStereotypeApplication((Element)elt, Environment.class);
        return environment != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(ExecutionEvent event) {
        if (!(this.getSelectedEObject() instanceof Class)) {
            return null;
        }
        final Class selectedComposite = (Class)this.getSelectedEObject();
        CommandSupport.exec("Create deployment plans", event, new Runnable(){

            @Override
            public void run() {
                CreateDepPlanHandler.this.depPlans = DepPlanUtils.getDepPlanRoot((Element)selectedComposite);
            }
        });
        try {
            String name = String.valueOf(selectedComposite.getName()) + "DepPlan";
            if (this.depPlans.getMember(name) != null) {
                Shell shell = new Shell();
                String[] dialogButtonLabels = new String[]{"Cancel", "Synchronize", "create new (auto number name)"};
                MessageDialog dialog = new MessageDialog(shell, "What should I do?", null, "Deployment plan with name \"" + name + "\" exists already. You can always synchronize an " + "existing deployment plan via the context menu \"Synchronize derived elements\"", 3, dialogButtonLabels, 0);
                int result = dialog.open();
                if (result == 0) {
                    return null;
                }
                if (result == 1) {
                    NamedElement existing = this.depPlans.getMember(name);
                    if (existing instanceof Package) {
                        DepPlanSync.syncDepPlan((Package)existing);
                    } else {
                        MessageDialog.openError((Shell)shell, (String)"Cannot synchronize", (String)("Element with name \"" + name + "\" exists, but is not a package"));
                    }
                } else {
                    int i = 2;
                    while (this.depPlans.getMember(name = String.valueOf(selectedComposite.getName()) + "DepPlan" + i) != null) {
                        ++i;
                    }
                }
            }
            final String depPlanName = name;
            CommandSupport.exec("Create deployment plan", event, new RunnableWithResult(){

                @Override
                public CommandResult run() {
                    Package cdp = CreateDepPlanHandler.this.depPlans.createNestedPackage(depPlanName);
                    Stereotype st = StUtils.apply((Element)cdp, DeploymentPlan.class);
                    if (st == null) {
                        MessageDialog.openInformation((Shell)new Shell(), (String)"Cannot create deployment plan", (String)"Application of stereotype \"RobotML::DeploymentPlan\" failed. Check, if RobotML profile is applied");
                        return CommandResult.newErrorCommandResult((String)"cannot create deployment plan");
                    }
                    try {
                        InstanceSpecification newRootIS = DepCreation.createDepPlan(cdp, selectedComposite, "mainInstance", true);
                        DepCreation.initAutoValues(newRootIS);
                        return CommandResult.newOKCommandResult();
                    }
                    catch (TransformationException e) {
                        MessageDialog.openInformation((Shell)new Shell(), (String)"Error during deployment plan creation", (String)e.getMessage());
                        return CommandResult.newErrorCommandResult((String)e.getMessage());
                    }
                }
            });
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

