/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.edges;

import java.util.Collection;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.edges.IDomainBasedEdgeInitializer;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ActivityEdgeHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ClassifierUtils;
import org.eclipse.papyrus.uml.domain.services.labels.ElementDefaultNameProvider;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.DeployedArtifact;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.DeploymentTarget;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.ExtensionPoint;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDomainBasedEdgeInitializer
implements IDomainBasedEdgeInitializer {
    public static final String EXTENSION = "extension_";
    public static final String BASE = "base_";
    public static final String UML_NATURE = "UML_Nature";
    private static final String PAPYRUS_URI = "org.eclipse.papyrus";
    private static final String PAPYRUS_ELEMENT_NATURE = "nature";

    @Override
    public EObject initialize(EObject toInit, EObject source, EObject target, IViewQuerier representationQuery, Object sourceView, Object targetView) {
        if (toInit == null) {
            return null;
        }
        new ElementEdgeInitializerSwitch(source, target, representationQuery, sourceView, targetView).doSwitch(toInit);
        return toInit;
    }

    static class ElementEdgeInitializerSwitch
    extends UMLSwitch<EObject> {
        private final EObject source;
        private final EObject target;
        private final Object sourceView;
        private final Object targetView;
        private final IViewQuerier representationQuery;

        ElementEdgeInitializerSwitch(EObject source, EObject target, IViewQuerier representationQuery, Object sourceView, Object targetView) {
            this.source = source;
            this.target = target;
            this.sourceView = sourceView;
            this.targetView = targetView;
            this.representationQuery = representationQuery;
        }

        public EObject caseAssociation(Association association) {
            EMap details = UML2Util.getEAnnotation((EModelElement)association, (String)ElementDomainBasedEdgeInitializer.PAPYRUS_URI, (boolean)true).getDetails();
            if (!details.containsKey((Object)ElementDomainBasedEdgeInitializer.PAPYRUS_ELEMENT_NATURE)) {
                details.put((Object)ElementDomainBasedEdgeInitializer.PAPYRUS_ELEMENT_NATURE, (Object)ElementDomainBasedEdgeInitializer.UML_NATURE);
            } else {
                details.removeKey((Object)ElementDomainBasedEdgeInitializer.PAPYRUS_ELEMENT_NATURE);
                details.put((Object)ElementDomainBasedEdgeInitializer.PAPYRUS_ELEMENT_NATURE, (Object)ElementDomainBasedEdgeInitializer.UML_NATURE);
            }
            Classifier sourceClassifier = (Classifier)this.source;
            Classifier targetClassifier = (Classifier)this.target;
            Property sourceProp = UMLFactory.eINSTANCE.createProperty();
            sourceProp.setType((Type)targetClassifier);
            if (targetClassifier.getName() != null) {
                sourceProp.setName(targetClassifier.getName().toLowerCase());
            }
            association.getMemberEnds().add((Object)sourceProp);
            Property targetProp = UMLFactory.eINSTANCE.createProperty();
            targetProp.setType((Type)sourceClassifier);
            if (sourceClassifier.getName() != null) {
                targetProp.setName(sourceClassifier.getName().toLowerCase());
            }
            association.getMemberEnds().add((Object)targetProp);
            boolean added = ClassifierUtils.addOwnedAttribute(sourceClassifier, sourceProp);
            if (!added) {
                association.getOwnedEnds().add((Object)sourceProp);
            }
            sourceProp.setIsNavigable(false);
            added = ClassifierUtils.addOwnedAttribute(targetClassifier, targetProp);
            if (!added) {
                association.getOwnedEnds().add((Object)targetProp);
            }
            targetProp.setIsNavigable(false);
            targetProp.setOwningAssociation(association);
            return association;
        }

        public EObject caseComponentRealization(ComponentRealization componentRealization) {
            if (this.source instanceof Classifier) {
                componentRealization.getRealizingClassifiers().add((Object)((Classifier)this.source));
            }
            if (this.target instanceof Component) {
                componentRealization.setAbstraction((Component)this.target);
            }
            return (EObject)super.caseComponentRealization(componentRealization);
        }

        public EObject caseConnector(Connector connector) {
            EObject visualTargetParent;
            Object targetVisualParent;
            EObject visualSourceSementicParent;
            Object sourceVisualParent;
            ConnectorEnd sourceEnd = UMLFactory.eINSTANCE.createConnectorEnd();
            if (this.source instanceof ConnectableElement) {
                sourceEnd.setRole((ConnectableElement)this.source);
                connector.getEnds().add((Object)sourceEnd);
            }
            if ((sourceVisualParent = this.representationQuery.getVisualParent(this.sourceView)) != null && (visualSourceSementicParent = this.representationQuery.getSemanticElement(sourceVisualParent)) instanceof Property) {
                Property sourceProperty = (Property)visualSourceSementicParent;
                ((ConnectorEnd)connector.getEnds().get(0)).setPartWithPort(sourceProperty);
            }
            ConnectorEnd targetEnd = UMLFactory.eINSTANCE.createConnectorEnd();
            if (this.target instanceof ConnectableElement) {
                targetEnd.setRole((ConnectableElement)this.target);
                connector.getEnds().add((Object)targetEnd);
            }
            if ((targetVisualParent = this.representationQuery.getVisualParent(this.targetView)) != null && (visualTargetParent = this.representationQuery.getSemanticElement(targetVisualParent)) instanceof Property) {
                Property targetProperty = (Property)visualTargetParent;
                ((ConnectorEnd)connector.getEnds().get(1)).setPartWithPort(targetProperty);
            }
            return (EObject)super.caseConnector(connector);
        }

        public EObject caseControlFlow(ControlFlow controlFlow) {
            if (this.source instanceof ActivityNode) {
                controlFlow.setSource((ActivityNode)this.source);
            }
            if (this.target instanceof ActivityNode) {
                controlFlow.setTarget((ActivityNode)this.target);
            }
            new ActivityEdgeHelper().setInPartition((ActivityEdge)controlFlow);
            return controlFlow;
        }

        public EObject caseDependency(Dependency dependency) {
            if (this.source instanceof NamedElement) {
                dependency.getClients().add((Object)((NamedElement)this.source));
            }
            if (this.target instanceof NamedElement) {
                dependency.getSuppliers().add((Object)((NamedElement)this.target));
            }
            return (EObject)super.caseDependency(dependency);
        }

        public EObject caseDeployment(Deployment deployment) {
            if (this.source instanceof DeployedArtifact) {
                deployment.getDeployedArtifacts().add((Object)((DeployedArtifact)this.source));
            }
            if (this.target instanceof DeploymentTarget) {
                deployment.setLocation((DeploymentTarget)this.target);
            }
            return deployment;
        }

        /*
         * WARNING - void declaration
         */
        public EObject caseElementImport(ElementImport elementImport) {
            EObject eObject;
            EObject eObject2 = this.source;
            if (eObject2 instanceof Namespace) {
                void namespace;
                Namespace namespace2 = (Namespace)eObject2;
                Namespace cfr_ignored_0 = (Namespace)eObject2;
                elementImport.setImportingNamespace((Namespace)namespace);
            }
            if ((eObject = this.target) instanceof PackageableElement) {
                void packageableElement;
                PackageableElement packageableElement2 = (PackageableElement)eObject;
                PackageableElement cfr_ignored_1 = (PackageableElement)eObject;
                elementImport.setImportedElement((PackageableElement)packageableElement);
            }
            return elementImport;
        }

        public EObject caseExtend(Extend extend) {
            if (this.source instanceof UseCase) {
                extend.setExtension((UseCase)this.source);
            }
            if (this.target instanceof UseCase) {
                ExtensionPoint targetExtensionpoint = UMLFactory.eINSTANCE.createExtensionPoint();
                extend.getExtensionLocations().add((Object)targetExtensionpoint);
                ((UseCase)this.target).getExtensionPoints().add((Object)targetExtensionpoint);
                extend.setExtendedCase((UseCase)this.target);
            }
            return extend;
        }

        public EObject caseExtension(Extension extension) {
            ExtensionEnd endSource = UMLFactory.eINSTANCE.createExtensionEnd();
            endSource.setName(ElementDomainBasedEdgeInitializer.EXTENSION + ((NamedElement)this.source).getName());
            endSource.setType((Type)this.source);
            endSource.setAggregation(AggregationKind.COMPOSITE_LITERAL);
            extension.getOwnedEnds().add((Object)endSource);
            Property property = UMLFactory.eINSTANCE.createProperty();
            property.setName(ElementDomainBasedEdgeInitializer.BASE + ((NamedElement)this.target).getName());
            property.setType((Type)this.target);
            property.setAssociation((Association)extension);
            property.setAggregation(AggregationKind.NONE_LITERAL);
            property.setLower(0);
            extension.getMemberEnds().add((Object)property);
            ((Stereotype)this.source).getOwnedAttributes().add((Object)property);
            return extension;
        }

        public EObject caseGeneralization(Generalization generalization) {
            if (this.source instanceof Classifier) {
                generalization.setSpecific((Classifier)this.source);
            }
            if (this.target instanceof Classifier) {
                generalization.setGeneral((Classifier)this.target);
            }
            return (EObject)super.caseGeneralization(generalization);
        }

        public EObject caseInclude(Include include) {
            if (this.source instanceof UseCase) {
                include.setIncludingCase((UseCase)this.source);
            }
            if (this.target instanceof UseCase) {
                include.setAddition((UseCase)this.target);
            }
            return (EObject)super.caseInclude(include);
        }

        public EObject caseInformationFlow(InformationFlow informationFlow) {
            if (this.source instanceof NamedElement) {
                informationFlow.getInformationSources().add((Object)((NamedElement)this.source));
            }
            if (this.target instanceof NamedElement) {
                informationFlow.getInformationTargets().add((Object)((NamedElement)this.target));
            }
            return (EObject)super.caseInformationFlow(informationFlow);
        }

        public EObject caseInterfaceRealization(InterfaceRealization interfaceRealization) {
            if (this.source instanceof BehavioredClassifier) {
                interfaceRealization.setImplementingClassifier((BehavioredClassifier)this.source);
            }
            if (this.target instanceof Interface) {
                interfaceRealization.setContract((Interface)this.target);
            }
            return (EObject)super.caseInterfaceRealization(interfaceRealization);
        }

        public EObject caseManifestation(Manifestation manifestation) {
            if (this.source instanceof NamedElement) {
                manifestation.getClients().add((Object)((NamedElement)this.source));
            }
            if (this.target instanceof PackageableElement) {
                manifestation.setUtilizedElement((PackageableElement)this.target);
            }
            return manifestation;
        }

        /*
         * WARNING - void declaration
         */
        public EObject caseObjectFlow(ObjectFlow objectFlow) {
            EObject eObject;
            OutputPin outpuPin;
            EObject realSource = this.source;
            EObject realTarget = this.target;
            EObject eObject2 = this.source;
            if (eObject2 instanceof OpaqueAction) {
                void opaqueActionSource;
                OpaqueAction opaqueAction = (OpaqueAction)eObject2;
                OpaqueAction cfr_ignored_0 = (OpaqueAction)eObject2;
                outpuPin = UMLFactory.eINSTANCE.createOutputPin();
                opaqueActionSource.getOutputValues().add((Object)outpuPin);
                outpuPin.setName(new ElementDefaultNameProvider().getDefaultName((NamedElement)outpuPin, this.source));
                outpuPin.getInPartitions().addAll((Collection)opaqueActionSource.getInPartitions());
                realSource = outpuPin;
            }
            if ((eObject = this.target) instanceof OpaqueAction) {
                void opaqueActionTarget;
                outpuPin = (OpaqueAction)eObject;
                OpaqueAction cfr_ignored_1 = (OpaqueAction)eObject;
                InputPin inputPin = UMLFactory.eINSTANCE.createInputPin();
                opaqueActionTarget.getInputValues().add((Object)inputPin);
                inputPin.setName(new ElementDefaultNameProvider().getDefaultName((NamedElement)inputPin, this.target));
                inputPin.getInPartitions().addAll((Collection)opaqueActionTarget.getInPartitions());
                realTarget = inputPin;
            }
            if (realSource instanceof ActivityNode) {
                objectFlow.setSource((ActivityNode)realSource);
            }
            if (realTarget instanceof ActivityNode) {
                objectFlow.setTarget((ActivityNode)realTarget);
            }
            new ActivityEdgeHelper().setInPartition((ActivityEdge)objectFlow);
            if (objectFlow.getGuard() == null) {
                LiteralBoolean literalBoolean = UMLFactory.eINSTANCE.createLiteralBoolean();
                literalBoolean.setValue(true);
                objectFlow.setGuard((ValueSpecification)literalBoolean);
            }
            if (objectFlow.getWeight() == null) {
                LiteralInteger literalInteger = UMLFactory.eINSTANCE.createLiteralInteger();
                literalInteger.setValue(1);
                objectFlow.setWeight((ValueSpecification)literalInteger);
            }
            return objectFlow;
        }

        public EObject casePackageImport(PackageImport object) {
            if (this.source instanceof Namespace) {
                object.setImportingNamespace((Namespace)this.source);
            }
            if (this.target instanceof Package) {
                object.setImportedPackage((Package)this.target);
            }
            return (EObject)super.casePackageImport(object);
        }

        public EObject casePackageMerge(PackageMerge object) {
            if (this.source instanceof Package) {
                object.setReceivingPackage((Package)this.source);
            }
            if (this.target instanceof Package) {
                object.setMergedPackage((Package)this.target);
            }
            return (EObject)super.casePackageMerge(object);
        }

        public EObject caseSubstitution(Substitution substitution) {
            if (this.source instanceof Classifier) {
                substitution.setSubstitutingClassifier((Classifier)this.source);
            }
            if (this.target instanceof Classifier) {
                substitution.setContract((Classifier)this.target);
            }
            return substitution;
        }

        public EObject caseTransition(Transition transition) {
            if (this.source instanceof Vertex) {
                transition.setSource((Vertex)this.source);
            }
            if (this.target instanceof Vertex) {
                transition.setTarget((Vertex)this.target);
            }
            return (EObject)super.caseTransition(transition);
        }

        public EObject defaultCase(EObject object) {
            return object;
        }
    }
}

