/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class ValueSpecificationScript {
  public static CharSequence ValueSpecificationTemplate(final ValueSpecification valueSpecification) {
    StringConcatenation _builder = new StringConcatenation();
    String _stringValue = valueSpecification.stringValue();
    _builder.append(_stringValue);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static CharSequence ValueSpecificationTemplate(final InstanceValue instanceValue) {
    StringConcatenation _builder = new StringConcatenation();
    {
      InstanceSpecification _instance = instanceValue.getInstance();
      if ((_instance instanceof EnumerationLiteral)) {
        {
          EList<Slot> _slots = instanceValue.getInstance().getSlots();
          for(final Slot slot : _slots) {
            {
              EList<ValueSpecification> _values = slot.getValues();
              for(final ValueSpecification value : _values) {
                _builder.append(" ");
                CharSequence _ValueSpecificationTemplate = ValueSpecificationScript.ValueSpecificationTemplate(value);
                _builder.append(_ValueSpecificationTemplate);
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t\t\t");
          }
        }
        _builder.append("{");
        _builder.newLineIfNotEmpty();
        {
          EList<Slot> _slots_1 = instanceValue.getInstance().getSlots();
          for(final Slot slot_1 : _slots_1) {
            String _upperCase = slot_1.getDefiningFeature().getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append(" = ");
            {
              EList<ValueSpecification> _values_1 = slot_1.getValues();
              for(final ValueSpecification value_1 : _values_1) {
                _builder.append(" ");
                CharSequence _ValueSpecificationTemplate_1 = ValueSpecificationScript.ValueSpecificationTemplate(value_1);
                _builder.append(_ValueSpecificationTemplate_1);
                _builder.append(" ");
              }
            }
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("}");
        _builder.newLine();
      } else {
        String _name = instanceValue.getInstance().getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public static CharSequence ValueSpecificationTemplate(final Expression expression) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    _builder.newLine();
    return _builder;
  }
}
