/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import prefuse.util.collections.AbstractTreeMap;
import prefuse.util.collections.FloatIntSortedMap;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.LiteralComparator;
import prefuse.util.collections.LiteralIterator;

public class FloatIntTreeMap
extends AbstractTreeMap
implements FloatIntSortedMap {
    private FloatEntry dummy = new FloatEntry(Float.MIN_VALUE, Integer.MAX_VALUE, NIL, 0);

    public FloatIntTreeMap() {
        this(null, false);
    }

    public FloatIntTreeMap(boolean allowDuplicates) {
        this(null, allowDuplicates);
    }

    public FloatIntTreeMap(LiteralComparator comparator) {
        this(comparator, false);
    }

    public FloatIntTreeMap(LiteralComparator comparator, boolean allowDuplicates) {
        super(comparator, allowDuplicates);
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    public boolean containsKey(float key) {
        return this.find(key, 0) != NIL;
    }

    public int get(float key) {
        AbstractTreeMap.Entry ret = this.find(key, 0);
        return ret == NIL ? Integer.MIN_VALUE : ret.val;
    }

    public int put(float key, int value) {
        AbstractTreeMap.Entry t = this.root;
        this.lastOrder = 0;
        if (t == NIL) {
            this.incrementSize(true);
            this.root = new FloatEntry(key, value, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.dummy.key = key;
        this.dummy.order = Integer.MAX_VALUE;
        while (true) {
            int cmp;
            if ((cmp = this.compare(this.dummy, t)) == 0) {
                return t.setValue(value);
            }
            if (cmp < 0) {
                if (t.left != NIL) {
                    t = t.left;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                t.left = new FloatEntry(key, value, t, this.lastOrder);
                this.fixUpInsert(t.left);
                return Integer.MIN_VALUE;
            }
            if (t.right == NIL) break;
            t = t.right;
        }
        this.incrementSize(this.lastOrder == 0);
        t.right = new FloatEntry(key, value, t, this.lastOrder);
        this.fixUpInsert(t.right);
        return Integer.MIN_VALUE;
    }

    public int remove(float key) {
        AbstractTreeMap.Entry x = this.allowDuplicates ? this.findPredecessor(key, Integer.MAX_VALUE) : this.find(key, 0);
        if (x == NIL) {
            return Integer.MIN_VALUE;
        }
        int val = x.val;
        this.remove(x);
        return val;
    }

    /*
     * Unable to fully structure code
     */
    public int remove(float key, int val) {
        x = this.findCeiling(key, 0);
        if (x != FloatIntTreeMap.NIL && x.getFloatKey() != key) {
            x = this.successor(x);
        }
        if (x != FloatIntTreeMap.NIL && x.getFloatKey() == key) ** GOTO lbl7
        return -2147483648;
lbl-1000:
        // 1 sources

        {
            x = this.successor(x);
lbl7:
            // 2 sources

            ** while (x.val != val && x != FloatIntTreeMap.NIL)
        }
lbl8:
        // 1 sources

        if (x == FloatIntTreeMap.NIL) {
            return -2147483648;
        }
        this.remove(x);
        return val;
    }

    public float firstKey() {
        return this.minimum(this.root).getFloatKey();
    }

    public float lastKey() {
        return this.maximum(this.root).getFloatKey();
    }

    public LiteralIterator keyIterator() {
        return new KeyIterator();
    }

    public LiteralIterator keyRangeIterator(float fromKey, boolean fromInc, float toKey, boolean toInc) {
        AbstractTreeMap.Entry end;
        AbstractTreeMap.Entry start;
        if (this.cmp.compare(fromKey, toKey) <= 0) {
            start = this.findCeiling(fromKey, fromInc ? 0 : Integer.MAX_VALUE);
            end = this.findCeiling(toKey, toInc ? Integer.MAX_VALUE : 0);
        } else {
            start = this.findCeiling(fromKey, fromInc ? Integer.MAX_VALUE : 0);
            start = this.predecessor(start);
            end = this.findCeiling(toKey, toInc ? 0 : Integer.MAX_VALUE);
            end = this.predecessor(end);
        }
        return new KeyIterator(start, end);
    }

    public IntIterator valueRangeIterator(float fromKey, boolean fromInc, float toKey, boolean toInc) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(fromKey, fromInc, toKey, toInc));
    }

    protected int compare(AbstractTreeMap.Entry e1, AbstractTreeMap.Entry e2) {
        int c = this.cmp.compare(e1.getFloatKey(), e2.getFloatKey());
        if (this.allowDuplicates && c == 0) {
            c = e1.order < e2.order ? -1 : (e1.order > e2.order ? 1 : 0);
            this.lastOrder = 1 + (c < 0 ? e1.order : e2.order);
        }
        return c;
    }

    private AbstractTreeMap.Entry find(float key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.find(this.dummy);
        return e;
    }

    private AbstractTreeMap.Entry findPredecessor(float key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.findPredecessor(this.dummy);
        return e;
    }

    private AbstractTreeMap.Entry findCeiling(float key, int order) {
        this.dummy.key = key;
        this.dummy.order = order;
        AbstractTreeMap.Entry e = this.findCeiling(this.dummy);
        return e;
    }

    static class FloatEntry
    extends AbstractTreeMap.Entry {
        float key;

        public FloatEntry(float key, int val) {
            super(val);
            this.key = key;
        }

        public FloatEntry(float key, int val, AbstractTreeMap.Entry parent, int order) {
            super(val, parent, order);
            this.key = key;
        }

        public float getFloatKey() {
            return this.key;
        }

        public Object getKey() {
            return new Float(this.key);
        }

        public boolean keyEquals(AbstractTreeMap.Entry e) {
            return e instanceof FloatEntry && this.key == ((FloatEntry)e).key;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FloatEntry)) {
                return false;
            }
            FloatEntry e = (FloatEntry)o;
            return this.key == e.key && this.val == e.val;
        }

        public int hashCode() {
            int khash = Float.floatToIntBits(this.key);
            int vhash = this.val;
            return khash ^ vhash ^ this.order;
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + this.val;
        }

        public void copyFields(AbstractTreeMap.Entry x) {
            super.copyFields(x);
            this.key = x.getFloatKey();
        }
    }

    private class KeyIterator
    extends AbstractTreeMap.KeyIterator {
        public KeyIterator() {
        }

        public KeyIterator(AbstractTreeMap.Entry start, AbstractTreeMap.Entry end) {
            super(start, end);
        }

        public boolean isFloatSupported() {
            return true;
        }

        public float nextFloat() {
            return this.nextEntry().getFloatKey();
        }
    }
}

