/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.util;

import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.printing.IPrintHelper;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageSetupPageType;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.printing.actions.DefaultPrintActionHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.DiagramPrintingDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.DiagramPrintingPlugin;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.DiagramPrinter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class DiagramPrinterUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.printing.util.DiagramPrinterUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private static void printDiagrams(DiagramPrinter diagramPrinter, IPrintHelper helper) {
        if (helper.getDlgPrintRangePages()) {
            diagramPrinter.setPrintRangePageSelection(true);
            diagramPrinter.setPrintRangePages(helper.getDlgPagesFrom(), helper.getDlgPagesTo());
            diagramPrinter.setFitToPage(false);
        }
        if (helper.getDlgScalePercent() == -1) {
            diagramPrinter.setColumns(helper.getDlgScaleFitToM());
            diagramPrinter.setRows(helper.getDlgScaleFitToN());
            diagramPrinter.setFitToPage(true);
        } else {
            diagramPrinter.setScaledPercent(helper.getDlgScalePercent());
            diagramPrinter.setFitToPage(false);
        }
        diagramPrinter.run();
    }

    public static void printWithSettings(IEditorPart editorPart, Map diagramMap, DiagramPrinter diagramPrinter) {
        PrinterData printerData;
        int i;
        ArrayList diagramNames;
        IPrintHelper helper;
        IPreferenceStore pref = null;
        try {
            IDiagramGraphicalViewer viewer;
            Class<?> printhelperClass = Class.forName("org.eclipse.gmf.runtime.common.ui.printing.PrintHelper");
            helper = (IPrintHelper)printhelperClass.newInstance();
            diagramNames = new ArrayList(diagramMap.keySet());
            if (editorPart instanceof IDiagramWorkbenchPart && (viewer = ((IDiagramWorkbenchPart)editorPart).getDiagramGraphicalViewer()) instanceof DiagramGraphicalViewer && (pref = ((DiagramGraphicalViewer)viewer).getWorkspaceViewerPreferenceStore()).getBoolean("print.useWorkspaceSettings") && ((IDiagramWorkbenchPart)editorPart).getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore() != null) {
                pref = (IPreferenceStore)((IDiagramWorkbenchPart)editorPart).getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore();
            }
            if (pref != null) {
                helper.setDlgOrientation(pref.getBoolean("print.useLandscape"));
                PageSetupPageType storedPageType = PageSetupPageType.LETTER;
                String strPageType = pref.getString("print.page.size");
                i = 0;
                while (i < PageSetupPageType.pages.length) {
                    if (strPageType.startsWith(PageSetupPageType.pages[i].getName())) {
                        storedPageType = PageSetupPageType.pages[i];
                        break;
                    }
                    ++i;
                }
                if (storedPageType.getIndex() == PageSetupPageType.USER_DEFINED.getIndex()) {
                    NumberFormat fNumberFormat = NumberFormat.getNumberInstance();
                    String strWidth = pref.getString("print.page.width");
                    String strHeight = pref.getString("print.page.height");
                    double width = 0.0;
                    double height = 0.0;
                    try {
                        Number num = fNumberFormat.parse(strWidth);
                        width = num.doubleValue() / 0.0394;
                        num = fNumberFormat.parse(strHeight);
                        height = num.doubleValue() / 0.0394;
                        helper.setDlgPaperSize(PageSetupPageType.USER_DEFINED.getIndex(), width, height);
                    }
                    catch (ParseException e) {
                        Log.warning((Plugin)DiagramPrintingPlugin.getInstance(), (int)9, (String)e.getMessage(), (Throwable)e);
                    }
                } else {
                    helper.setDlgPaperSize(storedPageType.getIndex(), 0.0, 0.0);
                }
            }
            printerData = helper.openPrintDlg(diagramNames);
        }
        catch (Throwable e) {
            DiagramPrintingPlugin diagramPrintingPlugin = DiagramPrintingPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.printing.util.DiagramPrinterUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((Plugin)diagramPrintingPlugin, (String)DiagramPrintingDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)e.getMessage(), (Throwable)e);
            Log.warning((Plugin)DiagramPrintingPlugin.getInstance(), (int)5, (String)e.getMessage(), (Throwable)e);
            if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorTitle, (String)(String.valueOf(DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorMessage_part1) + "\n" + DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorMessage_part2 + "\n" + DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorMessage_part3 + "\n\n" + DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorMessage_part4))) {
                DefaultPrintActionHelper.doRun(editorPart, diagramPrinter);
            }
            return;
        }
        Assert.isNotNull(diagramNames);
        Assert.isNotNull((Object)helper);
        if (printerData != null) {
            Printer printer = new Printer(printerData);
            diagramPrinter.setPrinter(printer);
            diagramPrinter.setDisplayDPI(Display.getDefault().getDPI());
            if (helper.getDlgDiagramPrintRangeCurrent()) {
                DiagramEditPart dgrmEP = ((IDiagramWorkbenchPart)editorPart).getDiagramEditPart();
                if (!$assertionsDisabled && dgrmEP == null) {
                    throw new AssertionError();
                }
                diagramPrinter.setDiagrams(Collections.singletonList(dgrmEP.getDiagramView().getDiagram()));
            } else if (helper.getDlgDiagramPrintRangeAll()) {
                diagramPrinter.setDiagrams(diagramMap.values());
            } else if (helper.getDlgDiagramPrintRangeSelection()) {
                ArrayList list = new ArrayList();
                i = 0;
                while (i < diagramNames.size()) {
                    if (helper.isDlgDiagramSelected(i)) {
                        Object obj = diagramMap.get(diagramNames.get(i));
                        Assert.isTrue((boolean)(obj instanceof Diagram));
                        list.add(obj);
                    }
                    ++i;
                }
                diagramPrinter.setDiagrams(list);
            }
            DiagramPrinterUtil.printDiagrams(diagramPrinter, helper);
            printer.dispose();
        }
    }
}

