/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.gen.GenDiagramMutator;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.DiaGenSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.DomainModelFileSetup;
import org.eclipse.gmf.tests.setup.DomainModelSetup;
import org.eclipse.gmf.tests.setup.DomainModelSetupInstanceClassName;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.GenProjectBaseSetup;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.MapSetup;
import org.eclipse.gmf.tests.setup.MultiPackageGenSetup;
import org.eclipse.gmf.tests.setup.MultiplePackagesDomainModelSetup;
import org.eclipse.gmf.tests.setup.ToolDefSetup;
import org.eclipse.gmf.tests.setup.annotated.GenASetup;
import org.eclipse.gmf.tests.setup.annotated.GraphDefASetup;
import org.eclipse.gmf.tests.setup.annotated.MapDefASetup;
import org.eclipse.gmf.tests.setup.annotated.ToolDefASetup;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompilationTest
extends TestCase {
    protected final GeneratorConfiguration myGenConfig;
    protected final ViewmapProducer myViewmapProducer;
    protected MapDefASetup myMapSource;
    protected GenDiagramMutator[] myGeneralMutators;
    protected GenDiagramMutator[] myRichClientMutators;
    protected final GenDiagramMutator SAME_FILE_MUTATOR = new GenDiagramMutator("sameFileForDiagramAndModel"){
        private boolean myIsSameFileForDiagramAndModel;

        public void doMutation(GenDiagram d) {
            this.myIsSameFileForDiagramAndModel = d.getEditorGen().isSameFileForDiagramAndModel();
            d.getEditorGen().setSameFileForDiagramAndModel(!this.myIsSameFileForDiagramAndModel);
        }

        public void undoMutation(GenDiagram d) {
            d.getEditorGen().setSameFileForDiagramAndModel(this.myIsSameFileForDiagramAndModel);
        }
    };
    protected final GenDiagramMutator SYNCHRONIZED_MUTATOR = new GenDiagramMutator("synchronized"){
        private boolean myIsSynchronized;

        public void doMutation(GenDiagram d) {
            this.myIsSynchronized = d.isSynchronized();
            d.setSynchronized(!this.myIsSynchronized);
        }

        public void undoMutation(GenDiagram d) {
            d.setSynchronized(this.myIsSynchronized);
        }
    };
    protected final GenDiagramMutator SHORTCUT_STUFF_MUTATOR = new GenDiagramMutator("shortcuts"){
        private List<String> myShortcutsTo;
        private List<String> myShortcutsFor;

        public void doMutation(GenDiagram d) {
            this.myShortcutsTo = new ArrayList<String>((Collection<String>)d.getContainsShortcutsTo());
            d.getContainsShortcutsTo().clear();
            d.getContainsShortcutsTo().add((Object)d.getEditorGen().getModelID());
            this.myShortcutsFor = new ArrayList<String>((Collection<String>)d.getShortcutsProvidedFor());
            d.getShortcutsProvidedFor().clear();
            d.getShortcutsProvidedFor().add((Object)d.getEditorGen().getModelID());
        }

        public void undoMutation(GenDiagram d) {
            d.getContainsShortcutsTo().clear();
            d.getContainsShortcutsTo().addAll(this.myShortcutsTo);
            d.getShortcutsProvidedFor().clear();
            d.getShortcutsProvidedFor().addAll(this.myShortcutsFor);
        }
    };

    protected CompilationTest(String name, GeneratorConfiguration genConfig, ViewmapProducer viewmapProducer) {
        super(name);
        assert (genConfig != null);
        assert (viewmapProducer != null);
        this.myGenConfig = genConfig;
        this.myViewmapProducer = viewmapProducer;
    }

    protected void setUp() throws Exception {
        super.setUp();
        URI selected = Plugin.createURI("/models/library/library.ecore");
        DomainModelSource dmSource = new DomainModelFileSetup().init(selected);
        ToolDefASetup tdmSource = new ToolDefASetup(dmSource.getModel());
        GraphDefASetup gdmSource = new GraphDefASetup(dmSource.getModel());
        this.myMapSource = new MapDefASetup(dmSource.getModel(), tdmSource.getRegistry(), gdmSource.getCanvasDef());
        this.myGeneralMutators = new GenDiagramMutator[]{this.SAME_FILE_MUTATOR, this.SYNCHRONIZED_MUTATOR, this.SHORTCUT_STUFF_MUTATOR};
        this.myRichClientMutators = new GenDiagramMutator[]{this.SAME_FILE_MUTATOR, this.SHORTCUT_STUFF_MUTATOR};
    }

    protected DiaGenSource createLibraryGen(boolean rcp) throws Exception {
        return new GenASetup(this.myMapSource.getMapping(), this.myViewmapProducer, rcp);
    }

    public void testCompileWithStrictOptions() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", "error");
        CompilationTest.switchJavaOptions(options);
        try {
            this.testCompileMultiPackageDomain();
        }
        finally {
            CompilationTest.switchJavaOptions(options);
        }
    }

    private static void switchJavaOptions(HashMap<String, String> options) {
        Hashtable settings = JavaCore.getOptions();
        for (String key : options.keySet()) {
            String originalValue = (String)settings.get(key);
            settings.put(key, options.get(key));
            options.put(key, originalValue);
        }
        JavaCore.setOptions((Hashtable)settings);
    }

    public void testRCPCompile() throws Exception {
        DiaGenSource gmfGenSource = this.createLibraryGen(true);
        gmfGenSource.getGenDiagram().getEditorGen().setSameFileForDiagramAndModel(false);
        this.generateAndCompile(gmfGenSource, this.myRichClientMutators);
    }

    public void testCompileDiagram() throws Exception {
        DiaGenSource gmfGenSource = this.createLibraryGen(false);
        this.generateAndCompile(gmfGenSource, this.myGeneralMutators);
    }

    public void testCompilePotentialNameClashes() throws Exception {
        DomainModelSetup domainModel = new DomainModelSetup().init();
        domainModel.getNodeA().getEClass().setName("Node");
        domainModel.getNodeB().getEClass().setName("ShapeNode");
        domainModel.getLinkAsClass().getEClass().setName("ConnectionNode");
        domainModel.getNodeA().getNameAttr().setName("attribute");
        domainModel.getNodeB().getNameAttr().setName("class");
        domainModel.getDiagramElement().setName("Diagram");
        MapSetup mapSource = new MapSetup().init(new DiaDefSetup().init(), domainModel, new ToolDefSetup());
        DiaGenSetup gmfGenSource = new DiaGenSetup(this.myViewmapProducer).init(mapSource);
        this.generateAndCompile(gmfGenSource, new GenDiagramMutator[0]);
    }

    public void testCompileInstanceClassNames() throws Exception {
        DomainModelSetup domainModelSetup = new DomainModelSetupInstanceClassName().init();
        MapSetup mapSource = new MapSetup().init(new DiaDefSetup().init(), domainModelSetup, new ToolDefSetup());
        DiaGenSetup gmfGenSource = new DiaGenSetup(this.myViewmapProducer).init(mapSource);
        this.generateAndCompile(gmfGenSource, this.SYNCHRONIZED_MUTATOR);
    }

    public void testCompileMultiPackageDomain() throws Exception {
        MultiplePackagesDomainModelSetup ds = new MultiplePackagesDomainModelSetup().init();
        MapSetup ms = new MapSetup().init(new DiaDefSetup().init(), ds, new ToolDefSetup());
        LinkedHashSet<EPackage> additionalPacks = new LinkedHashSet<EPackage>(8);
        additionalPacks.add(ds.getNodeA().getEClass().getEPackage());
        additionalPacks.add(ds.getNodeB().getEClass().getEPackage());
        additionalPacks.add(ds.getLinkAsClass().getEClass().getEPackage());
        DiaGenSetup gmfGenSource = new MultiPackageGenSetup(additionalPacks).init(ms);
        this.generateAndCompile(gmfGenSource, new GenDiagramMutator[0]);
    }

    protected void generateAndCompile(DiaGenSource genSource, GenDiagramMutator ... mutators) throws Exception {
        GenEditorGenerator editorGen = genSource.getGenDiagram().getEditorGen();
        new GenProjectBaseSetup(this.myGenConfig).generateAndCompile(editorGen, mutators);
    }

    public void testPreexistingImportConflicts() throws Exception {
        DiaGenSource gmfGenSource = this.createLibraryGen(false);
        gmfGenSource.getGenDiagram().getEditorGen().setSameFileForDiagramAndModel(false);
        String pluginId = gmfGenSource.getGenDiagram().getEditorGen().getPlugin().getID();
        IProject diagramProject = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginId);
        if (!diagramProject.isAccessible()) {
            Generator.createEMFProject((IPath)diagramProject.getFolder("src").getFullPath(), null, Collections.emptyList(), (IProgressMonitor)new NullProgressMonitor(), (int)Generator.EMF_PLUGIN_PROJECT_STYLE);
        }
        IJavaProject javaProject = JavaCore.create((IProject)diagramProject);
        CompilationTest.assertTrue((boolean)javaProject.exists());
        IPackageFragment pf = javaProject.getPackageFragmentRoot((IResource)diagramProject.getFolder("src")).createPackageFragment(gmfGenSource.getGenDiagram().getNotationViewFactoriesPackageName(), false, (IProgressMonitor)new NullProgressMonitor());
        ICompilationUnit cu = pf.getCompilationUnit(String.valueOf(gmfGenSource.getGenDiagram().getNotationViewFactoryClassName()) + ".java");
        String contents = MessageFormat.format("package {0};\nimport {2};\n /**\n * @generated\n */\npublic class {1} '{ }'", gmfGenSource.getGenDiagram().getNotationViewFactoriesPackageName(), gmfGenSource.getGenDiagram().getNotationViewFactoryClassName(), "javax.swing.text.View");
        if (cu.exists()) {
            IBuffer buffer = cu.getBuffer();
            buffer.setContents(contents);
            buffer.save((IProgressMonitor)new NullProgressMonitor(), true);
        } else {
            pf.createCompilationUnit(cu.getElementName(), contents, false, (IProgressMonitor)new NullProgressMonitor());
        }
        this.generateAndCompile(gmfGenSource, new GenDiagramMutator[0]);
    }
}

