/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.emf.mint.internal.ui.actions.OpenGeneratedAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOpenGeneratedMenu
extends CompoundContributionItem
implements IWorkbenchContribution {
    private static final IContributionItem[] NO_ITEMS = new IContributionItem[0];
    private static final int DEFAULT_MIN_CATEGORY_ITEMS = 2;
    protected IServiceLocator serviceLocator;
    private List<List<IAction>> actions;
    protected AdapterFactory adapterFactory;

    protected AbstractOpenGeneratedMenu() {
    }

    protected AbstractOpenGeneratedMenu(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected final IContributionItem[] getContributionItems() {
        if (this.actions == null) {
            Object adapter;
            AdapterFactory adapterFactory;
            Object target;
            this.actions = new LinkedList<List<IAction>>();
            IMenuService svc = (IMenuService)this.serviceLocator.getService(IMenuService.class);
            Object selection = svc.getCurrentState().getVariable("activeMenuSelection");
            if (selection instanceof ISelection && (target = this.getTarget((ISelection)selection)) != null && (adapterFactory = this.getAdapterFactory(target)) != null && (adapter = adapterFactory.adapt(target, IItemJavaElementSource.class)) instanceof IItemJavaElementSource) {
                this.createActions((IItemJavaElementSource)adapter, target);
            }
        }
        if (this.actions.isEmpty()) {
            return NO_ITEMS;
        }
        ArrayList<Object> items = new ArrayList<Object>();
        boolean needsSeparator = false;
        for (List<IAction> group : this.actions) {
            if (needsSeparator) {
                items.add(new Separator());
            } else {
                needsSeparator = true;
            }
            for (IAction action : group) {
                items.add(new ActionContributionItem(action));
            }
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    protected Object getTarget(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    protected AdapterFactory getAdapterFactory(Object target) {
        if (this.adapterFactory == null) {
            this.adapterFactory = this.createAdapterFactory(target);
        }
        return this.adapterFactory;
    }

    protected AdapterFactory createAdapterFactory(Object target) {
        return new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    }

    protected Comparator<? super IItemJavaElementDescriptor> createDescriptorComparator(Object target) {
        return new DescriptorComparator(target);
    }

    protected int getMinCategoryItems() {
        return 2;
    }

    private void createActions(IItemJavaElementSource provider, Object target) {
        Iterator<List<IAction>> i;
        ArrayList descriptors = new ArrayList(provider.getJavaElementDescriptors(target));
        Collections.sort(descriptors, this.createDescriptorComparator(target));
        LinkedList<IAction> group = null;
        String category = null;
        boolean keepGroups = false;
        int categoryItemCount = 0;
        int minCategoryItems = this.getMinCategoryItems();
        for (IItemJavaElementDescriptor descriptor : descriptors) {
            String newCategory = descriptor.getCategory(target);
            if (group == null || (category == null ? newCategory != null : !category.equals(newCategory))) {
                category = newCategory;
                categoryItemCount = 0;
                group = new LinkedList<IAction>();
                this.actions.add(group);
            }
            IAction action = this.createAction(descriptor, target);
            group.add(action);
            if (++categoryItemCount <= minCategoryItems) continue;
            keepGroups = true;
        }
        if (!keepGroups && (i = this.actions.iterator()).hasNext()) {
            List<IAction> masterGroup = i.next();
            while (i.hasNext()) {
                masterGroup.addAll((Collection<IAction>)i.next());
                i.remove();
            }
        }
    }

    protected IAction createAction(IItemJavaElementDescriptor descriptor, Object target) {
        return new OpenGeneratedAction(descriptor, target);
    }

    public void dispose() {
        if (this.adapterFactory instanceof IDisposable) {
            ((IDisposable)this.adapterFactory).dispose();
            this.adapterFactory = null;
        }
        this.actions = null;
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DescriptorComparator
    implements Comparator<IItemJavaElementDescriptor> {
        protected final Object target;

        public DescriptorComparator(Object target) {
            this.target = target;
        }

        @Override
        public int compare(IItemJavaElementDescriptor o1, IItemJavaElementDescriptor o2) {
            String category1 = o1.getCategory(this.target);
            String category2 = o2.getCategory(this.target);
            if (category1 == null) {
                if (category2 != null) {
                    return -1;
                }
            } else {
                if (category2 == null) {
                    return 1;
                }
                int result = category1.compareTo(category2);
                if (result != 0) {
                    return result;
                }
            }
            String name1 = o1.getDisplayName(this.target);
            String name2 = o2.getDisplayName(this.target);
            if (name1 == null) {
                return name2 == null ? 0 : -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

